/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.util.BasisExceptionData;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BasisException
extends Exception
implements IDataPortable {
    public static final String ID = "exId";
    public static final String BUNDLENAME = "exBundle";
    public static final String PARMCOUNT = "exParmcnt";
    public static final String PARM = "exParm";
    public static final String ERRORCODE = "exError";
    public static final String REASONCODE = "exReason";
    public static final String DFLTMSG = "exDfltMsg";
    public static final String WRAPPED = "exWrapped";
    protected String _id;
    protected String _bundleName;
    protected Integer _errorCode;
    protected Integer _reasonCode;
    protected String _dfltMsg;
    protected String[] _parms;
    protected Throwable _wrappedExcpt = null;

    public BasisException() {
        this(null, null, 0, 0, null, null);
    }

    public BasisException(String id, String bundle) {
        this(id, bundle, 0, 0, null, null);
    }

    public BasisException(String id, String bundle, int errorCode, int reasonCode) {
        this(id, bundle, errorCode, reasonCode, null, null);
    }

    public BasisException(String id, String bundle, String[] parms) {
        this(id, bundle, 0, 0, parms, null);
    }

    public BasisException(String id, String bundle, int errorCode, int reasonCode, String[] parms) {
        this(id, bundle, errorCode, reasonCode, parms, null);
    }

    public BasisException(String id, String bundle, String dfltMsg) {
        this(id, bundle, 0, 0, null, dfltMsg);
    }

    public BasisException(String id, String bundle, String[] parms, String dfltMsg) {
        this(id, bundle, 0, 0, parms, dfltMsg);
    }

    public BasisException(String id, String bundle, int errorCode, int reasonCode, String[] parms, String dfltMsg) {
        this._id = id;
        this._bundleName = bundle;
        this._parms = parms;
        this._errorCode = new Integer(errorCode);
        this._reasonCode = new Integer(reasonCode);
        this._dfltMsg = dfltMsg;
    }

    public BasisException(Throwable excpt) {
        this(null, null, 0, 0, null, null);
        this._wrappedExcpt = excpt;
    }

    public BasisException(String dfltMsg, Throwable excpt) {
        this(null, null, 0, 0, null, dfltMsg);
        this._wrappedExcpt = excpt;
    }

    public BasisException(String id, String bundle, Throwable excpt) {
        this(id, bundle, 0, 0, null, null);
        this._wrappedExcpt = excpt;
    }

    public BasisException(String id, String bundle, String[] parms, Throwable excpt) {
        this(id, bundle, 0, 0, parms, null);
        this._wrappedExcpt = excpt;
    }

    public BasisException(String id, String bundle, String dfltMsg, Throwable excpt) {
        this(id, bundle, 0, 0, null, dfltMsg);
        this._wrappedExcpt = excpt;
    }

    public BasisException(String id, String bundle, String[] parms, String dfltMsg, Throwable excpt) {
        this(id, bundle, 0, 0, parms, dfltMsg);
        this._wrappedExcpt = excpt;
    }

    public BasisException(String id, String bundle, int errorCode, int reasonCode, String[] parms, String dfltMsg, Throwable excpt) {
        this(id, bundle, errorCode, reasonCode, parms, dfltMsg);
        this._wrappedExcpt = excpt;
    }

    public String getId() {
        return this._id;
    }

    public String[] getParms() {
        return this._parms;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public int getReasonCode() {
        return this._reasonCode;
    }

    public Throwable getWrappedException() {
        return this._wrappedExcpt;
    }

    public void setWrappedException(Throwable excpt) {
        this._wrappedExcpt = excpt;
    }

    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale loc) {
        return this.getMessage(loc, null);
    }

    public String getMessage(ClassLoader loader) {
        return this.getMessage(Locale.getDefault(), loader);
    }

    public String getMessage(Locale loc, ClassLoader loader) {
        ResourceBundle b = null;
        String m = null;
        try {
            if (this._bundleName != null) {
                b = loader == null ? ResourceBundle.getBundle(this._bundleName, loc) : ResourceBundle.getBundle(this._bundleName, loc, loader);
                m = b.getString(this._id);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (m == null) {
            m = this._dfltMsg;
        }
        return this.format(m);
    }

    public void printStackTrace() {
        if (this._wrappedExcpt != null) {
            this._wrappedExcpt.printStackTrace();
        }
        super.printStackTrace();
    }

    public void printStackTrace(PrintStream str) {
        if (this._wrappedExcpt != null) {
            this._wrappedExcpt.printStackTrace(str);
        }
        super.printStackTrace(str);
    }

    public void printStackTrace(PrintWriter str) {
        if (this._wrappedExcpt != null) {
            this._wrappedExcpt.printStackTrace(str);
        }
        super.printStackTrace(str);
    }

    public IData getAsData() {
        IData data = BasisExceptionData.create();
        IDataCursor cursor = data.getCursor();
        int iParms = this._parms != null ? this._parms.length : 0;
        cursor.insertAfter(ID, this._id);
        cursor.insertAfter(BUNDLENAME, this._bundleName);
        cursor.insertAfter(ERRORCODE, this._errorCode);
        cursor.insertAfter(REASONCODE, this._reasonCode);
        cursor.insertAfter(DFLTMSG, this._dfltMsg);
        cursor.insertAfter(WRAPPED, this._wrappedExcpt);
        cursor.insertAfter(PARMCOUNT, new Integer(iParms));
        for (int i = 0; i < iParms; ++i) {
            cursor.insertAfter(PARM, this._parms[i]);
        }
        cursor.destroy();
        return data;
    }

    public void setFromData(IData data) {
        IDataCursor cursor = data.getCursor();
        int cnt = 0;
        int i = 0;
        if (cursor.first(PARMCOUNT)) {
            cnt = (Integer)cursor.getValue();
        }
        if (cnt > 0) {
            this._parms = new String[cnt];
        }
        boolean rc = cursor.first();
        while (rc) {
            String key = cursor.getKey();
            if (key.equals(BUNDLENAME)) {
                this._bundleName = (String)cursor.getValue();
            } else if (key.equals(ID)) {
                this._id = (String)cursor.getValue();
            } else if (key.equals(ERRORCODE)) {
                this._errorCode = (Integer)cursor.getValue();
            } else if (key.equals(REASONCODE)) {
                this._reasonCode = (Integer)cursor.getValue();
            } else if (key.equals(DFLTMSG)) {
                this._dfltMsg = (String)cursor.getValue();
            } else if (key.equals(WRAPPED)) {
                this._wrappedExcpt = (Throwable)cursor.getValue();
            } else if (key.equals(PARM) && this._parms != null) {
                this._parms[i++] = (String)cursor.getValue();
            }
            rc = cursor.next();
        }
        cursor.destroy();
    }

    private String format(String msgformat) {
        MessageFormat mf;
        String[] oa;
        int iParms;
        String s;
        block12: {
            s = null;
            iParms = 0;
            if (this._parms != null) {
                iParms = this._parms.length;
            }
            oa = new String[iParms + 2];
            oa[0] = this._errorCode.toString();
            oa[1] = this._reasonCode.toString();
            if (iParms > 0) {
                System.arraycopy(this._parms, 0, oa, 2, iParms);
            }
            if (msgformat != null) {
                try {
                    mf = new MessageFormat(msgformat);
                    s = this._id == null ? mf.format(oa) : "[" + this._id + "] " + mf.format(oa);
                }
                catch (Exception e) {
                    if (msgformat == null) break block12;
                    s = this._id == null ? msgformat : "[" + this._id + "] " + msgformat;
                }
            }
        }
        if (s == null) {
            StringBuffer sb = new StringBuffer();
            if (this._id != null) {
                sb.append("[");
                sb.append(this._id + "]");
            }
            if (this._bundleName != null) {
                sb.append(" not found in \"");
                sb.append(this._bundleName);
                sb.append("\".");
            }
            if (this._errorCode != 0) {
                sb.append(" EC={0}");
            }
            if (this._reasonCode != 0) {
                sb.append(" RC={1}");
            }
            for (int i = 0; i < iParms; ++i) {
                sb.append(" ");
                sb.append(i);
                sb.append("={");
                sb.append(i + 2);
                sb.append("}");
            }
            mf = new MessageFormat(sb.toString());
            s = mf.format(oa);
        }
        if (this._wrappedExcpt != null) {
            s = s + " " + this._wrappedExcpt.toString() + " ";
        }
        return s;
    }

    public static void main(String[] argv) {
        String id = "ATGCORE-000001";
        String bun = "TestBundle";
        String[] parms = new String[]{"p1", "p2", "p3"};
        String dflt = "Default message: ec={0} rc={1} parm1={2}, parm2={3}, parm3={4}";
        BasisException be = new BasisException(null, null, "Dumb message...");
        System.out.println("1. dumb message\n " + be.getMessage());
        be = new BasisException("DumbMsg001", null, "Dumb message w/ dumb ID...");
        System.out.println("2. dumb message w/ dumb ID\n " + be.getMessage());
        be = new BasisException(id, bun, parms);
        System.out.println("3. no default msg\n " + be.getMessage());
        be = new BasisException(id, bun, parms, dflt);
        System.out.println("4. with default msg\n " + be.getMessage());
        be = new BasisException(id, null, parms, dflt);
        System.out.println("5. with null bundle\n " + be.getMessage());
        be = new BasisException(id, bun, 12, 345678, parms);
        System.out.println("6. with EC/RC\n " + be.getMessage());
        be = new BasisException(id, bun, 12, 345678, parms);
        System.out.println("7. use a German locale\n " + be.getMessage(Locale.GERMAN));
        be = new BasisException(id, bun, 12, 345678, parms, dflt);
        System.out.println("8. with EC/RC & default\n " + be.getMessage());
        IData d = be.getAsData();
        be = new BasisException();
        be.setFromData(d);
        System.out.println("9. exercise IDataPortable\n " + be.getMessage());
        be = new BasisException(new Exception("inner exception"));
        System.out.println("10. Wrapped exception\n " + be.getMessage());
        be.printStackTrace();
        be = new BasisException("A wrapped exception", new Exception("inner exception"));
        System.out.println("11. Wrapped exception w/ message\n " + be.getMessage());
        be.printStackTrace();
        be = new BasisException(new Exception("inner..."));
        System.out.println("12. Wrapped exception w/ message\n " + be.getMessage());
        be.printStackTrace();
        d = be.getAsData();
        be = new BasisException();
        be.setFromData(d);
        System.out.println("13. exercise IDataPortable on 12.\n " + be.getMessage());
    }
}

