/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.EncUtil;
import java.io.UnsupportedEncodingException;

public class Base64 {
    static final int[] enc = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final int x = -1;
    static final int[] dec = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 99, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    static boolean compare(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private Base64() {
    }

    public static final String encode(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        byte[] data = EncUtil.getNetBytes(str);
        return EncUtil.getNetString(Base64.encode(data));
    }

    public static final String encode(String str, boolean useNL) {
        if (str == null || str.length() == 0) {
            return null;
        }
        byte[] data = EncUtil.getNetBytes(str);
        return EncUtil.getNetString(Base64.encode(data, useNL));
    }

    public static final String encodeUTF8(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        byte[] data = null;
        try {
            data = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return EncUtil.getNetString(Base64.encode(data));
    }

    public static final String encode(String str, String encoding) {
        if (str == null || str.length() == 0) {
            return null;
        }
        byte[] data = null;
        try {
            data = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            data = EncUtil.getNetBytes(str);
        }
        return EncUtil.getNetString(Base64.encode(data));
    }

    public static final byte[] encode(byte[] data) {
        return Base64.encode(data, true);
    }

    public static final byte[] encode(byte[] data, boolean useNL) {
        if (data == null) {
            return null;
        }
        int lpos = 0;
        int spos = 0;
        int slen = data.length;
        int dpos = 0;
        int dstate = 0;
        int dlen = (slen + 2) / 3 * 4;
        if (useNL) {
            dlen += dlen / 76 * 2;
        }
        byte[] dest = new byte[dlen];
        while (spos < slen) {
            switch (dstate) {
                case 0: {
                    dest[dpos++] = (byte)enc[data[spos] >> 2 & 0x3F];
                    break;
                }
                case 1: {
                    if (spos + 1 >= slen) {
                        dest[dpos++] = (byte)enc[data[spos] << 4 & 0x30];
                        dest[dpos++] = 61;
                        dest[dpos++] = 61;
                        ++lpos;
                    } else {
                        dest[dpos++] = (byte)enc[data[spos] << 4 & 0x30 | data[spos + 1] >> 4 & 0xF];
                    }
                    ++spos;
                    break;
                }
                case 2: {
                    if (spos + 1 >= slen) {
                        dest[dpos++] = (byte)enc[data[spos] << 2 & 0x3C];
                        dest[dpos++] = 61;
                    } else {
                        dest[dpos++] = (byte)enc[data[spos] << 2 & 0x3C | data[spos + 1] >> 6 & 3];
                    }
                    ++spos;
                    break;
                }
                case 3: {
                    dest[dpos++] = (byte)enc[data[spos] & 0x3F];
                    ++spos;
                }
            }
            if (++dstate == 4) {
                dstate = 0;
            }
            if (++lpos != 76 || !useNL) continue;
            lpos = 0;
            dest[dpos++] = 13;
            dest[dpos++] = 10;
        }
        if (++lpos == 76 && useNL) {
            dest[dpos++] = 13;
            dest[dpos++] = 10;
        }
        return dest;
    }

    public static final String decode(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        byte[] data = EncUtil.getNetBytes(str);
        return EncUtil.getNetString(Base64.decode(data));
    }

    public static final String decodeUTF8(String str) {
        String ret = null;
        if (str == null || str.length() == 0) {
            return null;
        }
        byte[] data = EncUtil.getNetBytes(str);
        try {
            ret = new String(Base64.decode(data), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static final String decode(String str, String encoding) {
        String ret = null;
        if (str == null || str.length() == 0) {
            return null;
        }
        byte[] data = EncUtil.getNetBytes(str);
        try {
            ret = new String(Base64.decode(data), encoding);
        }
        catch (UnsupportedEncodingException e) {
            ret = EncUtil.getNetString(Base64.decode(data));
        }
        return ret;
    }

    public static final byte[] decode(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        int dlen = (int)((double)data.length * 0.75);
        int dpos = 0;
        byte[] dest = new byte[dlen];
        int slen = data.length;
        int spos = 0;
        int dstate = 0;
        while (spos < slen) {
            int char2;
            int char1;
            while ((char1 = dec[data[spos++]]) == -1 && spos < slen) {
            }
            if (spos >= slen) break;
            while ((char2 = dec[data[spos]]) == -1) {
                if (++spos < slen) continue;
                char2 = 99;
                break;
            }
            if (char1 == 99 || char2 == 99) break;
            switch (dstate) {
                case 0: {
                    dest[dpos++] = (byte)(char1 << 2 | char2 >> 4);
                    break;
                }
                case 1: {
                    dest[dpos++] = (byte)(char1 << 4 | char2 >> 2);
                    break;
                }
                case 2: {
                    dest[dpos++] = (byte)(char1 << 6 | char2 >> 0);
                    ++spos;
                }
            }
            if (++dstate != 3) continue;
            dstate = 0;
        }
        if (dpos < dlen) {
            byte[] sdest = new byte[dpos];
            System.arraycopy(dest, 0, sdest, 0, dpos);
            return sdest;
        }
        return dest;
    }
}

