/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.Config;
import com.wm.util.Trace;
import java.io.File;
import java.util.Calendar;

class ArchiveJob
implements Runnable {
    Trace trace;

    public ArchiveJob(Trace t) {
        this.trace = t;
    }

    private String getPadNum(int num) {
        if (num < 10) {
            return "0" + num;
        }
        return Integer.toString(num);
    }

    public File moveLog() {
        Calendar cal = Calendar.getInstance();
        String parentDir = new File(this.trace.getLogFile()).getParent();
        File dest = new File(parentDir, "daily" + File.separator + cal.get(1) + File.separator + this.getPadNum(cal.get(2) + 1) + File.separator + this.getPadNum(cal.get(5)) + File.separator + this.getPadNum(cal.get(11)) + "_" + this.getPadNum(cal.get(12)));
        dest.mkdirs();
        return dest;
    }

    public String renameLog() {
        Calendar cal = Calendar.getInstance();
        String dtstamp = cal.get(1) + this.getPadNum(cal.get(2) + 1) + this.getPadNum(cal.get(5)) + this.getPadNum(cal.get(11)) + this.getPadNum(cal.get(12));
        return dtstamp;
    }

    public void run() {
        try {
            String logrotate = Config.getProperty("rename", "watt.server.logRotate");
            if (logrotate.equalsIgnoreCase("rename")) {
                String rotationid = this.renameLog();
                this.trace.rotate(rotationid);
            } else if (logrotate.equalsIgnoreCase("move")) {
                File archiveLoc = this.moveLog();
                this.trace.rotate(archiveLoc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

