/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.UniqueApp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;

public class AppRegistry
implements Runnable {
    public static boolean DEBUG = false;
    private static final int MAXIMUM_TIME = 2000;
    private HashMap info_ = new HashMap();
    private PrintWriter out_ = null;
    private int port_;
    private ServerSocket socket_ = null;

    public AppRegistry(String iden, int port) {
        this.info_.put(iden, new Long(Long.MAX_VALUE));
        this.port_ = port;
        Thread t = new Thread((Runnable)this, "webM AppRegistry");
        t.setDaemon(true);
        t.start();
    }

    public void run() {
        AppRegistry.debugPrint("REG  running");
        this.openSocket();
        if (this.socket_ == null) {
            AppRegistry.debugPrint("REG  no socket");
        } else {
            while (this.socket_ != null) {
                this.processConnection();
            }
        }
        AppRegistry.debugPrint("REG  stopped");
    }

    public void stop() {
        AppRegistry.debugPrint("REG  stopping");
        try {
            if (this.socket_ != null) {
                this.socket_.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket_ = null;
    }

    protected void openSocket() {
        try {
            AppRegistry.debugPrint("REG  running socket server on port " + this.port_);
            this.socket_ = new ServerSocket(this.port_);
            this.socket_.setSoTimeout(3000);
        }
        catch (IOException ioe) {
            if (DEBUG) {
                ioe.printStackTrace(System.out);
            }
            AppRegistry.debugPrint("REG  failed to open socket");
            this.socket_ = null;
        }
    }

    protected void processConnection() {
        Socket connection = null;
        BufferedReader in = null;
        this.readConnection(connection, in);
        this.closeConnection(connection, in);
    }

    protected void readConnection(Socket connection, BufferedReader in) {
        try {
            while (true) {
                AppRegistry.debugPrint("REG  thread is " + Thread.currentThread() + ": waiting on socket");
                connection = this.socket_.accept();
                AppRegistry.debugPrint("REG  accepted from socket");
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                this.out_ = new PrintWriter(new OutputStreamWriter(connection.getOutputStream()));
                String line = in.readLine();
                AppRegistry.debugPrint("REG  read line: " + line);
                this.processLineReceived(line);
            }
        }
        catch (IOException ioe) {
            if (DEBUG) {
                ioe.printStackTrace(System.out);
            }
            return;
        }
    }

    protected void closeConnection(Socket connection, BufferedReader in) {
        block5: {
            try {
                if (in != null) {
                    in.close();
                }
                if (this.out_ != null) {
                    this.out_.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (IOException ioe) {
                if (!DEBUG) break block5;
                ioe.printStackTrace(System.out);
            }
        }
    }

    protected void processLineReceived(String line) {
        int pos;
        AppRegistry.debugPrint("REG  processLineReceived(" + line + ")");
        int n = pos = line == null ? -1 : line.indexOf(": ");
        if (pos != -1) {
            String type = line.substring(0, pos);
            String identifier = line.substring(pos + 2);
            if (type.equals("init")) {
                this.handleInit(identifier);
            } else if (type.equals("update")) {
                this.update(identifier);
            } else if (type.equals("quit")) {
                this.quit(identifier);
            } else {
                AppRegistry.debugPrint("REG  unknown type: '" + type + "' in line: '" + line + "'");
            }
        }
    }

    protected void handleInit(String identifier) {
        Object when = this.info_.get(identifier);
        if (when == null) {
            this.update(identifier);
        } else if (this.withinMaximum((Long)when)) {
            this.deny();
        } else {
            this.update(identifier);
        }
    }

    protected void update(String identifier) {
        Date now = new Date();
        this.info_.put(identifier, new Long(now.getTime()));
        this.ok();
    }

    protected void ok() {
        AppRegistry.debugPrint("REG  oking");
        this.out_.print("OK");
        this.out_.close();
    }

    protected void deny() {
        AppRegistry.debugPrint("REG  denying");
        this.out_.print("DENIED");
        this.out_.close();
    }

    protected void quit(String identifier) {
        AppRegistry.debugPrint("REG  quit(" + identifier + ")");
        this.info_.remove(identifier);
        this.ok();
        AppRegistry.debugPrint("REG  quit(" + identifier + "): " + this.info_);
    }

    protected boolean withinMaximum(Long when) {
        Date now = new Date();
        long nowTime = now.getTime();
        return nowTime - when < 2000L;
    }

    protected static void debugPrint(String msg) {
        if (DEBUG || UniqueApp.DEBUG) {
            UniqueApp.debugPrint(msg);
        }
    }
}

