/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.IComplexTypeCoder;
import java.util.Vector;

public class VectorCoder
extends BaseTypeCoder
implements IComplexTypeCoder {
    public static final String IDATA_ITEM_KEY = "item";

    public boolean isSimpleTypeCoder() {
        return false;
    }

    public boolean isComplexTypeCoder() {
        return true;
    }

    public Object createContainer(IData children) {
        IDataCursor cursor = children.getCursor();
        Vector<Object> vec = new Vector<Object>(10);
        while (cursor.next()) {
            vec.addElement(cursor.getValue());
        }
        return vec;
    }

    public IData breakup(Object data) {
        Vector vec = (Vector)data;
        IData idata = IDataFactory.create();
        IDataCursor idc = idata.getCursor();
        for (int i = 0; i < vec.size(); ++i) {
            idc.last();
            idc.insertAfter(IDATA_ITEM_KEY, vec.elementAt(i));
        }
        return idata;
    }

    public Class getJavaClass() {
        return Vector.class;
    }

    public static void main(String[] args) {
        VectorCoder coder = new VectorCoder();
        Vector<Object> v = new Vector<Object>();
        v.addElement("foo");
        v.addElement("now is the time for all good men");
        v.addElement(new Integer(123));
        System.out.println("Starting with " + v.toString());
        IData i = coder.breakup(v);
        System.out.println("breakup to " + i.toString());
        Vector v2 = (Vector)coder.createContainer(i);
        System.out.println("Ending with " + v2.toString());
    }
}

