/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import com.wm.soap.encoding.DateTimeCoder;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class TimeCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    public static final String COLON = ":";
    public static final String ZERO = "0";
    TimeZone defaultTimeZone = SimpleTimeZone.getDefault();
    int defaultOffset = this.defaultTimeZone.getRawOffset();

    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public String encode(Object data) {
        if (data instanceof String) {
            return (String)data;
        }
        StringBuffer sb = new StringBuffer();
        if (data instanceof GregorianCalendar) {
            int offset;
            GregorianCalendar cal = (GregorianCalendar)data;
            int i = cal.get(11);
            if (i < 10) {
                sb.append(ZERO);
            }
            sb.append(String.valueOf(i));
            sb.append(COLON);
            i = cal.get(12);
            if (i < 10) {
                sb.append(ZERO);
            }
            sb.append(String.valueOf(i));
            sb.append(COLON);
            i = cal.get(13);
            if (i < 10) {
                sb.append(ZERO);
            }
            sb.append(String.valueOf(i));
            i = cal.get(14);
            if (i > 0) {
                sb.append(".");
                sb.append(String.valueOf(i));
            }
            if ((offset = cal.getTimeZone().getRawOffset()) != this.defaultOffset) {
                if (offset == 0) {
                    sb.append("Z");
                } else {
                    int hours = offset / 3600000;
                    Integer H = new Integer(hours > 0 ? hours : -hours);
                    int minutes = offset % 3600000 / 60000;
                    Integer M = new Integer(minutes > 0 ? minutes : -minutes);
                    if (hours > 0) {
                        sb.append("+");
                    } else {
                        sb.append("-");
                    }
                    if (hours < 10 && hours > -10) {
                        sb.append(ZERO);
                    }
                    sb.append(H.toString());
                    sb.append(COLON);
                    if (minutes < 10 && minutes > -10) {
                        sb.append(ZERO);
                    }
                    sb.append(M.toString());
                }
            }
            return sb.toString();
        }
        if (data instanceof Date) {
            Date d = (Date)data;
            int i = d.getHours();
            if (i < 10) {
                sb.append(ZERO);
            }
            sb.append(String.valueOf(i));
            sb.append(COLON);
            i = d.getMinutes();
            if (i < 10) {
                sb.append(ZERO);
            }
            sb.append(String.valueOf(i));
            sb.append(COLON);
            i = d.getSeconds();
            if (i < 10) {
                sb.append(ZERO);
            }
            sb.append(String.valueOf(i));
        }
        return sb.toString();
    }

    public Object decode(String data) {
        int colon;
        int dash = data.indexOf("-");
        String tz = null;
        String gmt = null;
        int addHours = 0;
        int addMinutes = 0;
        int millis = 0;
        int Z = data.indexOf("Z");
        if (Z > 0) {
            data = data.substring(0, Z);
            gmt = "+0:0";
        }
        if (dash > 0) {
            gmt = data.substring(dash);
            tz = data.substring(dash + 1);
            data = data.substring(0, dash);
            colon = tz.indexOf(COLON);
            addHours = 0 - Integer.parseInt(tz.substring(0, colon));
            addMinutes = 0 - Integer.parseInt(tz.substring(colon + 1));
        } else {
            dash = data.indexOf("+");
            if (dash > 0) {
                gmt = data.substring(dash);
                tz = data.substring(dash + 1);
                data = data.substring(0, dash);
                colon = tz.indexOf(COLON);
                addHours = Integer.parseInt(tz.substring(0, colon));
                addMinutes = Integer.parseInt(tz.substring(colon + 1));
            }
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        colon = data.indexOf(COLON);
        if (colon > 0) {
            hour = Integer.parseInt(data.substring(0, colon));
            data = data.substring(colon + 1);
            colon = data.indexOf(COLON);
            minute = Integer.parseInt(data.substring(0, colon));
            data = data.substring(colon + 1);
            colon = data.indexOf(".");
            second = 0;
            if (colon > 0) {
                second = Integer.parseInt(data.substring(0, colon));
                millis = Integer.parseInt(data.substring(colon + 1));
            } else {
                second = Integer.parseInt(data);
            }
        }
        GregorianCalendar cal = new GregorianCalendar(1899, 11, 30, hour, minute, second);
        if (gmt != null) {
            TimeZone t = TimeZone.getTimeZone("GMT" + gmt);
            cal.setTimeZone(t);
        }
        if (millis > 0) {
            cal.add(14, millis);
        }
        return cal;
    }

    public Class getJavaClass() {
        return GregorianCalendar.class;
    }

    public static void main(String[] args) {
        TimeCoder tc = new TimeCoder();
        DateTimeCoder dtc = new DateTimeCoder();
        System.out.println(TimeZone.getDefault().toString());
        String[] tests = new String[]{"02:03:04", "12:13:14", "5:6:7", "23:23:23-05:00", "02:03:04.678", "02:03:04", "0:0:0", "24:1:2", "3:4:5-05:00", "3:4:5+06:00", "2:2:2-2:0", "3:3:3-5:30", "4:4:4Z", "5:5:5+1:1", "7:7:7+23:59", "8:8:8-23:59"};
        for (int i = 0; i < tests.length; ++i) {
            try {
                GregorianCalendar d = (GregorianCalendar)tc.decode(tests[i]);
                String en = dtc.encode(d);
                System.out.println(tests[i] + "\t round trips to:  " + en);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

