/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import com.wm.util.QName;

public class QNameCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public String encode(Object data) {
        if (data instanceof QName) {
            QName qname = (QName)data;
            return qname.getNamespace() + ":" + qname.getNCName();
        }
        if (data instanceof String) {
            return (String)data;
        }
        return data.toString();
    }

    public Object decode(String data) {
        data.trim();
        int colon = data.indexOf(":");
        QName qname = colon > 0 ? QName.create(data.substring(0, colon), data.substring(colon + 1)) : (colon == 0 ? QName.create("", data.substring(colon + 1)) : QName.create("", data));
        return qname;
    }

    public static void main(String[] args) {
        QNameCoder coder = new QNameCoder();
        String[] tests = new String[]{"a", "b", "xxx", "yyy", "", "alone", "now is the time", "for all good men"};
        for (int i = 0; i < tests.length - 1; i += 2) {
            try {
                QName q = QName.create(tests[i], tests[i + 1]);
                String en = coder.encode(q);
                QName d = (QName)coder.decode(en);
                String equals = d.equals(q) ? "\t(yes, equals)" : "\t(NOT EQUALS!)";
                System.out.println(tests[i] + ":" + tests[i + 1] + "\t encodes to:   " + en + "\t and dencodes to:  " + d.toString() + equals);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Class getJavaClass() {
        return QName.class;
    }
}

