/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import com.wm.util.xform.DateTimeDT;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ISO8601DateTimeCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    protected static final char Z = 'Z';
    protected static final char PLUS = '+';
    protected static final char MINUS = '-';
    protected static final char HYPHEN = '-';
    protected static final char DOT = '.';
    protected static final Integer UTC_RAW_OFFSET = new Integer(0);
    protected static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    protected final int YEAR = 0;
    protected final int MONTH = 1;
    protected final int DAY = 2;
    protected final int HOUR = 3;
    protected final int MINUTE = 4;
    protected final int SECOND = 5;
    protected final int MILLISECOND = 6;
    protected static final String STR_COLON = ":";
    protected static final String STR_SEPARATOR = "T";
    protected static final String STR_HYPHEN = "-";
    protected static final String STR_DOT = ".";
    protected static final String STR_Z = "Z";
    protected static final String STR_MINUS = "-";
    protected static final String STR_PLUS = "+";
    protected static final String STR_ZERO = "0";
    private static final String DASH = "-";

    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public String encode(Object data) {
        if (data.getClass() == String.class) {
            return data.toString();
        }
        Date d = (Date)data;
        return DateTimeDT.convertDate(d, "yyyy-MM-dd'T'HH:mm:ss.SSS", "GMT");
    }

    public Object decode(String data) {
        int[] timespace = new int[7];
        int dateOffset = this.parseDateInUTC(data, 0, timespace);
        if (dateOffset != -1) {
            this.parseTimeInUTC(data, dateOffset + 1, timespace);
        }
        int plusIndex = data.indexOf(43);
        String timezone = null;
        if (plusIndex == -1) {
            int minusIndex = data.lastIndexOf(45);
            int colonIndex = data.indexOf(STR_COLON);
            if (minusIndex != -1 && minusIndex > colonIndex) {
                timezone = data.substring(minusIndex);
            }
        } else {
            timezone = data.substring(plusIndex);
        }
        return this.getDate(timespace, timezone);
    }

    public Class getJavaClass() {
        return Date.class;
    }

    protected int parseDateInUTC(String data, int startIndex, int[] timespace) {
        int yearOffset = data.indexOf(45, 1);
        try {
            timespace[0] = Integer.parseInt(data.substring(startIndex, yearOffset));
            String test = data.substring(yearOffset + 1, yearOffset + 3);
            timespace[1] = Integer.parseInt(data.substring(yearOffset + 1, yearOffset + 3));
            timespace[2] = Integer.parseInt(data.substring(yearOffset + 4, yearOffset + 6));
            timespace[1] = timespace[1] - 1;
        }
        catch (Exception e) {
            Date date = new Date();
            GregorianCalendar calendar = new GregorianCalendar(UTC);
            timespace[0] = calendar.get(1);
            timespace[1] = calendar.get(2);
            timespace[2] = calendar.get(5);
            timespace[3] = calendar.get(11);
            timespace[4] = calendar.get(12);
            timespace[5] = calendar.get(13);
            timespace[6] = calendar.get(14);
            return -1;
        }
        return yearOffset + 6;
    }

    protected void parseTimeInUTC(String data, int startIndex, int[] timespace) {
        try {
            timespace[3] = Integer.parseInt(data.substring(startIndex, startIndex + 2));
            timespace[4] = Integer.parseInt(data.substring(startIndex + 3, startIndex + 5));
            timespace[5] = Integer.parseInt(data.substring(startIndex + 6, startIndex + 8));
            if (data.length() > startIndex + 8 && data.charAt(startIndex + 8) == '.') {
                int millisec;
                char end;
                int i;
                int size = data.length();
                for (i = startIndex + 9; i < size && (end = data.charAt(i)) != 'Z' && end != '+' && end != '-'; ++i) {
                }
                int fractionalSec = Integer.parseInt(data.substring(startIndex + 9, i));
                timespace[6] = millisec = (int)Math.round((double)fractionalSec / Math.pow(10.0, i - startIndex - 12));
            }
        }
        catch (Exception e) {
            GregorianCalendar calendar = new GregorianCalendar(UTC);
            timespace[3] = calendar.get(11);
            timespace[4] = calendar.get(12);
            timespace[5] = calendar.get(13);
            timespace[6] = calendar.get(14);
        }
    }

    protected Date getDate(int[] timespace) {
        return this.getDate(timespace, null);
    }

    protected Date getDate(int[] timespace, String timezone) {
        Calendar calendar = null;
        if (timezone != null) {
            timezone = "GMT" + timezone;
            calendar = this.computeCalendarInUTC(timespace, TimeZone.getTimeZone(timezone));
            GregorianCalendar utcCalendar = new GregorianCalendar(UTC);
            utcCalendar.setTimeInMillis(calendar.getTimeInMillis());
            return utcCalendar.getTime();
        }
        calendar = this.computeCalendarInUTC(timespace);
        return calendar.getTime();
    }

    protected Calendar computeCalendarInUTC(int[] timespace) {
        return this.computeCalendarInUTC(timespace, UTC);
    }

    protected Calendar computeCalendarInUTC(int[] timespace, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.set(1, timespace[0]);
        calendar.set(2, timespace[1]);
        calendar.set(5, timespace[2]);
        calendar.set(11, timespace[3]);
        calendar.set(12, timespace[4]);
        calendar.set(13, timespace[5]);
        calendar.set(14, timespace[6]);
        return calendar;
    }

    public static void main(String[] args) {
        ISO8601DateTimeCoder coder = new ISO8601DateTimeCoder();
        String[] tests = new String[]{"1991-01-01", "2001-08-13:12:13:09:99", "2000-12-31", "1970-9-2", "1966-4-23", "1850-10-4", "1066-5-6", "2055-5-5", "2222-2-22", "0001-12-31"};
        for (int i = 0; i < tests.length; ++i) {
            try {
                Date date = (Date)coder.decode(tests[i]);
                String en = coder.encode(date);
                System.out.println(tests[i] + "\t round trips to " + en);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SimpleDateFormat SOAP_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date1 = null;
        try {
            date1 = SOAP_DATE_TIME_FORMAT.parse("2002-12-25T05:00:00.000");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println(coder.encode(date1));
        System.out.println(SOAP_DATE_TIME_FORMAT.format(coder.decode(coder.encode(date1))));
    }
}

