/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import java.io.ByteArrayOutputStream;

public class HexBinaryCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    public static final String ERROR_ODD_NUMBER_OF_DIGITS = "Odd number of charactes in HexBinary string";
    public static final String ERROR_BAD_CHARACTER_IN_HEX_STRING = "Bad Chars in HexBinary string";

    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public Object decode(String digits) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < digits.length(); i += 2) {
            char c1 = digits.charAt(i);
            if (i + 1 >= digits.length()) {
                throw new IllegalArgumentException(ERROR_ODD_NUMBER_OF_DIGITS);
            }
            char c2 = digits.charAt(i + 1);
            int b = 0;
            if (c1 >= '0' && c1 <= '9') {
                b = (byte)(b + (c1 - 48) * 16);
            } else if (c1 >= 'a' && c1 <= 'f') {
                b = (byte)(b + (c1 - 97 + 10) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                b = (byte)(b + (c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException(ERROR_BAD_CHARACTER_IN_HEX_STRING);
            }
            if (c2 >= '0' && c2 <= '9') {
                b = (byte)(b + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                b = (byte)(b + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                b = (byte)(b + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException(ERROR_BAD_CHARACTER_IN_HEX_STRING);
            }
            baos.write(b);
        }
        return baos.toByteArray();
    }

    public String encode(Object data) {
        if (!(data instanceof byte[])) {
            if (data != null) {
                return data.toString();
            }
            return null;
        }
        byte[] bytes = (byte[])data;
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HexBinaryCoder.convertDigit(bytes[i] >> 4));
            sb.append(HexBinaryCoder.convertDigit(bytes[i] & 0xF));
        }
        return sb.toString();
    }

    public Class getJavaClass() {
        return byte[].class;
    }

    private static char convertDigit(int value) {
        if ((value &= 0xF) >= 10) {
            return (char)(value - 10 + 97);
        }
        return (char)(value + 48);
    }
}

