/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.IComplexTypeCoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class HashtableCoder
extends BaseTypeCoder
implements IComplexTypeCoder {
    public static final String IDATA_ITEM_KEY = "item";

    public boolean isSimpleTypeCoder() {
        return false;
    }

    public boolean isComplexTypeCoder() {
        return true;
    }

    public Object createContainer(IData children) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        IDataCursor cursor = children.getCursor();
        while (cursor.next()) {
            hash.put(cursor.getKey(), cursor.getValue());
        }
        return hash;
    }

    public IData breakup(Object data) {
        Hashtable hash = (Hashtable)data;
        IData idata = IDataFactory.create();
        IDataCursor idc = idata.getCursor();
        idc.last();
        Enumeration keys = hash.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = hash.get(key);
            idc.insertAfter(key, val);
        }
        return idata;
    }

    public Class getJavaClass() {
        return Hashtable.class;
    }

    public static void main(String[] args) {
        HashtableCoder coder = new HashtableCoder();
        Hashtable<String, Object> v = new Hashtable<String, Object>();
        v.put("foo", "bar");
        v.put("now is the time", "for all good men");
        v.put("onetwentythree", new Integer(123));
        System.out.println("Starting with " + v.toString());
        IData i = coder.breakup(v);
        System.out.println("breakup to " + i.toString());
        Hashtable v2 = (Hashtable)coder.createContainer(i);
        System.out.println("Ending with " + v2.toString());
    }
}

