/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;

public class FloatCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public String encode(Object data) {
        if (data instanceof Float) {
            float f = ((Float)data).floatValue();
            if (f == Float.POSITIVE_INFINITY) {
                return "INF";
            }
            if (f == Float.NEGATIVE_INFINITY) {
                return "-INF";
            }
        }
        return data.toString();
    }

    public Object decode(String data) {
        if (data == null) {
            return null;
        }
        if ((data = data.trim()).length() < 1) {
            return null;
        }
        if (data.equalsIgnoreCase("-INF")) {
            return new Float(Float.NEGATIVE_INFINITY);
        }
        if (data.equalsIgnoreCase("INF")) {
            return new Float(Float.POSITIVE_INFINITY);
        }
        if (data.equalsIgnoreCase("NaN")) {
            return new Float(Float.NaN);
        }
        return new Float(data);
    }

    public Class getJavaClass() {
        return Float.class;
    }

    public static void main(String[] args) {
        FloatCoder coder = new FloatCoder();
        String[] tests = new String[]{"123", "234.456", "987654", "-56565", "8.765E12", "6.543e-4", "-2.11111E-8", "0", "-0", "0.000e0", "-0E-0", "INF", "-INF", "NaN", "    123.456   ", "\n789\t\n"};
        for (int i = 0; i < tests.length; ++i) {
            try {
                Float f = (Float)coder.decode(tests[i]);
                String en = coder.encode(f);
                System.out.println(tests[i] + "\t decodes to:   " + f.toString() + " encodes to " + en);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

