/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import com.wm.soap.encoding.DateCoder;
import com.wm.soap.encoding.TimeCoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateTimeCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    private static final String DASH = "-";
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    TimeCoder tc = new TimeCoder();

    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public String encode(Object data) {
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof GregorianCalendar) {
            GregorianCalendar gc = (GregorianCalendar)data;
            String time = this.tc.encode(data);
            int year = gc.get(1);
            int month = gc.get(2);
            int day = gc.get(5);
            StringBuffer sb = new StringBuffer();
            sb.append(year);
            sb.append(DASH);
            if (month < 9) {
                sb.append("0");
            }
            sb.append(month + 1);
            sb.append(DASH);
            if (day < 10) {
                sb.append("0");
            }
            sb.append(day);
            sb.append("T");
            sb.append(time);
            return sb.toString();
        }
        if (data.getClass() != Date.class) {
            return data.toString();
        }
        String dateString = this.formatter.format((Date)data);
        return dateString;
    }

    public Object decode(String data) {
        Date d = new Date();
        int T = data.indexOf("T");
        if (T > 0) {
            String date = data.substring(0, T);
            String time = data.substring(T + 1);
            GregorianCalendar cal = (GregorianCalendar)this.tc.decode(time);
            int colon = date.indexOf(DASH);
            int year = Integer.parseInt(date.substring(0, colon));
            String dummy = date.substring(colon + 1);
            colon = dummy.indexOf(DASH);
            int month = Integer.parseInt(dummy.substring(0, colon));
            int day = Integer.parseInt(dummy.substring(colon + 1));
            cal.set(year, month - 1, day);
            return cal;
        }
        DateCoder dc = new DateCoder();
        return dc.decode(data);
    }

    public Class getJavaClass() {
        return GregorianCalendar.class;
    }

    public static void main(String[] args) {
        DateTimeCoder coder = new DateTimeCoder();
        String[] tests = new String[]{"1991-01-01T12:12:12", "2001-8-13T2:2:2", "2000-12-31", "1970-9-2T0:0:0", "1966-4-23T23:23:23.234", "1850-10-4T12:12:12-7:00", "1066-5-6T13:13:13+4:00", "2055-5-5T22:22:22-6:54", "2222-2-22T22:22:22.22-2:22", "0001-12-31"};
        for (int i = 0; i < tests.length; ++i) {
            try {
                GregorianCalendar cal = (GregorianCalendar)coder.decode(tests[i]);
                String en = coder.encode(cal);
                System.out.println(tests[i] + "\t round trips to " + en);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

