/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import com.wm.util.xform.DateTimeDT;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    private static final String DASH = "-";

    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public String encode(Object data) {
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof GregorianCalendar) {
            GregorianCalendar d = (GregorianCalendar)data;
            int year = d.get(1);
            int month = d.get(2);
            int day = d.get(5);
            StringBuffer sb = new StringBuffer();
            sb.append(year);
            sb.append(DASH);
            sb.append(month + 1);
            sb.append(DASH);
            sb.append(day);
            return sb.toString();
        }
        if (data instanceof Date) {
            return DateTimeDT.convertDate((Date)data, "yyyy-MM-dd", null);
        }
        return data.toString();
    }

    public Object decode(String data) {
        if (data == null || data.length() < 1) {
            return null;
        }
        int dash = data.indexOf(DASH);
        int year = Integer.parseInt(data.substring(0, dash));
        data = data.substring(dash + 1);
        dash = data.indexOf(DASH);
        int month = Integer.parseInt(data.substring(0, dash)) - 1;
        data = data.substring(dash + 1);
        int day = Integer.parseInt(data);
        return new Date(year - 1900, month, day);
    }

    public Class getJavaClass() {
        return Date.class;
    }

    public static void main(String[] args) {
        DateCoder coder = new DateCoder();
        String[] tests = new String[]{"1991-01-01", "2001-8-13", "2000-12-31", "1970-9-2", "1966-4-23", "1850-10-4", "1066-5-6", "2055-5-5", "2222-2-22", "0001-12-31"};
        for (int i = 0; i < tests.length; ++i) {
            try {
                Calendar cal = (Calendar)coder.decode(tests[i]);
                String en = coder.encode(cal);
                System.out.println(tests[i] + "\t round trips to " + en);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

