/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import java.math.BigInteger;

public class BigIntegerCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public String encode(Object data) {
        return data.toString();
    }

    public Object decode(String data) {
        if (data != null && (data = data.trim()).length() > 0) {
            return new BigInteger(data);
        }
        return null;
    }

    public Class getJavaClass() {
        return BigInteger.class;
    }

    public static void main(String[] args) {
        BigIntegerCoder coder = new BigIntegerCoder();
        String[] tests = new String[]{"123", "234", "987654", "-56565", "1234567890", "12345678901234567890", "123456789012345678901234567890"};
        for (int i = 0; i < tests.length; ++i) {
            try {
                BigInteger f = (BigInteger)coder.decode(tests[i]);
                String en = coder.encode(f);
                System.out.println(tests[i] + "\t decodes to:   " + f.toString() + " encodes to " + en);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

