/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.encoding;

import com.wm.soap.coder.BaseTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import java.math.BigDecimal;

public class BigDecimalCoder
extends BaseTypeCoder
implements ISimpleTypeCoder {
    public boolean isSimpleTypeCoder() {
        return true;
    }

    public boolean isComplexTypeCoder() {
        return false;
    }

    public String encode(Object data) {
        return data.toString();
    }

    public Object decode(String data) {
        if (data != null && (data = data.trim()).length() > 0) {
            return new BigDecimal(data);
        }
        return null;
    }

    public Class getJavaClass() {
        return BigDecimal.class;
    }

    public static void main(String[] args) {
        BigDecimalCoder coder = new BigDecimalCoder();
        String[] tests = new String[]{"123", "234.456", "987654", "-56565", "0", "-0", "7856767634.873487348734", "1111111111111111111111111111111111111111111111", "1.99999999999999999999999999999999999999999999991", "123456789012345678901234567890", "123456789012345678901234567890.123456789012345678901234567890"};
        for (int i = 0; i < tests.length; ++i) {
            try {
                BigDecimal f = (BigDecimal)coder.decode(tests[i]);
                String en = coder.encode(f);
                System.out.println(tests[i] + "\t decodes to:   " + f.toString() + " encodes to " + en);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

