/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.coder;

import com.wm.soap.coder.ArrayType;
import com.wm.soap.coder.Context;
import com.wm.soap.coder.SoapConstants;
import com.wm.soap.coder.StyleEncoder;
import com.wm.util.Config;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

public class Soap11Encoder
extends StyleEncoder {
    private static final boolean debug = false;
    private boolean _isLeaf;
    private boolean _encXSIType = new Boolean(Config.getProperty("true", "watt.server.SOAP.encodeXSIType"));
    private static final String LESS_THAN = "<";
    private static final String CLOSE_LESS_THAN = "</";
    private static final String GREATER_THAN = ">";
    private static final String NULL_TAG = " xsi:nil=\"true\">";
    private static final String OPEN_POSITION = " SOAP-ENC:position=\"[";
    private static final String CLOSE_POSITION = "]\"";
    private static final String OPEN_HREF = " href=\"#";
    private static final String CLOSE_HREF = "\">";
    private static final String SPACE = " ";
    private static final String EQUALS = "=\"";
    private static final String QUOTE = "\"";
    private static final String ID = "id";
    private static final String OPEN_TYPE = " xsi:type=\"";
    private static final String OPEN_SOAP_ENC_Array = " xsi:type=\"SOAP-ENC:Array\"";
    private static final String OPEN_ARRAY_TYPE = " SOAP-ENC:arrayType=\"";
    private static final char OPEN_BRACKET = '[';
    private static final char COMMA = ',';
    private static final String CLOSE_BRACKET = "]\"";
    private static final String COLON = ":";
    private static final String OPEN_NAMESPACE_DECL = " xmlns";
    private static final String OPEN_NAMESPACE_DECL_COLON = " xmlns:";
    private static final QName STRING = QName.create("http://www.w3.org/1999/XMLSchema", "string");
    private static Vector gPadding = new Vector();

    protected Soap11Encoder(Writer writer, Context context) {
        super(writer, context);
    }

    public void writeNullOpenTag(String accessor, Name xmlns, QName type, int position) throws IOException {
        this._context.pushTag(accessor);
        String typeInfo = this.encodeType(type);
        StringBuffer sb = new StringBuffer();
        if (this._context.makeItPretty()) {
            sb.append(this.composePadding(this._context.getPadding()));
            this._context.incrementPadding();
        }
        sb.append(LESS_THAN);
        sb.append(this.encodeAccessor(accessor));
        sb.append(this.encodePosition(position));
        String prefix = null;
        int idx = accessor.indexOf(COLON);
        if (idx != -1) {
            prefix = accessor.substring(0, idx);
        }
        sb.append(this.composeNamespaceDeclaration(prefix, xmlns));
        sb.append(typeInfo);
        sb.append(NULL_TAG);
        this._writer.write(sb.toString());
        this._isLeaf = true;
    }

    public void writeOpenTag(String accessor, Name xmlns, QName type, Name id, int position) throws IOException {
        this._context.pushTag(accessor);
        String typeInfo = this.encodeType(type);
        this.writeOpenTag(accessor, xmlns, typeInfo, id, position);
    }

    public void writeOpenTag(String accessor, Name xmlns, ArrayType type, Name id, int position) throws IOException {
        this._context.pushTag(accessor);
        String typeInfo = this.encodeArrayType(type);
        this.writeOpenTag(accessor, xmlns, typeInfo, id, position);
    }

    private void writeOpenTag(String accessor, Name xmlns, String type, Name id, int position) throws IOException {
        String idattr = "";
        if (id != null) {
            idattr = this.encodeAttribute(ID, id.toString());
        }
        String prefix = null;
        int idx = accessor.indexOf(COLON);
        if (idx > 0) {
            prefix = accessor.substring(0, idx);
        }
        String tag = Strings.cat(LESS_THAN, this.encodeAccessor(accessor), type, idattr, this.composeNamespaceDeclaration(prefix, xmlns), this.encodePosition(position), GREATER_THAN);
        if (this._context.makeItPretty()) {
            this._writer.write(Strings.cat(this.composePadding(this._context.getPadding()), tag));
            this._context.incrementPadding();
        } else {
            this._writer.write(tag);
        }
    }

    public void writeOpenTag(String accessor, Name xmlns, Name id, int position) throws IOException {
        this._context.pushTag(accessor);
        String prefix = null;
        int idx = accessor.indexOf(COLON);
        if (idx > 0) {
            prefix = accessor.substring(0, idx);
        }
        if (this._context.makeItPretty()) {
            this._writer.write(Strings.cat(this.composePadding(this._context.getPadding()), LESS_THAN, this.encodeAccessor(accessor), this.composeNamespaceDeclaration(prefix, xmlns), this.encodeHREF(id)));
            this._context.incrementPadding();
        } else {
            this._writer.write(Strings.cat(LESS_THAN, this.encodeAccessor(accessor), this.composeNamespaceDeclaration(prefix, xmlns), this.encodeHREF(id)));
        }
        this._isLeaf = true;
    }

    public void writeValue(String value) throws IOException {
        this._writer.write(value);
        this._isLeaf = true;
    }

    public void writeCloseTag() throws IOException {
        String accessor = this._context.popTag();
        String closeTag = Strings.cat(CLOSE_LESS_THAN, this.encodeAccessor(accessor), GREATER_THAN);
        boolean makeItPretty = this._context.makeItPretty();
        if (makeItPretty) {
            this._context.decrementPadding();
        }
        if (makeItPretty && !this._isLeaf) {
            this._writer.write(Strings.cat(this.composePadding(this._context.getPadding()), closeTag));
        } else {
            this._writer.write(closeTag);
        }
        this._isLeaf = false;
    }

    private String encodeAccessor(String accessor) {
        return accessor;
    }

    private String composePadding(int padding) {
        String ret;
        if (padding >= gPadding.size()) {
            gPadding.setSize(padding + 10);
        }
        if ((ret = (String)gPadding.elementAt(padding)) == null) {
            char[] pad = new char[2 * padding + 1];
            pad[0] = 10;
            int pos = 1;
            for (int i = 0; i < padding; ++i) {
                pad[pos++] = 32;
                pad[pos++] = 32;
            }
            ret = new String(pad);
            gPadding.setElementAt(ret, padding);
        }
        return ret;
    }

    private String encodePosition(int position) {
        if (position > -1) {
            return Strings.cat(OPEN_POSITION, Integer.toString(position), "]\"");
        }
        return "";
    }

    private String encodeHREF(Name id) {
        return Strings.cat(OPEN_HREF, id.toString(), CLOSE_HREF);
    }

    private String encodeAttribute(String name, String value) {
        return Strings.cat(SPACE, name, EQUALS, value, QUOTE);
    }

    private String encodeType(QName type) {
        QName typeInfo = type;
        if (typeInfo == null) {
            if (SoapConstants.ANONYMOUS == null) {
                return "";
            }
            typeInfo = QName.create(null, SoapConstants.ANONYMOUS);
        }
        StringBuffer sb = new StringBuffer();
        Name namespaceName = typeInfo.getNamespaceName();
        boolean addNamespaceDeclaration = false;
        String prefix = null;
        if (this._encXSIType) {
            sb.append(OPEN_TYPE);
            if (namespaceName != null) {
                prefix = this._context.getNamespacePrefix(namespaceName);
                if (prefix == null) {
                    prefix = this._context.createNamespacePrefix(namespaceName);
                    addNamespaceDeclaration = true;
                }
                sb.append(prefix);
                sb.append(COLON);
            }
            sb.append(typeInfo.getNCName());
            sb.append(QUOTE);
        }
        if (addNamespaceDeclaration) {
            sb.append(this.composeNamespaceDeclaration(prefix, namespaceName));
        }
        return sb.toString();
    }

    private String encodeArrayType(ArrayType arrayType) {
        QName type = arrayType.getItemType();
        int[] dimensions = arrayType.getDimensions();
        if (type == null) {
            if (SoapConstants.ANONYMOUS == null) {
                return "";
            }
            type = QName.create(null, SoapConstants.ANONYMOUS);
        }
        StringBuffer sb = new StringBuffer();
        Name namespaceName = type.getNamespaceName();
        boolean addNamespaceDeclaration = false;
        String prefix = null;
        if (this._encXSIType) {
            sb.append(OPEN_SOAP_ENC_Array);
        }
        sb.append(OPEN_ARRAY_TYPE);
        if (namespaceName != null) {
            prefix = this._context.getNamespacePrefix(namespaceName);
            if (prefix == null) {
                prefix = this._context.createNamespacePrefix(namespaceName);
                addNamespaceDeclaration = true;
            }
            sb.append(prefix);
            sb.append(COLON);
        }
        sb.append(type.getNCName());
        sb.append('[');
        for (int i = 0; i < dimensions.length; ++i) {
            sb.append(Integer.toString(dimensions[i]));
            if (i + 1 >= dimensions.length) continue;
            sb.append(',');
        }
        sb.append("]\"");
        if (addNamespaceDeclaration) {
            sb.append(this.composeNamespaceDeclaration(prefix, namespaceName));
        }
        return sb.toString();
    }

    private String composeNamespaceDeclaration(String prefix, Name uri) {
        if (uri != null && prefix != null) {
            return Strings.cat(OPEN_NAMESPACE_DECL_COLON, prefix, EQUALS, uri.toString(), QUOTE);
        }
        return "";
    }

    public static void main(String[] args) {
        StringWriter writer = new StringWriter();
        Context context = Context.create(0);
        context.setMakeItPretty(true);
        context.addNamespaceDeclaration(Name.create("http://www.w3.org/1999/XMLSchema"), Name.create("xsd"));
        context.addNamespaceDeclaration(Name.create("http://www.webmethods.com/2"), Name.create("webm"));
        Soap11Encoder coder = new Soap11Encoder(writer, context);
        try {
            coder.writeOpenTag("parent", (Name)null, QName.create("http://www.webmethods.com/", "basicData"), Name.create("id244"), -1);
            coder.writeNullOpenTag("foo", null, null, 5);
            coder.writeCloseTag();
            coder.writeOpenTag("boo", null, Name.create("id245"), 6);
            coder.writeCloseTag();
            coder.writeOpenTag("child", (Name)null, QName.create("http://www.webmethods.com/", "base64"), Name.create("id246"), -1);
            coder.writeValue("asdfad==");
            coder.writeCloseTag();
            int[] dim = new int[]{2, 3, 4};
            coder.writeOpenTag("child", null, new ArrayType(QName.create("http://www.w3.org/1999/XMLSchema", "string"), dim), Name.create("id247"), -1);
            coder.writeValue("5656666");
            coder.writeCloseTag();
            coder.writeCloseTag();
        }
        catch (Exception ex) {
            // empty catch block
        }
        System.out.println(writer.toString());
    }
}

