/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.coder;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.soap.coder.ArrayType;
import com.wm.soap.coder.ArrayTypeParser;
import com.wm.soap.coder.Context;
import com.wm.soap.coder.EncodingRegistry;
import com.wm.soap.coder.IComplexTypeCoder;
import com.wm.soap.coder.ISimpleTypeCoder;
import com.wm.soap.coder.ITypeCoder;
import com.wm.soap.coder.NamespaceUtil;
import com.wm.soap.coder.ProcessingState;
import com.wm.soap.coder.SoapArrayElementForwardRef;
import com.wm.soap.coder.SoapCoderException;
import com.wm.soap.coder.SoapCoderRuntimeException;
import com.wm.soap.coder.SoapConstants;
import com.wm.soap.coder.SoapForwardRef;
import com.wm.soap.coder.SoapObjectForwardRef;
import com.wm.soap.coder.StyleDecoder;
import com.wm.soap.coder.WireMetaTag;
import com.wm.soap.coder.resources.SoapCoderRuntimeExceptionBundle;
import com.wm.soap.encoding.BasicDataCoder;
import com.wm.soap.encoding.CharacterCoder;
import com.wm.util.JournalLogger;
import com.wm.util.List;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.XMLUtils;
import java.util.Map;

public class SOAP11Decoder
extends StyleDecoder {
    private static final boolean debug = false;
    private static final boolean debug1 = false;
    private static final boolean debugDecode = false;
    private static final boolean debug2 = false;
    private static final boolean debug3 = false;
    private static final boolean debug4 = false;
    private static final boolean debugVerbose = false;
    private static final Name TYPE = Name.create("type");
    private static final Name NULL = Name.create("null");
    private static final Name NIL = Name.create("nil");
    private static final String ONE = "1";
    private static final String ZERO = "0";
    private static final Name ARRAY_TYPE = Name.create("arrayType");
    private static final Name POSITION = Name.create("position");
    private static final Name OFFSET = Name.create("offset");
    private static final Name XSI_LC = Name.create("http://www.w3.org/1999/XMLSchema-instance");
    private static final Name XSI_CR = Name.create("http://www.w3.org/2000/10/XMLSchema-instance");
    private static final Name XSI_10 = Name.create("http://www.w3.org/2001/XMLSchema-instance");
    private static final int iXSI_NIL = 0;
    private static final int iXSI_NULL_CR = 1;
    private static final int iXSI_NULL_LC = 2;
    private static final int iHREF = 3;
    private static final int iID = 4;
    private static final int iXSI_TYPE_10 = 5;
    private static final int iXSI_TYPE_CR = 6;
    private static final int iXSI_TYPE_LC = 7;
    private static final int iSOAP_ENC_ARRAY_TYPE = 8;
    private static final int iSOAP_ENC_POSITION = 9;
    private static final int iSOAP_ENC_OFFSET = 10;
    private static final int iSOAP_ENC_ROOT = 11;
    private static final int iPLAN_B = 12;
    private static final QName XSI_NIL = QName.create(XSI_10, NIL);
    private static final QName XSI_NULL_CR = QName.create(XSI_CR, NULL);
    private static final QName XSI_NULL_LC = QName.create(XSI_LC, NULL);
    private static final QName HREF = QName.create(null, Name.create("href"));
    private static final QName ID = QName.create(null, Name.create("id"));
    private static final QName XSI_TYPE_10 = QName.create(XSI_10, TYPE);
    private static final QName XSI_TYPE_CR = QName.create(XSI_CR, TYPE);
    private static final QName XSI_TYPE_LC = QName.create(XSI_LC, TYPE);
    private static final QName SOAP_ENC_ARRAY_TYPE = QName.create(SoapConstants.SOAP_ENCODING_11_NS, ARRAY_TYPE);
    private static final QName SOAP_ENC_POSITION = QName.create(SoapConstants.SOAP_ENCODING_11_NS, POSITION);
    private static final QName SOAP_ENC_OFFSET = QName.create(SoapConstants.SOAP_ENCODING_11_NS, OFFSET);
    private static final QName SOAP_ENC_ROOT = QName.create(SoapConstants.SOAP_ENCODING_11_NS, SoapConstants.ROOT);
    private static final QName PLAN_B = QName.create(null, "anonymous");
    private static final QName[] WIRE_META_TAGS = new QName[]{XSI_NIL, XSI_NULL_CR, XSI_NULL_LC, HREF, ID, XSI_TYPE_10, XSI_TYPE_CR, XSI_TYPE_LC, SOAP_ENC_ARRAY_TYPE, SOAP_ENC_POSITION, SOAP_ENC_OFFSET, SOAP_ENC_ROOT, PLAN_B};
    private static final WireMetaTag NON_DESCRIPTIVE = new WireMetaTag(12, "trash");

    protected SOAP11Decoder(Context context, EncodingRegistry registry) {
        super(context, registry);
    }

    public void startDecoding() {
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(ElementNode node) throws SoapCoderRuntimeException {
        block72: {
            currentState = new ProcessingState();
            previousState = this._context.getCurrentState();
            mode = 500;
            meta = null;
            typeCoder = null;
            id = null;
            accessor = null;
            accessorName = null;
            accessorQName = null;
            if (this._context.isLegacyCall()) {
                accessor = NCName.decode(node.getNodeName().toString());
                accessorName = Name.create(accessor);
                currentState.setAccessor(accessor);
                accessorQName = QName.create(node.getNamespaceUri(), accessorName);
            } else {
                accessor = this._context.isProviderSideCoder() != false && this._context.isWsdlFirstProvider() == false ? XMLUtils.decodeQName(node.getNodeName()) : node.getNodeName();
                try {
                    accessorQName = QName.computeQName(accessor, node);
                }
                catch (WMDocumentException wmd) {
                    throw new SoapCoderRuntimeException(wmd);
                }
                catch (RuntimeException re) {
                    throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.RUNTIME_EXCEPTION, "");
                }
                if (accessorQName != null && accessorQName.getNamespaceName() != null) {
                    record = previousState.getMeta();
                    if (record == null) {
                        forwardReference = this._context.getForwardRef(previousState.getID());
                        if (forwardReference != null) {
                            record = forwardReference.getField();
                        }
                        if (record == null) {
                            record = this._context.getSchema();
                        }
                    }
                    if ((uriPrefixMapCursor = (uriPrefixMap = SOAP11Decoder.makeURIPrefixMap(nsDecls = NamespaceUtil.getNsDecls(record))).getCursor()).first(accessorQName.getNamespace())) {
                        accessorPrefix = (String)uriPrefixMapCursor.getValue();
                        accessor = accessorPrefix != null && accessorPrefix.trim().equals("") == false ? uriPrefixMapCursor.getValue() + ":" + accessorQName.getNCName() : accessorQName.getNCName();
                    }
                    uriPrefixMapCursor.destroy();
                }
                accessorName = Name.create(accessor);
                currentState.setAccessor(accessor);
            }
            value = null;
            nil = false;
            arrayType = null;
            schemaType = null;
            topLevelNotRoot = false;
            if (previousState.isRoot()) {
                rootValue = XMLUtils.getAttributeValue(node, SoapConstants.SOAP_ENCODING_11_NS, SoapConstants.ROOT);
                if (this._context.notProcessedRoot() && (rootValue == null || rootValue.equals("1"))) {
                    mode = 0;
                    meta = this._context.getSchema();
                    this._context.setProcessedRoot(true);
                    value = IDataFactory.create();
                    typeCoder = this._er.getTypeCoder(SoapConstants.DEFAULT_IDATA);
                } else {
                    topLevelNotRoot = true;
                }
            }
            isNil = false;
            nilMeta = null;
            nilTypeCoder = null;
            nilValue = null;
            if (mode == 0) break block72;
            wireMetaTags = this.getWireMetaTags(node);
            block25: for (i = 0; i < wireMetaTags.length; ++i) {
                switch (wireMetaTags[i].tag) {
                    case 0: 
                    case 1: 
                    case 2: {
                        nil = this.isNil(wireMetaTags[i].value);
                        if (!nil) continue block25;
                        mode = 1;
                        isNil = true;
                        nilMeta = meta;
                        nilTypeCoder = typeCoder;
                        nilValue = value;
                        continue block25;
                    }
                    case 3: {
                        href = Name.create(wireMetaTags[i].value.substring(1));
                        mode = 2;
                        value = this._context.getObject(href);
                        if (value != null) continue block25;
                        parentArrayType = previousState.getArrayType();
                        try {
                            fr = null;
                            if (parentArrayType == null) {
                                fr = new SoapObjectForwardRef(href, previousState.getCursor());
                                meta = this.getMeta(previousState.getMeta(), accessor);
                                fr.setField(meta);
                            } else {
                                fr = new SoapArrayElementForwardRef(href);
                                fr.setField(previousState.getMeta());
                                value = fr;
                            }
                            fr.setAccessor(accessorQName);
                            this._context.addForwardRef(fr);
                        }
                        catch (SoapCoderException sce) {}
                        continue block25;
                    }
                    case 4: {
                        id = Name.create(wireMetaTags[i].value);
                        currentState.setID(id);
                        continue block25;
                    }
                    case 9: {
                        position = ArrayTypeParser.parseArrayPoint(wireMetaTags[i].value);
                        this.moveToPosition(previousState, position);
                        continue block25;
                    }
                    case 10: {
                        offset = ArrayTypeParser.parseArrayPoint(wireMetaTags[i].value);
                        this.populateNull(currentState, offset);
                        continue block25;
                    }
                    case 11: {
                        continue block25;
                    }
                    case 8: {
                        if (arrayType == null) {
                            try {
                                arrayType = ArrayTypeParser.parse(this._context.getEncodingStyle(), wireMetaTags[i].value, node);
                                currentState.setArrayType(arrayType);
                            }
                            catch (SoapCoderRuntimeException lre) {
                                JournalLogger.log(21, 76, 1, (Object)wireMetaTags[i].value);
                                throw lre;
                            }
                            mode = 4;
                        }
                    }
                    default: {
                        if (topLevelNotRoot && currentState.getID() != null) {
                            fr = this._context.getForwardRef(currentState.getID());
                            if (fr != null) {
                                parentMeta = fr.getField();
                                accessorQName = fr.getAccessor();
                            } else {
                                parentMeta = previousState.getMeta();
                            }
                        } else {
                            parentMeta = previousState.getMeta();
                        }
                        v0 = hasNil = mode == 1;
                        if (!hasNil) {
                            for (j = i + 1; j < wireMetaTags.length; ++j) {
                                if (wireMetaTags[j].tag != 0 && wireMetaTags[j].tag != 1 && wireMetaTags[j].tag != 2) continue;
                                hasNil = true;
                                break;
                            }
                        }
                        try {
                            if (hasNil && node.getFirstChildWm() == null) {
                                continue block25;
                            }
                        }
                        catch (WMDocumentException wmE) {
                            // empty catch block
                        }
                        if (mode != 4 && previousState.getMode() == 4) {
                            meta = parentMeta;
                            typeCoder = meta != null && meta.getType() == 1 ? this._er.getTypeCoder(String.class) : this.getTypeCoder(node, previousState, meta);
                            if (typeCoder == null) {
                                typeCoder = previousState.getTypeCoder();
                            }
                            mode = 3;
                        } else if (mode != 4 && currentState.getID() != null && this._context.getForwardRef(currentState.getID()) != null) {
                            meta = parentMeta;
                        } else {
                            typeCoder = null;
                            for (j = i + 1; j < wireMetaTags.length; ++j) {
                                if (wireMetaTags[j].tag != 8) continue;
                                arrayType = ArrayTypeParser.parse(this._context.getEncodingStyle(), wireMetaTags[j].value, node);
                                currentState.setArrayType(arrayType);
                                mode = 4;
                                break;
                            }
                            meta = this.getMeta(parentMeta, accessor);
                        }
                        if (meta != null && (meta.getType() != 3 || typeCoder != null)) ** GOTO lbl210
                        if (arrayType != null) {
                            schemaType = arrayType.getItemType();
                            mode = 4;
                        } else {
                            try {
                                schemaType = QName.computeQName(wireMetaTags[i].value, node);
                                mode = 3;
                            }
                            catch (WMDocumentException wmd) {
                                throw new SoapCoderRuntimeException(wmd);
                            }
                            catch (RuntimeException re) {
                                throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.RUNTIME_EXCEPTION, "");
                            }
                        }
                        if (typeCoder == null) {
                            typeCoder = this._er.getTypeCoder(schemaType);
                        }
                        if (typeCoder == null && meta != null && meta.getJavaWrapperType() == 3) {
                            try {
                                typeCoder = (ITypeCoder)CharacterCoder.class.newInstance();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (meta != null && (dim = meta.getDimensions()) == 1 && mode != 4) {
                            mode = 5;
                        }
                        if (typeCoder != null) continue block25;
                        isComplex = false;
                        try {
                            child = node.getFirstChildWm();
                            while (child != null) {
                                if (child.getNodeType() == 3) ** GOTO lbl186
                                isComplex = true;
                                break;
lbl186:
                                // 1 sources

                                child = node.getNextSiblingOfChild(child);
                            }
                        }
                        catch (WMDocumentException wmd) {
                            throw new SoapCoderRuntimeException(wmd);
                        }
                        if (!isComplex) {
                            currentSchema = this._context.getSchema();
                            if (currentSchema == null) {
                                typeCoder = this._er.getTypeCoder(SoapConstants.DEFAULT_SIMPLE_CODER_PRIMITIVE_TYPE);
                                continue block25;
                            }
                            elem = this.getElement(node, currentSchema, mode == 4 ? 1 : 0);
                            if (elem == null) {
                                if (mode == 4 && parentMeta != null && parentMeta instanceof NSRecord) {
                                    typeCoder = this._er.getTypeCoder(SoapConstants.DEFAULT_COMPLEX_CODER_PRIMITIVE_TYPE);
                                    continue block25;
                                }
                                typeCoder = this._er.getTypeCoder(SoapConstants.DEFAULT_SIMPLE_CODER_PRIMITIVE_TYPE);
                                continue block25;
                            }
                            if (elem.getType() == 2 || elem.getType() == 4) {
                                typeCoder = this._er.getTypeCoder(SoapConstants.DEFAULT_COMPLEX_CODER_PRIMITIVE_TYPE);
                                continue block25;
                            }
                            typeCoder = this._er.getTypeCoder(SoapConstants.DEFAULT_SIMPLE_CODER_PRIMITIVE_TYPE);
                            continue block25;
                        }
                        typeCoder = this._er.getTypeCoder(SoapConstants.DEFAULT_COMPLEX_CODER_PRIMITIVE_TYPE);
                        continue block25;
lbl210:
                        // 1 sources

                        if (typeCoder != null) continue block25;
                        type = meta.getType();
                        if (type == 1) {
                            typeCoder = this._er.getTypeCoder(String.class);
                        } else {
                            schemaType = meta.getSchemaTypeName();
                            if (schemaType != null) {
                                typeCoder = this._er.getTypeCoder(schemaType);
                            }
                            if (typeCoder == null) {
                                typeCoder = this._er.getTypeCoder(SoapConstants.DEFAULT_COMPLEX_CODER_PRIMITIVE_TYPE);
                            }
                        }
                        dim = meta.getDimensions();
                        if (dim == 0) {
                            mode = 3;
                            continue block25;
                        }
                        if (dim != 1 || mode == 4) continue block25;
                        mode = 5;
                    }
                }
            }
        }
        if (mode == 500 && (tempTypeCoder = this._er.getTypeCoder(elementName = QName.create(node.getNamespaceUri(), accessorName))) != null) {
            mode = 3;
            typeCoder = tempTypeCoder;
        }
        if (isNil) {
            currentState.setMeta(nilMeta);
            currentState.setMode(1);
            currentState.setTypeCoder(nilTypeCoder);
            currentState.setValue(nilValue);
        } else {
            currentState.setMeta(meta);
            currentState.setMode(mode);
            if (typeCoder instanceof BasicDataCoder && (newTypeCoder = this.getTypeCoder(meta)) != null) {
                typeCoder = newTypeCoder;
            }
            currentState.setTypeCoder(typeCoder);
            currentState.setValue(value);
        }
        this._context.pushState(currentState);
    }

    private static IData makeURIPrefixMap(IData nsdeclList) {
        IData uriList = null;
        if (nsdeclList != null) {
            uriList = IDataFactory.create(4);
            IDataCursor idc = nsdeclList.getCursor();
            IDataCursor uriListCursor = uriList.getCursor();
            while (idc.next()) {
                String nextkey = idc.getKey();
                String value = (String)idc.getValue();
                uriListCursor.last();
                uriListCursor.insertAfter(value, nextkey);
            }
            idc.destroy();
            uriListCursor.destroy();
        }
        return uriList;
    }

    private ITypeCoder getTypeCoder(ElementNode node, ProcessingState previousState, NSField field) {
        QName type;
        String datatype = node.getAttributeValue(XSI_10, TYPE);
        ITypeCoder typeCoder = null;
        if (datatype != null) {
            try {
                type = QName.computeQName(datatype, node);
                if (type != null) {
                    typeCoder = this._er.getTypeCoder(type);
                }
            }
            catch (WMDocumentException e) {}
        } else if (previousState.getArrayType() != null && (type = previousState.getArrayType().getItemType()) != null) {
            typeCoder = this._er.getTypeCoder(type);
        }
        if (typeCoder == null && field != null && field.getJavaWrapperType() == 3) {
            try {
                typeCoder = (ITypeCoder)CharacterCoder.class.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return typeCoder;
    }

    private ITypeCoder getTypeCoder(NSField field) {
        ITypeCoder typeCoder = null;
        if (field != null && field.getJavaWrapperType() == 3) {
            try {
                typeCoder = (ITypeCoder)CharacterCoder.class.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return typeCoder;
    }

    public void characters(String chars) {
        ProcessingState currentState = this._context.getCurrentState();
        int mode = currentState.getMode();
        if (mode == 2 || mode == 1 || mode == 0) {
            return;
        }
        ArrayType arrayType = currentState.getArrayType();
        if (arrayType != null && arrayType.isEmptyArray()) {
            return;
        }
        ITypeCoder coder = currentState.getTypeCoder();
        if (coder == null) {
            return;
        }
        if (coder.isComplexTypeCoder()) {
            JournalLogger.log(16, 76, 3, (Object)currentState.getAccessor());
            coder = this._er.getTypeCoder(String.class);
        }
        currentState.setValue(((ISimpleTypeCoder)coder).decode(chars));
    }

    public void endElement() throws SoapCoderRuntimeException {
        ProcessingState previousState;
        ProcessingState currentState = this._context.popState();
        int mode = currentState.getMode();
        Name id = currentState.getID();
        Object value = currentState.getValue();
        ITypeCoder coder = currentState.getTypeCoder();
        switch (mode) {
            case 1: 
            case 2: {
                break;
            }
            case 4: {
                ArrayType arrayType = currentState.getArrayType();
                int[] dimensions = arrayType.getDimensions();
                if (dimensions.length == 1 && dimensions[0] == -1) {
                    dimensions[0] = currentState.getNumberOfChildren();
                }
                if ((value = coder.createArray(dimensions)) == null) {
                    JournalLogger.log(23, 76, 1);
                    throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.CREATE_ARRAY, arrayType != null ? arrayType.toString() : "");
                }
                IData children = currentState.getChildren();
                IDataCursor cursor = children.getCursor();
                if (cursor.first()) {
                    this.populateArray(this._context.getCurrentState(), (Object[])value, cursor);
                }
                cursor.destroy();
                break;
            }
            default: {
                if (coder == null || !coder.isComplexTypeCoder()) break;
                IComplexTypeCoder complexCoder = (IComplexTypeCoder)coder;
                value = complexCoder.createContainer(currentState.getChildren());
            }
        }
        if (currentState.containsArray) {
            this.populateArrays(currentState);
            value = currentState.getChildren();
        }
        if (id != null && value != null) {
            this._context.put(id, value);
        }
        if ((previousState = this._context.getCurrentState()) != null) {
            NSField meta = currentState.getMeta();
            String name = null;
            name = meta != null && meta.getName() != null ? meta.getName() : currentState.getAccessor();
            if (currentState.getMode() == 5) {
                previousState.containsArray = true;
                previousState.addListElement(name);
                previousState.listEementName = name;
                if (value.getClass().isArray()) {
                    previousState.addChildArray(name, currentState.listEementName, value);
                } else {
                    previousState.addChild(name, value);
                }
            } else {
                previousState.addChild(name, value);
            }
        }
        if (mode == 0) {
            this._context.setPipeline((IData)value);
        }
        currentState.clear();
    }

    public void endDecoding() {
    }

    private int computeWireMetaTagID(QName attrName) {
        for (int i = 0; i < WIRE_META_TAGS.length; ++i) {
            if (WIRE_META_TAGS[i] != attrName) continue;
            return i;
        }
        return -1;
    }

    private boolean isNil(String nilValue) {
        if (nilValue.equals(ONE)) {
            return true;
        }
        if (nilValue.equals(ZERO)) {
            return false;
        }
        return Boolean.valueOf(nilValue);
    }

    private NSField getMeta(NSField field, String accessor) {
        if (field == null) {
            return null;
        }
        NSField meta = null;
        int type = field.getType();
        String localname = null;
        int prefix = -1;
        prefix = accessor.indexOf(58);
        if (prefix != -1) {
            localname = accessor.substring(prefix + 1);
        }
        if (type == 2 || type == 4) {
            String fieldname;
            int i;
            NSRecord rec = (NSRecord)field;
            NSField[] fields = rec.getFields();
            for (i = 0; i < fields.length; ++i) {
                fieldname = fields[i].getName();
                if (!fieldname.equals(accessor)) continue;
                meta = fields[i];
                break;
            }
            if (meta == null && localname != null) {
                for (i = 0; i < fields.length; ++i) {
                    fieldname = fields[i].getName();
                    if (!fieldname.equals(localname)) continue;
                    meta = fields[i];
                    break;
                }
            }
        }
        return meta;
    }

    private void populateNull(ProcessingState state, int[] offset) {
        ArrayType arrayType = state.getArrayType();
        if (arrayType != null) {
            int count = this.count(offset, arrayType.getDimensions());
            for (int i = 0; i < count; ++i) {
                NSField meta = state.getMeta();
                if (meta != null && meta.getName() != null) {
                    state.addChild(meta.getName(), null);
                    continue;
                }
                state.addChild(state.getAccessor(), null);
            }
        }
    }

    private void moveToPosition(ProcessingState state, int[] position) throws SoapCoderRuntimeException {
        ArrayType arrayType = state.getArrayType();
        if (arrayType != null) {
            int desiredPosition = this.count(position, arrayType.getDimensions());
            int currentPosition = state.getNumberOfChildren();
            if (currentPosition == desiredPosition) {
                return;
            }
            if (currentPosition > desiredPosition) {
                // empty if block
            }
            while (currentPosition < desiredPosition) {
                NSField meta = state.getMeta();
                if (meta != null && meta.getName() != null) {
                    state.addChild(meta.getName(), null);
                } else {
                    state.addChild(state.getAccessor(), null);
                }
                ++currentPosition;
            }
        }
    }

    private int count(int[] point, int[] dimensions) {
        if (point.length != dimensions.length) {
            System.out.println("Soap11Decoder.count length mismatch!");
        }
        int count = 1;
        if (point.length == 0) {
            count = 1;
        } else {
            int radix = 1;
            count = 0;
            for (int i = point.length - 1; i >= 0; --i) {
                count = point[i] * radix + count;
                radix *= dimensions[i];
            }
        }
        return count;
    }

    private void populateArrays(ProcessingState currentState) {
        Map listElements = currentState.getListElements();
        ITypeCoder coder = currentState.getTypeCoder();
        IData children = currentState.getChildren();
        IDataCursor cursor = children.getCursor();
        for (String key : listElements.keySet()) {
            Integer count = (Integer)listElements.get(key);
            Object[] valueArray = (Object[])coder.createArray(new int[]{count});
            int i = 0;
            boolean insertBefore = false;
            while (cursor.first(key)) {
                valueArray[i] = cursor.getValue();
                insertBefore = cursor.hasMoreData();
                cursor.delete();
                ++i;
            }
            if (insertBefore) {
                cursor.insertBefore(key, valueArray);
                continue;
            }
            cursor.insertAfter(key, valueArray);
        }
        cursor.destroy();
    }

    private void populateArray(ProcessingState previousState, Object[] array, IDataCursor cursor) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null && array[i].getClass().isArray()) {
                this.populateArray(previousState, (Object[])array[i], cursor);
                continue;
            }
            Object o = cursor.getValue();
            if (o instanceof SoapForwardRef) {
                SoapArrayElementForwardRef fr = (SoapArrayElementForwardRef)o;
                fr.setOffset(i);
                fr.setObjectArray(array);
            } else {
                array[i] = o;
            }
            if (cursor.next()) continue;
            return;
        }
    }

    private WireMetaTag[] getWireMetaTags(ElementNode node) {
        List list = new List(4);
        boolean ignoreType = false;
        boolean foundType = false;
        block5: for (Attribute attr = node.getFirstAttribute(); attr != null; attr = attr.getNext()) {
            QName attrName = QName.create(attr.getNamespaceUri(), attr.getLocalNameWm());
            int tag = this.computeWireMetaTagID(attrName);
            String value = attr.getValue();
            switch (tag) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    ignoreType = true;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    foundType = true;
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    continue block5;
                }
            }
            list.addElement(new WireMetaTag(tag, value));
        }
        if (!ignoreType && !foundType) {
            list.addElement(NON_DESCRIPTIVE);
        }
        Object[] tags = new WireMetaTag[list.size()];
        list.copyInto(tags);
        return tags;
    }

    private NSField getElement(ElementNode node, NSRecord root, int dim) {
        if (node != null && node.getLocalName() != null && root != null) {
            NSField[] children = root.getFields();
            String nodeName = node.getLocalName().toString();
            if (children != null) {
                NSField child;
                int index;
                for (index = 0; index < children.length; ++index) {
                    child = children[index];
                    if (!nodeName.equals(child.getName()) || child.getDimensions() != dim) continue;
                    return child;
                }
                for (index = 0; index < children.length; ++index) {
                    NSField elem;
                    child = children[index];
                    if (child.getType() != 2 && child.getType() != 4 || (elem = this.getElement(node, (NSRecord)child, dim)) == null) continue;
                    return elem;
                }
            }
        }
        return null;
    }
}

