/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.coder;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.util.Name;
import com.wm.util.QName;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceUtil {
    public static final String ATTR_PRIFIX = "@";
    public static final String COLON = ":";

    public static IData getNsDecls(NSField field) {
        HashMap<String, String> alreadyVisitedFields = new HashMap<String, String>();
        HashMap<String, String> reverseNsDecls = new HashMap<String, String>();
        IData nsDecls = IDataFactory.create();
        IDataCursor cursor = nsDecls.getCursor();
        if (field != null) {
            String fieldName = field.getName();
            Name xmlns = null;
            if (fieldName != null) {
                QName qxmlns;
                int colonPos = fieldName.indexOf(COLON);
                String prefix = null;
                if (colonPos != -1 && (prefix = fieldName.substring(0, colonPos)).startsWith(ATTR_PRIFIX)) {
                    prefix = prefix.substring(1);
                }
                if ((xmlns = field.getXmlNamespace()) == null && field instanceof NSRecord && (qxmlns = ((NSRecord)field).getUniversalName()) != null) {
                    xmlns = qxmlns.getNamespaceName();
                }
                if (prefix != null && xmlns != null) {
                    IDataUtil.put(cursor, prefix, xmlns.toString());
                    reverseNsDecls.put(xmlns.toString(), prefix);
                }
            }
            if (field instanceof NSRecordRef) {
                NamespaceUtil.getNsDeclsRecursively(((NSRecordRef)field).getNSRecord(), nsDecls, cursor, alreadyVisitedFields, ((NSRecordRef)field).getTargetName().getFullName(), reverseNsDecls);
            } else if (field instanceof NSRecord) {
                NamespaceUtil.getNsDeclsRecursively((NSRecord)field, nsDecls, cursor, alreadyVisitedFields, null, reverseNsDecls);
            }
            if (xmlns != null) {
                if (reverseNsDecls.containsKey(xmlns.toString())) {
                    IDataUtil.put(cursor, (String)reverseNsDecls.get(xmlns.toString()), xmlns.toString());
                } else {
                    IDataUtil.put(cursor, "ser-root", xmlns.toString());
                    reverseNsDecls.put(xmlns.toString(), "ser-root");
                }
            }
        }
        cursor.destroy();
        return nsDecls;
    }

    private static void getNsDeclsRecursively(NSRecord record, IData nsDecls, IDataCursor cursor, Map<String, String> alreadyVisitedFields, String docType, Map<String, String> reverseNsDecls) {
        if (record == null) {
            return;
        }
        if (docType != null) {
            if (alreadyVisitedFields.containsKey(docType)) {
                return;
            }
            alreadyVisitedFields.put(docType, docType);
        }
        int noOfFields = record.getFieldCount();
        for (int index = 0; index < noOfFields; ++index) {
            NSField field = record.getField(index);
            if (field == null) continue;
            String fieldName = field.getName();
            if (fieldName != null) {
                int colonPos = fieldName.indexOf(COLON);
                String prefix = null;
                if (colonPos != -1 && (prefix = fieldName.substring(0, colonPos)).startsWith(ATTR_PRIFIX)) {
                    prefix = prefix.substring(1);
                }
                Name xmlns = field.getXmlNamespace();
                if (prefix != null && xmlns != null) {
                    IDataUtil.put(cursor, prefix, xmlns.toString());
                    reverseNsDecls.put(xmlns.toString(), prefix);
                }
            }
            if (field instanceof NSRecordRef) {
                NamespaceUtil.getNsDeclsRecursively(((NSRecordRef)field).getNSRecord(), nsDecls, cursor, alreadyVisitedFields, ((NSRecordRef)field).getTargetName().getFullName(), reverseNsDecls);
                continue;
            }
            if (!(field instanceof NSRecord)) continue;
            NamespaceUtil.getNsDeclsRecursively((NSRecord)field, nsDecls, cursor, alreadyVisitedFields, null, reverseNsDecls);
        }
    }
}

