/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.coder;

import com.wm.data.BasicData;
import com.wm.data.IData;
import com.wm.data.ISMemDataImpl;
import com.wm.data.MBoolean;
import com.wm.data.MByte;
import com.wm.data.MDouble;
import com.wm.data.MFloat;
import com.wm.data.MInteger;
import com.wm.data.MLong;
import com.wm.data.MShort;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.soap.coder.BogusDecoder;
import com.wm.soap.coder.Context;
import com.wm.soap.coder.EncodingRegistry;
import com.wm.soap.coder.ITypeCoder;
import com.wm.soap.coder.SOAP11Decoder;
import com.wm.soap.coder.Soap11Encoder;
import com.wm.soap.coder.SoapCoderException;
import com.wm.soap.coder.SoapConstants;
import com.wm.soap.coder.StyleDecoder;
import com.wm.soap.coder.StyleEncoder;
import com.wm.soap.coder.resources.SoapCoderExceptionBundle;
import com.wm.util.JournalLogger;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Values;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class EncodingStyles {
    private static final boolean debug = false;
    Hashtable _styles = new Hashtable(11);
    Hashtable typeCoderNames = new Hashtable();
    static final EncodingStyles _es = new EncodingStyles();
    static final Name NULL = Name.create("NULL");
    static final Name NO_CLAIMS = Name.create("");
    private boolean bootstrapped = false;
    private static final String[] coderMap_SCHEMA_OCTOBER_2000_NS = new String[]{"CDATA", "StringCoder", "ENTITIES", "StringCoder", "ENTITY", "StringCoder", "ID", "StringCoder", "IDREF", "StringCoder", "IDREFS", "StringCoder", "NCName", "StringCoder", "NMTOKEN", "StringCoder", "NMTOKENS", "StringCoder", "NOTATION", "StringCoder", "Name", "StringCoder", "QName", "StringCoder", "binary", "StringCoder", "boolean", "BooleanCoder", "byte", "ByteCoder", "century", "StringCoder", "date", "DateCoder", "decimal", "BigDecimalCoder", "double", "DoubleCoder", "float", "FloatCoder", "int", "IntegerCoder", "integer", "BigIntegerCoder", "language", "StringCoder", "long", "LongCoder", "month", "StringCoder", "negativeInteger", "BigIntegerCoder", "nonNegativeInteger", "BigIntegerCoder", "nonPositiveInteger", "BigIntegerCoder", "positiveInteger", "BigIntegerCoder", "recurringDate", "StringCoder", "recurringDay", "StringCoder", "recurringDuration", "StringCoder", "short", "ShortCoder", "string", "StringCoder", "time", "TimeCoder", "timeDuration", "StringCoder", "timeInstant", "StringCoder", "timePeriod", "StringCoder", "token", "StringCoder", "unsignedByte", "ShortCoder", "unsignedInt", "LongCoder", "unsignedLong", "BigIntegerCoder", "unsignedShort", "IntegerCoder", "uriReference", "StringCoder", "year", "StringCoder", "anyList", "StringCoder", "anyUnion", "StringCoder"};
    private static final String[] coderMap_SCHEMA_APRIL_2000_NS = new String[]{"ENTITIES", "StringCoder", "ENTITY", "StringCoder", "ID", "StringCoder", "IDREF", "StringCoder", "IDREFS", "StringCoder", "NCName", "StringCoder", "NMTOKEN", "StringCoder", "NMTOKENS", "StringCoder", "NOTATION", "StringCoder", "Name", "StringCoder", "QName", "StringCoder", "binary", "StringCoder", "boolean", "BooleanCoder", "byte", "ByteCoder", "century", "StringCoder", "date", "DateCoder", "decimal", "BigDecimalCoder", "double", "DoubleCoder", "float", "FloatCoder", "int", "IntegerCoder", "integer", "BigIntegerCoder", "language", "StringCoder", "long", "LongCoder", "month", "StringCoder", "negativeInteger", "BigIntegerCoder", "nonNegativeInteger", "BigIntegerCoder", "nonPositiveInteger", "BigIntegerCoder", "positiveInteger", "BigIntegerCoder", "recurringDate", "StringCoder", "recurringDay", "StringCoder", "recurringDuration", "StringCoder", "short", "ShortCoder", "string", "StringCoder", "time", "TimeCoder", "timeDuration", "StringCoder", "timeInstant", "StringCoder", "timePeriod", "StringCoder", "unsignedByte", "ShortCoder", "unsignedInt", "LongCoder", "unsignedLong", "BigIntegerCoder", "unsignedShort", "IntegerCoder", "uriReference", "StringCoder", "year", "StringCoder"};
    private static final String[] coderMap_SCHEMA_10_NS = new String[]{"ENTITIES", "StringCoder", "ENTITY", "StringCoder", "ID", "StringCoder", "IDREF", "StringCoder", "IDREFS", "StringCoder", "NCName", "StringCoder", "NMTOKEN", "StringCoder", "NMTOKENS", "StringCoder", "NOTATION", "StringCoder", "Name", "StringCoder", "anyURI", "StringCoder", "base64Binary", "StringCoder", "boolean", "BooleanCoder", "byte", "ByteCoder", "date", "DateCoder", "dateTime", "ISO8601DateTimeCoder", "decimal", "BigDecimalCoder", "double", "DoubleCoder", "duration", "StringCoder", "float", "FloatCoder", "gDay", "StringCoder", "gMonth", "StringCoder", "gMonthDay", "StringCoder", "gYear", "StringCoder", "gYearMonth", "StringCoder", "hexBinary", "HexBinaryCoder", "int", "IntegerCoder", "integer", "BigIntegerCoder", "language", "StringCoder", "long", "LongCoder", "negativeInteger", "BigIntegerCoder", "nonNegativeInteger", "BigIntegerCoder", "nonPositiveInteger", "BigIntegerCoder", "normalizedString", "StringCoder", "positiveInteger", "BigIntegerCoder", "QName", "QNameCoder", "short", "ShortCoder", "string", "StringCoder", "time", "TimeCoder", "token", "StringCoder", "unsignedByte", "ShortCoder", "unsignedInt", "LongCoder", "unsignedLong", "BigIntegerCoder", "unsignedShort", "IntegerCoder", "anyList", "StringCoder", "anyUnion", "StringCoder"};
    private static final Object[] coderMap_JavaTypes = new Object[]{BigDecimal.class, "decimal", "BigDecimalCoder", BigInteger.class, "integer", "BigIntegerCoder", Boolean.class, "boolean", "BooleanCoder", Byte.class, "byte", "ByteCoder", Date.class, "dateTime", "ISO8601DateTimeCoder", Double.class, "double", "DoubleCoder", Float.class, "float", "FloatCoder", Integer.class, "int", "IntegerCoder", Long.class, "long", "LongCoder", QName.class, "QName", "QNameCoder", Short.class, "short", "ShortCoder", String.class, "string", "StringCoder", GregorianCalendar.class, "dateTime", "DateTimeCoder", MBoolean.class, "boolean", "BooleanCoder", MByte.class, "byte", "ByteCoder", MDouble.class, "double", "DoubleCoder", MFloat.class, "float", "FloatCoder", MInteger.class, "int", "IntegerCoder", MLong.class, "long", "LongCoder", MShort.class, "short", "ShortCoder"};
    private static final Object[] coderMap_ComplexJavaTypes = new Object[]{ISMemDataImpl.class, "data", "BasicDataCoder", BasicData.class, "data", "BasicDataCoder", Values.class, "data", "BasicDataCoder", IData.class, "data", "BasicDataCoder", Vector.class, "Vector", "VectorCoder", Hashtable.class, "Hashtable", "HashtableCoder", Document.class, "xml-1.0-Document", "DocumentCoder", ElementNode.class, "xml-1.0-Element", "ElementNodeCoder"};

    public static final EncodingStyles current() {
        return _es;
    }

    private EncodingStyles() {
    }

    void register(Name encodingStyle, EncodingRegistry encodingRegistry) throws SoapCoderException {
        if (this._styles.containsKey(encodingStyle)) {
            throw new SoapCoderException(SoapCoderExceptionBundle.class, SoapCoderExceptionBundle.DUPLICATE_ENTRY, "", encodingStyle.toString());
        }
        this._styles.put(encodingStyle, encodingRegistry);
    }

    void unregister(Name encodingStyle) {
        this._styles.remove(encodingStyle);
    }

    public EncodingRegistry getEncodingRegistry(Name encodingStyle) {
        if (!this.bootstrapped) {
            this.bootstrap();
        }
        return (EncodingRegistry)this._styles.get(encodingStyle);
    }

    public static final StyleEncoder createStyleEncoder(Name encodingStyle, Writer writer, Context context) {
        if (encodingStyle == SoapConstants.SOAP_ENCODING_11_NS) {
            return new Soap11Encoder(writer, context);
        }
        return null;
    }

    public static final StyleDecoder createStyleDecoder(Name encodingStyle, Context context) {
        if (encodingStyle == SoapConstants.SOAP_ENCODING_11_NS) {
            EncodingRegistry er = EncodingStyles.current().getEncodingRegistry(encodingStyle);
            return new SOAP11Decoder(context, er);
        }
        if (encodingStyle == NULL || encodingStyle == NO_CLAIMS) {
            return new BogusDecoder(context, null);
        }
        return null;
    }

    private ITypeCoder getITypeCoder(String typeCoderName) {
        ITypeCoder typeCoder = null;
        if (this.typeCoderNames.containsKey(typeCoderName)) {
            typeCoder = (ITypeCoder)this.typeCoderNames.get(typeCoderName);
        } else {
            try {
                Class<?> clazz = Class.forName("com.wm.soap.encoding." + typeCoderName);
                typeCoder = (ITypeCoder)clazz.newInstance();
                this.typeCoderNames.put(typeCoderName, typeCoder);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return typeCoder;
    }

    private synchronized void bootstrap() {
        if (this.bootstrapped) {
            return;
        }
        EncodingRegistry er = new EncodingRegistry();
        int counter = 0;
        try {
            ITypeCoder it;
            QName q;
            Name n;
            int i;
            for (i = 0; i < coderMap_JavaTypes.length - 2; i += 3) {
                er.register((Class)coderMap_JavaTypes[i], QName.create(SoapConstants.SCHEMA_10_NS, Name.create((String)coderMap_JavaTypes[i + 1])), this.getITypeCoder((String)coderMap_JavaTypes[i + 2]));
                ++counter;
            }
            for (i = 0; i < coderMap_ComplexJavaTypes.length - 2; i += 3) {
                n = Name.create((String)coderMap_ComplexJavaTypes[i + 1]);
                q = QName.create(SoapConstants.WEBM_SOAP_NS, n);
                it = this.getITypeCoder((String)coderMap_ComplexJavaTypes[i + 2]);
                er.register((Class)coderMap_ComplexJavaTypes[i], q, it);
                er.register(q, it);
                ++counter;
            }
            n = Name.create("base64");
            q = QName.create(SoapConstants.DEFAULT_ENCODING_STYLE, n);
            it = this.getITypeCoder("Base64Coder");
            er.register(byte[].class, q, it);
            er.register(q, it);
            ++counter;
            n = Name.create("anyType");
            q = QName.create(SoapConstants.SCHEMA_10_NS, n);
            it = this.getITypeCoder("ObjectCoder");
            er.register(Object.class, q, it);
            er.register(q, it);
            ++counter;
            for (i = 0; i < coderMap_SCHEMA_10_NS.length - 1; i += 2) {
                er.register(QName.create(SoapConstants.SCHEMA_10_NS, Name.create(coderMap_SCHEMA_10_NS[i])), this.getITypeCoder(coderMap_SCHEMA_10_NS[i + 1]));
                ++counter;
            }
            for (i = 0; i < coderMap_SCHEMA_OCTOBER_2000_NS.length - 1; i += 2) {
                er.register(QName.create(SoapConstants.SCHEMA_OCTOBER_2000_NS, Name.create(coderMap_SCHEMA_OCTOBER_2000_NS[i])), this.getITypeCoder(coderMap_SCHEMA_OCTOBER_2000_NS[i + 1]));
                ++counter;
            }
            for (i = 0; i < coderMap_SCHEMA_APRIL_2000_NS.length - 1; i += 2) {
                er.register(QName.create(SoapConstants.SCHEMA_APRIL_2000_NS, Name.create(coderMap_SCHEMA_APRIL_2000_NS[i])), this.getITypeCoder(coderMap_SCHEMA_APRIL_2000_NS[i + 1]));
                er.register(QName.create(SoapConstants.SOAP_ENCODING_11_NS, Name.create(coderMap_SCHEMA_APRIL_2000_NS[i])), this.getITypeCoder(coderMap_SCHEMA_APRIL_2000_NS[i + 1]));
                ++counter;
            }
        }
        catch (Exception ex) {
            JournalLogger.log(14, 76, 2);
        }
        try {
            this.register(SoapConstants.SOAP_ENCODING_11_NS, er);
        }
        catch (Exception ex) {
            JournalLogger.log(14, 76, 2);
        }
        this.bootstrapped = true;
    }

    public static void main(String[] args) {
        EncodingStyles es = EncodingStyles.current();
        EncodingRegistry er = es.getEncodingRegistry(SoapConstants.SOAP_ENCODING_11_NS);
        try {
            es.register(SoapConstants.SOAP_ENCODING_11_NS, er);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

