/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.coder;

import com.wm.soap.coder.ITypeCoder;
import com.wm.soap.coder.SoapCoderException;
import com.wm.soap.coder.resources.SoapCoderExceptionBundle;
import com.wm.soap.encoding.IntegerCoder;
import com.wm.soap.encoding.StringCoder;
import com.wm.util.JournalLogger;
import com.wm.util.QName;
import java.util.Hashtable;

public class EncodingRegistry {
    Hashtable _javaCoders = new Hashtable(11);
    Hashtable _schemaCoders = new Hashtable(11);
    Hashtable _javaType2SchemaTypes = new Hashtable(11);

    public ITypeCoder getTypeCoder(QName schemaType) {
        return (ITypeCoder)this._schemaCoders.get(schemaType);
    }

    public ITypeCoder getTypeCoder(Class javaType) {
        return (ITypeCoder)this._javaCoders.get(javaType);
    }

    public QName getSchemaType(Class javaType) {
        return (QName)this._javaType2SchemaTypes.get(javaType);
    }

    void register(Class javaType, QName schemaType, ITypeCoder typeCoder) throws SoapCoderException {
        if (this._javaCoders.containsKey(javaType)) {
            throw new SoapCoderException(SoapCoderExceptionBundle.class, SoapCoderExceptionBundle.DUPLICATE_JAVATYPE_CODER, "", javaType.toString());
        }
        this._javaCoders.put(javaType, typeCoder);
        this._javaType2SchemaTypes.put(javaType, schemaType);
    }

    void register(QName schemaType, ITypeCoder typeCoder) throws SoapCoderException {
        ITypeCoder previous = (ITypeCoder)this._schemaCoders.get(schemaType);
        if (previous != null) {
            if (previous != typeCoder) {
                JournalLogger.log(12, 76, 7, (Object)schemaType.toString());
                throw new SoapCoderException(SoapCoderExceptionBundle.class, SoapCoderExceptionBundle.DIFFERENT_SCHEMATYPE_CODER, "", schemaType.toString());
            }
            JournalLogger.log(12, 76, 7, (Object)schemaType.toString());
        }
        this._schemaCoders.put(schemaType, typeCoder);
    }

    void unregister(Class javaType) throws SoapCoderException {
        if (!this._javaCoders.containsKey(javaType)) {
            throw new SoapCoderException(SoapCoderExceptionBundle.class, SoapCoderExceptionBundle.UNREGISTERED_JAVA_TYPE, "", javaType.toString());
        }
        QName schemaType = this.getSchemaType(javaType);
        this._javaCoders.remove(javaType);
        this._schemaCoders.remove(schemaType);
        this._javaType2SchemaTypes.remove(javaType);
    }

    void unregister(QName schemaType) throws SoapCoderException {
        if (!this._schemaCoders.containsKey(schemaType)) {
            throw new SoapCoderException(SoapCoderExceptionBundle.class, SoapCoderExceptionBundle.UNREGISTERED_SCHEMA_TYPE, "", schemaType.toString());
        }
        this._schemaCoders.remove(schemaType);
    }

    public String toString() {
        return "JavaCoders: " + this._javaCoders.toString() + "\n\nschemaCoders: " + this._schemaCoders.toString() + "\n\njavaType2SchemaTypes: " + this._javaType2SchemaTypes.toString();
    }

    public static void main(String[] args) {
        EncodingRegistry er = new EncodingRegistry();
        QName q1 = QName.create("foo", "bar");
        QName q2 = QName.create("zap", "splat");
        QName q3 = QName.create("bang", "boff");
        StringCoder sc = new StringCoder();
        IntegerCoder ic = new IntegerCoder();
        try {
            er.register(q1, sc);
            er.register(q2, ic);
            er.register(String.class, q1, sc);
            er.register(Integer.class, q2, ic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            er.register(String.class, q1, sc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            er.register(q1, ic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            er.register(q1, sc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

