/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.coder;

import com.wm.lang.ns.NSName;
import com.wm.soap.coder.Context;
import com.wm.soap.coder.StyleEncoder;
import com.wm.soap.coder.TagInfo;
import com.wm.util.Config;
import com.wm.util.Name;
import com.wm.util.OIDTable;
import com.wm.util.QName;
import com.wm.util.SOAPUtil;
import com.wm.util.TypeName;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;

class EncodingContext
extends Context {
    private int _padding = 4;
    private boolean _makeItPretty;
    private int _nextID = 1;
    private Stack _tags = new Stack();
    private Hashtable _namespaceDecls = new Hashtable(11);
    private Hashtable _cachedNamespaceDecls = new Hashtable(11);
    private StyleEncoder _currentStyleEncoder;
    private int _nextPrefix = 1;
    private OIDTable _encodingTypeNameCache = new OIDTable();
    private HashSet _encodingTypeNamePool = new HashSet(11);
    private Map _encodingTypeNamePoolMap = new HashMap(11);
    private Name _nominatedURI;

    public Name createOID(Object o) {
        Name oid = Name.create("id" + this._nextID++);
        if (this._OIDs == null) {
            this._OIDs = new OIDTable();
        }
        this._OIDs.put(o, oid);
        return oid;
    }

    public void removeOID(Object o) {
        this._OIDs.remove(o);
        --this._nextID;
    }

    public Name getOID(Object o) {
        if (this._OIDs == null) {
            return null;
        }
        return (Name)this._OIDs.get(o);
    }

    public void pushEncodingStyle(Name encodingStyle) {
        super.pushEncodingStyle(encodingStyle);
        this._currentStyleEncoder = this.getStyleEncoder(encodingStyle);
    }

    public void popEncodingStyle() {
        super.popEncodingStyle();
        this._currentStyleEncoder = !this._encodingStyles.isEmpty() ? this.getStyleEncoder(this.getEncodingStyle()) : null;
    }

    public StyleEncoder putStyleEncoder(Name encodingStyle, StyleEncoder styleEncoder) {
        if (this._stylists == null) {
            this._stylists = new Hashtable();
        }
        return this._stylists.put(encodingStyle, styleEncoder);
    }

    public StyleEncoder getStyleEncoder(Name encodingStyle) {
        if (this._stylists == null) {
            return null;
        }
        return (StyleEncoder)this._stylists.get(encodingStyle);
    }

    public StyleEncoder getStyleEncoder() {
        return this._currentStyleEncoder;
    }

    public int getPadding() {
        return this._padding;
    }

    public void incrementPadding() {
        ++this._padding;
    }

    public void decrementPadding() {
        --this._padding;
    }

    public boolean makeItPretty() {
        return this._makeItPretty;
    }

    public void setMakeItPretty(boolean makeItPretty) {
        this._makeItPretty = makeItPretty;
    }

    public void pushTag(String tag) {
        TagInfo tagInfo = new TagInfo(tag);
        this._tags.push(tagInfo);
    }

    public String popTag() {
        TagInfo tagInfo = (TagInfo)this._tags.pop();
        if (tagInfo.declaredNamespace != null) {
            Name prefix = (Name)this._namespaceDecls.get(tagInfo.declaredNamespace);
            this._namespaceDecls.remove(tagInfo.declaredNamespace);
            this._cachedNamespaceDecls.put(tagInfo.declaredNamespace, prefix);
        }
        return tagInfo.tag;
    }

    public void addNamespaceDeclaration(Name uri, Name prefix) {
        this._namespaceDecls.put(uri, prefix);
    }

    public void removeNamespaceDeclaration(Name uri) {
        this._namespaceDecls.remove(uri);
    }

    public String getNamespacePrefix(Name uri) {
        Name prefix = (Name)this._namespaceDecls.get(uri);
        return prefix != null ? prefix.toString() : null;
    }

    public String createNamespacePrefix(Name uri) {
        Name prefix = (Name)this._cachedNamespaceDecls.get(uri);
        if (prefix == null) {
            prefix = Name.create("sc" + Integer.toString(this._nextPrefix++));
        }
        this.addNamespaceDeclaration(uri, prefix);
        try {
            TagInfo tagInfo = (TagInfo)this._tags.peek();
            tagInfo.declaredNamespace = uri;
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return prefix.toString();
    }

    public void addEncodingTypeName(Object id, QName encodingTypeName) {
        this._encodingTypeNameCache.put(id, encodingTypeName);
    }

    public QName getEncodingTypeName(Object id) {
        return (QName)this._encodingTypeNameCache.get(id);
    }

    public void setNominatedURI(Name uri) {
        this._nominatedURI = uri;
    }

    public QName createEncodingTypeName(String tag) {
        String uri;
        String string = uri = this._nominatedURI != null ? this._nominatedURI.toString() : null;
        if (SOAPUtil.isIS46SOAPRequest()) {
            return TypeName.create(uri, tag, this._encodingTypeNamePool, true);
        }
        String localName = TypeName.typeNameCheck(tag);
        QName typeName = QName.create(uri, localName);
        boolean createTypeName = Boolean.parseBoolean(Config.getProperty("true", "watt.server.SoapRPC.distinguishDuplicateElements"));
        if (!this._encodingTypeNamePoolMap.containsKey(typeName) || createTypeName) {
            return TypeName.create(uri, tag, this._encodingTypeNamePool, null, this._encodingTypeNamePoolMap);
        }
        return QName.create(uri, localName);
    }

    public QName createEncodingTypeName(NSName documentTypeName) {
        String uri;
        String nodeName = documentTypeName.getNodeName().toString();
        String string = uri = this._nominatedURI != null ? this._nominatedURI.toString() : null;
        if (SOAPUtil.isIS46SOAPRequest()) {
            return TypeName.create(uri, nodeName, this._encodingTypeNamePool, true);
        }
        String localName = TypeName.typeNameCheck(nodeName);
        QName typeName = QName.create(uri, localName);
        boolean createTypeName = Boolean.parseBoolean(Config.getProperty("true", "watt.server.SoapRPC.distinguishDuplicateElements"));
        if (!this._encodingTypeNamePoolMap.containsKey(typeName) || createTypeName) {
            return TypeName.create(uri, nodeName, this._encodingTypeNamePool, null, this._encodingTypeNamePoolMap);
        }
        return QName.create(uri, localName);
    }

    public QName createEncodingTypeName(QName id) {
        if (id == null) {
            return null;
        }
        String uri = this._nominatedURI != null ? this._nominatedURI.toString() : null;
        return TypeName.create2(uri, id.getNCName(), this._encodingTypeNamePool);
    }

    public QName createEncodingTypeName(String uri, String tag) {
        return TypeName.create2(uri, tag, this._encodingTypeNamePool);
    }

    public boolean generateEncodingTypeName() {
        return this._nominatedURI != null;
    }
}

