/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.coder;

import com.wm.data.IData;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.soap.coder.DecodingContext;
import com.wm.soap.coder.EncodingContext;
import com.wm.soap.coder.EncodingRegistry;
import com.wm.soap.coder.EncodingStyles;
import com.wm.soap.coder.ProcessingState;
import com.wm.soap.coder.SoapForwardRef;
import com.wm.soap.coder.StyleDecoder;
import com.wm.soap.coder.StyleEncoder;
import com.wm.util.Name;
import com.wm.util.OIDTable;
import com.wm.util.QName;
import java.util.Hashtable;
import java.util.Stack;

public abstract class Context {
    protected OIDTable _OIDs;
    protected Hashtable _stylists;
    protected Stack _encodingStyles = new Stack();
    private EncodingRegistry _currentEncodingRegistry;
    private QName root;
    private boolean _isLegacyCall = true;
    private boolean _isProviderSideCoder = false;
    private boolean _isWsdlFirstProvider = false;
    public static final int FOR_ENCODING = 0;
    public static final int FOR_DECODING = 1;

    protected Context() {
    }

    public Name createOID(Object o) {
        return null;
    }

    public void removeOID(Object o) {
    }

    public Object put(Name oid, Object o) {
        return null;
    }

    public Name getOID(Object o) {
        return null;
    }

    public Object getObject(Name oid) {
        return null;
    }

    public SoapForwardRef getForwardRef(Name id) {
        return null;
    }

    public void addForwardRef(SoapForwardRef fr) {
    }

    public IData getForwardRefIData() {
        return null;
    }

    public boolean notProcessedRoot() {
        return false;
    }

    public void setProcessedRoot(boolean processed) {
    }

    public StyleEncoder putStyleEncoder(Name encodingStyle, StyleEncoder styleEncoder) {
        return null;
    }

    public StyleEncoder getStyleEncoder(Name encodingStyle) {
        return null;
    }

    public StyleDecoder putStyleDecoder(Name encodingStyle, StyleDecoder styleDecoder) {
        return null;
    }

    public StyleDecoder getStyleDecoder(Name encodingStyle) {
        return null;
    }

    public Name getEncodingStyle() {
        return (Name)this._encodingStyles.peek();
    }

    public void pushEncodingStyle(Name encodingStyle) {
        this._encodingStyles.push(encodingStyle);
        this._currentEncodingRegistry = EncodingStyles.current().getEncodingRegistry(encodingStyle);
    }

    public void popEncodingStyle() {
        this._encodingStyles.pop();
        this._currentEncodingRegistry = !this._encodingStyles.isEmpty() ? EncodingStyles.current().getEncodingRegistry(this.getEncodingStyle()) : null;
    }

    public StyleEncoder getStyleEncoder() {
        return null;
    }

    public StyleDecoder getStyleDecoder() {
        return null;
    }

    public EncodingRegistry getEncodingRegistry() {
        return this._currentEncodingRegistry;
    }

    public int getPadding() {
        return 0;
    }

    public void incrementPadding() {
    }

    public void decrementPadding() {
    }

    public boolean makeItPretty() {
        return false;
    }

    public void setMakeItPretty(boolean makeItPretty) {
    }

    public void pushTag(String tag) {
    }

    public String popTag() {
        return null;
    }

    public void addNamespaceDeclaration(Name uri, Name prefix) {
    }

    public String getNamespacePrefix(Name uri) {
        return null;
    }

    public String createNamespacePrefix(Name uri) {
        return null;
    }

    public void removeNamespaceDeclaration(Name uri) {
    }

    public void setSchema(NSRecord record) {
    }

    public NSRecord getSchema() {
        return null;
    }

    public void addEncodingTypeName(Object id, QName encodingTypeName) {
    }

    public QName getEncodingTypeName(Object id) {
        return null;
    }

    public void setNominatedURI(Name uri) {
    }

    public boolean generateEncodingTypeName() {
        return false;
    }

    public QName createEncodingTypeName(String tag) {
        return null;
    }

    public QName createEncodingTypeName(String uri, String tag) {
        return null;
    }

    public QName createEncodingTypeName(NSName documentTypeName) {
        return null;
    }

    public QName createEncodingTypeName(QName id) {
        return null;
    }

    void setInsideTrueRoot() {
    }

    void resetInsideTrueRoot() {
    }

    boolean isInsideTrueRoot() {
        return false;
    }

    public void pushState(ProcessingState state) {
    }

    public ProcessingState getCurrentState() {
        return null;
    }

    public ProcessingState popState() {
        return null;
    }

    public void setPipeline(IData pipeline) {
    }

    public IData getPipeline() {
        return null;
    }

    public static final Context create(int purpose) {
        switch (purpose) {
            case 0: {
                return new EncodingContext();
            }
            case 1: {
                return new DecodingContext();
            }
        }
        return null;
    }

    public QName getRoot() {
        return this.root;
    }

    public void setRoot(QName root) {
        this.root = root;
    }

    public void setLegacyCall(boolean isLegacyCall) {
        this._isLegacyCall = isLegacyCall;
    }

    public boolean isLegacyCall() {
        return this._isLegacyCall;
    }

    public void setProviderSideCoder(boolean isProviderSideCoder) {
        this._isProviderSideCoder = isProviderSideCoder;
    }

    public boolean isProviderSideCoder() {
        return this._isProviderSideCoder;
    }

    public boolean isWsdlFirstProvider() {
        return this._isWsdlFirstProvider;
    }

    public void setWsdlFirstProvider(boolean isWsdlFirstProvider) {
        this._isWsdlFirstProvider = isWsdlFirstProvider;
    }
}

