/*
 * Decompiled with CFR 0.152.
 */
package com.wm.soap.coder;

import com.wm.lang.schema.datatypev2.PerlRegex;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.soap.coder.ArrayType;
import com.wm.soap.coder.EncodingRegistry;
import com.wm.soap.coder.SoapCoderRuntimeException;
import com.wm.soap.coder.SoapConstants;
import com.wm.soap.coder.TypeInformation;
import com.wm.soap.coder.resources.SoapCoderRuntimeExceptionBundle;
import com.wm.util.IntegerList;
import com.wm.util.JournalLogger;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.XMLUtils;
import java.util.StringTokenizer;

public class ArrayTypeParser {
    private static final boolean _debug = false;
    private static final String TYPE_DELIMITERS = "[";
    private static String[] patterns = new String[]{"(\\[,*\\])*\\[((\\d+,)*\\d+)?\\]"};
    private static String[] declPatterns = new String[]{"(\\[,*\\])*\\[((\\d+,)*\\d+)?\\]", "(\\[,*\\])*", "(\\[((\\d+,)*\\d+)?\\])*"};
    private static final PerlRegex regexParser = PerlRegex.create(patterns);
    private static final PerlRegex declRegexParser = PerlRegex.create(declPatterns);
    private static final String POINT_DELIMITERS = "[,]";

    public static final ArrayType parse(Name encodingStyle, String arrayType, ElementNode contextNode) throws SoapCoderRuntimeException {
        int bracket = arrayType.indexOf(TYPE_DELIMITERS);
        if (bracket < 0) {
            JournalLogger.log(21, 76, 2, (Object)arrayType);
            throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.INVALID_ARRAY_TYPE, "", arrayType);
        }
        String qname = arrayType.substring(0, bracket);
        if (!XMLUtils.validateQName(qname)) {
            JournalLogger.log(21, 76, 2, (Object)arrayType);
            throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.INVALID_ARRAY_TYPE, "", arrayType);
        }
        String ranksize = arrayType.substring(bracket);
        if (!regexParser.match(ranksize)) {
            JournalLogger.log(21, 76, 2, (Object)arrayType);
            throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.INVALID_ARRAY_TYPE, "", arrayType);
        }
        QName schemaType = null;
        StringTokenizer tokenizer = new StringTokenizer(arrayType, TYPE_DELIMITERS);
        int count = tokenizer.countTokens();
        if (count > 2) {
            schemaType = SoapConstants.ANY_TYPE;
        } else {
            try {
                schemaType = QName.computeQName(tokenizer.nextToken(), contextNode);
            }
            catch (WMDocumentException wmd) {
                throw new SoapCoderRuntimeException(wmd);
            }
            catch (RuntimeException re) {
                throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.RUNTIME_EXCEPTION, "", qname);
            }
        }
        String lastToken = null;
        while (tokenizer.hasMoreTokens()) {
            lastToken = tokenizer.nextToken();
        }
        tokenizer = new StringTokenizer(lastToken, POINT_DELIMITERS);
        count = tokenizer.countTokens();
        int[] dimensions = null;
        if (count == 0) {
            dimensions = new int[]{-1};
        } else {
            dimensions = new int[count];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String next = tokenizer.nextToken();
                try {
                    dimensions[i++] = Integer.parseInt(next);
                }
                catch (NumberFormatException ex) {
                    throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.NUMBER_FORMAT_EXCEPTION, "", next);
                }
            }
        }
        return new ArrayType(schemaType, dimensions);
    }

    public static final ArrayType parseDeclaration(Name encodingStyle, String arrayType, ElementNode contextNode) throws SoapCoderRuntimeException {
        int[] dimensions;
        int bracket = arrayType.indexOf(TYPE_DELIMITERS);
        if (bracket < 0) {
            JournalLogger.log(21, 76, 2, (Object)arrayType);
            throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.INVALID_ARRAY_TYPE, "", arrayType);
        }
        String qname = arrayType.substring(0, bracket);
        if (!XMLUtils.validateQName(qname)) {
            JournalLogger.log(21, 76, 2, (Object)arrayType);
            throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.INVALID_ARRAY_TYPE, "", arrayType);
        }
        String ranksize = arrayType.substring(bracket);
        if (!declRegexParser.match(ranksize)) {
            JournalLogger.log(21, 76, 2, (Object)arrayType);
            throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.INVALID_ARRAY_TYPE, "", arrayType);
        }
        QName schemaType = null;
        int count = 0;
        int len = ranksize.length();
        for (int i = 0; i < len; ++i) {
            char ch = ranksize.charAt(i);
            if (ch != '[' && ch != ',') continue;
            ++count;
        }
        if (count > 2) {
            schemaType = SoapConstants.ANY_TYPE;
        } else {
            try {
                schemaType = QName.computeQName(qname, contextNode);
            }
            catch (WMDocumentException wmd) {
                throw new SoapCoderRuntimeException(wmd);
            }
            catch (RuntimeException re) {
                throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.RUNTIME_EXCEPTION, "", qname);
            }
        }
        if (count == 0) {
            dimensions = new int[]{-1};
        } else {
            dimensions = new int[count];
            for (int i = 0; i < count; ++i) {
                dimensions[i] = -1;
            }
        }
        ArrayType at = new ArrayType(schemaType, dimensions);
        return at;
    }

    public static final ArrayType parse(Object[] array, EncodingRegistry encodingRegistry, QName targetNamespace, String key) {
        IntegerList iList = new IntegerList();
        Class<?> clazz = array.getClass();
        Object[] anArray = array;
        while (true) {
            iList.addInteger(anArray.length);
            clazz = clazz.getComponentType();
            if (!clazz.isArray()) break;
            anArray = (Object[])anArray[0];
        }
        int[] dimensions = new int[iList.size()];
        iList.copyInto(dimensions);
        QName schemaType = encodingRegistry.getSchemaType(clazz);
        if (schemaType == null && clazz.equals(Character.class) && targetNamespace != null) {
            schemaType = QName.create(targetNamespace.getNamespace(), key);
        }
        if (schemaType == null) {
            JournalLogger.log(22, 76, 2, new Object[]{clazz});
            schemaType = encodingRegistry.getSchemaType(String.class);
        }
        return new ArrayType(schemaType, dimensions);
    }

    public static final ArrayType parse(Object[] array, TypeInformation typeInfo, EncodingRegistry encodingRegistry, QName targetNamespace, String key) {
        IntegerList iList = new IntegerList();
        Class<?> clazz = array.getClass();
        Object[] anArray = array;
        while (true) {
            iList.addInteger(anArray.length);
            clazz = clazz.getComponentType();
            if (!clazz.isArray()) break;
            anArray = (Object[])anArray[0];
        }
        int[] dimensions = new int[iList.size()];
        iList.copyInto(dimensions);
        QName schemaType = typeInfo.getSchemaType();
        if (schemaType == null) {
            schemaType = encodingRegistry.getSchemaType(clazz);
        }
        if (schemaType == null && clazz.equals(Character.class) && targetNamespace != null) {
            schemaType = QName.create(targetNamespace.getNamespace(), key);
        }
        return new ArrayType(schemaType, dimensions);
    }

    static final int[] parseArrayPoint(String arrayPoint) throws SoapCoderRuntimeException {
        StringTokenizer tokenizer = new StringTokenizer(arrayPoint, POINT_DELIMITERS);
        int count = tokenizer.countTokens();
        int[] point = new int[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            try {
                point[i++] = Integer.parseInt(next);
            }
            catch (NumberFormatException ex) {
                throw new SoapCoderRuntimeException(SoapCoderRuntimeExceptionBundle.class, SoapCoderRuntimeExceptionBundle.NUMBER_FORMAT_EXCEPTION, "", next);
            }
        }
        return point;
    }
}

