/*
 * Decompiled with CFR 0.152.
 */
package com.wm.shell;

import com.wm.shell.Console;
import com.wm.shell.Expression;
import com.wm.util.sort.QuickSort;
import java.util.Hashtable;
import java.util.Vector;

public class Expressions {
    Hashtable _expressions;
    String[] _keywords;
    private static final String UNKNOWN = "unknown";
    private static String[] BASIC_EXPRESSION_CLASS_NAMES = new String[0];

    protected Expressions(Console console) {
        int size = BASIC_EXPRESSION_CLASS_NAMES.length;
        String[] expressionClassNames = this.getExpressionClassNames();
        if (expressionClassNames != null) {
            size += expressionClassNames.length;
        }
        this._expressions = new Hashtable(size);
        Vector keywords = new Vector(size);
        this._keywords = new String[size];
        this.loadExpressions(BASIC_EXPRESSION_CLASS_NAMES, console, keywords);
        this.loadExpressions(expressionClassNames, console, keywords);
        keywords.copyInto(this._keywords);
        this._keywords = QuickSort.sort(this._keywords);
    }

    public Expression getExpression(String keyword) {
        return (Expression)this._expressions.get(keyword);
    }

    private void loadExpressions(String[] classNames, Console console, Vector keywords) {
        if (classNames == null) {
            return;
        }
        for (int i = 0; i < classNames.length; ++i) {
            try {
                Class<?> clazz = Class.forName(classNames[i]);
                Expression exp = (Expression)clazz.newInstance();
                exp.setConsole(console);
                String[] keys = exp.getKeywords();
                keywords.addElement(exp.getKeyword());
                if (keys == null) continue;
                for (int j = 0; j < keys.length; ++j) {
                    this._expressions.put(keys[j], exp);
                }
                continue;
            }
            catch (ClassNotFoundException ex) {
                console.throwException(ex);
                continue;
            }
            catch (SecurityException ex) {
                console.throwException(ex);
                continue;
            }
            catch (IllegalAccessException ex) {
                console.throwException(ex);
                continue;
            }
            catch (InstantiationException ex) {
                console.throwException(ex);
                continue;
            }
            catch (Exception ex) {
                console.throwException(ex);
            }
        }
    }

    protected String[] getExpressionClassNames() {
        return null;
    }

    public String[] getKeywords() {
        return this._keywords;
    }

    boolean isSupported(String command) {
        return this._expressions.containsKey(this.parse(command));
    }

    boolean execute(String command) {
        Expression exp = (Expression)this._expressions.get(this.parse(command));
        if (exp != null) {
            return exp.execute(command);
        }
        return false;
    }

    String parse(String command) {
        String trimmed = command.trim();
        int index = trimmed.indexOf(32);
        if (index > -1) {
            return trimmed.substring(0, index);
        }
        return UNKNOWN;
    }

    static Expressions createExpressions(Console console) {
        return new Expressions(console);
    }
}

