/*
 * Decompiled with CFR 0.152.
 */
package com.wm.shell;

import com.wm.data.IData;
import com.wm.shell.Console;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class Expression {
    private static PatternCompiler _compiler = new Perl5Compiler();
    private PatternMatcher _matcher = new Perl5Matcher();
    private Pattern _pattern;
    Console _console;
    private static final String UNABLE_TO_RETRIEVE_REG_EX = "Unable to retrieve a regular expression for this command";
    private static final String SYNTAX_IS_INCORRECT = "Syntax is incorrect";

    protected Expression() {
    }

    protected Console getConsole() {
        return this._console;
    }

    void setConsole(Console console) {
        this._console = console;
    }

    private String[] tokenize(String input) {
        StringTokenizer tokenizer = new StringTokenizer(input, " ");
        String[] tokens = new String[tokenizer.countTokens()];
        for (int index = 0; index < tokens.length && tokenizer.hasMoreTokens(); ++index) {
            tokens[index] = tokenizer.nextToken();
        }
        return tokens;
    }

    private String normalize(String input) {
        String[] tokens = this.tokenize(input);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            if (i == 0) {
                tokens[0] = this.getKeyword();
            }
            sb.append(tokens[i]);
            if (i + 1 == tokens.length) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validate(String input) {
        if (this._pattern == null) {
            String regExp = this.getRegularExpression();
            if (regExp == null) {
                RuntimeException ex = new RuntimeException(UNABLE_TO_RETRIEVE_REG_EX);
                this.getConsole().throwException(ex);
                return false;
            }
            try {
                this._pattern = _compiler.compile(regExp);
            }
            catch (MalformedPatternException mpe) {
                this.getConsole().throwException((Exception)((Object)mpe));
                return false;
            }
        }
        boolean returnValue = false;
        PatternMatcher patternMatcher = this._matcher;
        synchronized (patternMatcher) {
            returnValue = this._matcher.matches(input, this._pattern);
        }
        return returnValue;
    }

    private IData[] parse(String input) {
        IData[] dataArray = new IData[2];
        return dataArray;
    }

    boolean execute(String input) {
        String normalizedInput = this.normalize(input);
        if (!this.validate(normalizedInput)) {
            this.getConsole().writeln(SYNTAX_IS_INCORRECT);
            this.printUsage();
            return false;
        }
        IData[] dataArray = this.parse(normalizedInput);
        return this.execute(dataArray[0], dataArray[1]);
    }

    public abstract String[] getKeywords();

    public abstract String getKeyword();

    protected abstract String getRegularExpression();

    protected abstract Object[][] getSchemaForValues();

    protected abstract Object[][] getSchemaForOptions();

    protected abstract boolean execute(IData var1, IData var2);

    protected abstract void printUsage();

    public abstract String describe();
}

