/*
 * Decompiled with CFR 0.152.
 */
package com.wm.shell;

import com.wm.shell.Expressions;
import com.wm.shell.SampleConsole;
import com.wm.util.EncUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;
import java.util.Vector;

public abstract class Console {
    String _homeDirectory;
    BufferedReader _in = new BufferedReader(new InputStreamReader(System.in));
    BufferedWriter _out = new BufferedWriter(new OutputStreamWriter(System.out));
    boolean _shutdown;
    Vector _history = new Vector(this.getHistorySize());
    Stack _irStack = new Stack();
    Stack _owStack = new Stack();
    Expressions _expressions;
    static final int HISTORY_SIZE = 100;
    static final String BANNER = "\nIS Shell\nwebMethods, USA\n\n";
    static final String PROMPT = "IS Shell\\>";
    static final String EXCEPTION_HEADER = "---- Shell Exception ----";
    static final String OPTIONAL_HOME_DIRECTORY = "-h";
    static final String BOOTSTRAP_DIRECTORY = "-b";

    protected Console() {
        this._irStack.push(this._in);
        this._owStack.push(this._out);
        this._expressions = this.createExpressions();
    }

    public void setHomeDirectory(String homeDirectory) {
        this._homeDirectory = homeDirectory;
    }

    public void setExpressions(Expressions exps) {
        this._expressions = exps;
    }

    public Expressions getExpressions() {
        return this._expressions;
    }

    public String getHomeDirectory() {
        return this._homeDirectory;
    }

    public String getHistory() {
        StringBuffer sb = new StringBuffer();
        for (int index = 0; index < this._history.size(); ++index) {
            sb = sb.append((String)this._history.elementAt(index));
            sb.append('\n');
        }
        return sb.toString();
    }

    public int getHistorySize() {
        return 100;
    }

    public String getBanner() {
        return BANNER;
    }

    public String getPrompt() {
        return PROMPT;
    }

    public String getExceptionHeader() {
        return EXCEPTION_HEADER;
    }

    public boolean bootstrap(String[] stmts) {
        if (stmts == null) {
            return false;
        }
        boolean successful = true;
        for (int i = 0; i < stmts.length; ++i) {
            if (this.execute(stmts[i])) continue;
            successful = false;
        }
        return successful;
    }

    public void run() {
        this.write(this.getBanner());
        while (!this._shutdown) {
            String input = this.waitForInput();
            this.execute(input);
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String filename) {
        BufferedReader in = null;
        try {
            String command;
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(new File(this.getHomeDirectory(), filename)), EncUtil.getFileEncoding());
            in = new BufferedReader(isr);
            while ((command = in.readLine()) != null) {
                this.execute(command);
            }
        }
        catch (IOException e) {
            this.write("Error occurred: while reading from file - " + filename + "\n");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ein) {}
        }
    }

    public void throwException(Exception ex) {
        this.writeln(EXCEPTION_HEADER);
        this.writeln(ex.toString());
        ex.printStackTrace();
    }

    public void write(String message) {
        try {
            this._out.write(message);
            this._out.flush();
        }
        catch (IOException ex) {
            this.throwException(ex);
        }
    }

    public void writeln(String message) {
        this.write(message + '\n');
    }

    public void write(StringBuffer sb) {
        this.write(sb.toString());
    }

    public void writeln(StringBuffer sb) {
        this.writeln(sb.toString());
    }

    public void writeNewLine() {
        try {
            this._out.newLine();
        }
        catch (IOException ex) {
            this.throwException(ex);
        }
    }

    public void writeToFile(String filename, String message, boolean append) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.getHomeDirectory(), filename).getAbsolutePath(), append), EncUtil.getFileEncoding());
            out.write(message);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            this.write("Error occurred: while writing to file - " + filename + "\n");
        }
    }

    public void writeToFile(String filename, StringBuffer sb, boolean append) {
        this.writeToFile(filename, sb.toString(), append);
    }

    public void setShutdown() {
        this._shutdown = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._in.close();
        this._out.close();
    }

    String waitForInput() {
        String input;
        try {
            this.write(this.getPrompt());
            input = this._in.readLine();
        }
        catch (IOException e) {
            return null;
        }
        return input;
    }

    private boolean execute(String command) {
        if (command != null && command.length() > 0) {
            if (this._expressions.isSupported(command)) {
                this.addToHistory(command);
                return this._expressions.execute(command);
            }
            this.writeln("Unrecognized command");
        }
        return false;
    }

    private void addToHistory(String command) {
        if (this._history.size() == this.getHistorySize()) {
            this._history.removeElementAt(0);
        }
        this._history.addElement(command);
    }

    public void pushInputReader(BufferedReader ir) {
        this._irStack.push(ir);
        this._in = ir;
    }

    public BufferedReader popInputReader() {
        if (this._irStack.size() < 2) {
            return null;
        }
        BufferedReader ir = (BufferedReader)this._irStack.pop();
        this._in = (BufferedReader)this._irStack.peek();
        return ir;
    }

    public void pushOutputWriter(BufferedWriter ow) {
        this._owStack.push(ow);
        this._out = ow;
    }

    public BufferedWriter popOutputWriter() {
        if (this._owStack.size() < 2) {
            return null;
        }
        BufferedWriter ow = (BufferedWriter)this._owStack.pop();
        this._out = (BufferedWriter)this._owStack.peek();
        return ow;
    }

    private void shutdown() {
        this.writeln("Shutting down ... ");
    }

    protected abstract Expressions createExpressions();

    public static void main(String[] args) {
        SampleConsole console = new SampleConsole();
        String scriptFile = null;
        String homeDirectory = null;
        String bootstrapDirectory = null;
        boolean homeDirectorySpecified = false;
        boolean bootstrapDirectorySpecified = false;
        if (args.length > 0) {
            for (int index = 0; index < args.length; ++index) {
                if (args[index].equals(OPTIONAL_HOME_DIRECTORY)) {
                    homeDirectorySpecified = true;
                } else if (args[index].equals(BOOTSTRAP_DIRECTORY)) {
                    bootstrapDirectorySpecified = true;
                } else {
                    scriptFile = args[index];
                }
                if (homeDirectorySpecified && index + 1 < args.length) {
                    homeDirectory = args[index + 1];
                    ++index;
                    homeDirectorySpecified = false;
                }
                if (!bootstrapDirectorySpecified || index + 1 >= args.length) continue;
                bootstrapDirectory = args[index + 1];
                ++index;
                bootstrapDirectorySpecified = false;
            }
        }
        if (homeDirectorySpecified || bootstrapDirectorySpecified || bootstrapDirectory == null) {
            System.out.println("Usage: java com.wm.shell.Console -b <bootstrapDirectory> [-h <homeDirectory>] [script file]");
            System.out.println("\t bootstrapDirectory = a directory to boostrap from example, d:\\webMethods\\server");
            System.out.println("\t homeDirectory = user home directory");
            System.out.println("\t script file = console script file name");
            System.exit(0);
        }
        if (bootstrapDirectory != null) {
            console.setHomeDirectory(bootstrapDirectory);
        } else {
            console.setHomeDirectory(homeDirectory);
        }
        console.setHomeDirectory(homeDirectory);
        if (scriptFile != null) {
            console.run(scriptFile);
        } else {
            console.run();
        }
    }
}

