/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security;

import com.wm.security.Util;
import com.wm.security.cert.wmChainVerifier;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import iaik.security.ssl.ClientTrustDecider;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLCertificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;

public class wmTrustDecider
implements ClientTrustDecider {
    static final int SETUP_ERROR = 4;
    public static final String IGNORE_EMPTY_AUTH_LIST_PROP = "watt.security.ssl.client.ignoreEmptyAuthoritiesList";
    public static final String SIGNED_CERT_PROP = "watt.security.signedCert";
    public static final String CA_CERT_PROP = "watt.security.caCert";
    public static final String PRIV_KEY_PROP = "watt.security.privateKey";
    protected wmChainVerifier _verifier;
    protected KeyAndCert _credentials;
    protected SSLCertificate _certChain;
    protected boolean ignoreEmptyAuthList;

    public void init() {
        this._verifier = wmChainVerifier.getDefault();
        if (this._credentials == null) {
            this.getKeyAndChain();
        }
        if (this._credentials != null && this._credentials.getCertificateChain() != null) {
            this._certChain = new SSLCertificate(this._credentials.getCertificateChain());
        }
        this.ignoreEmptyAuthList = Boolean.getBoolean(IGNORE_EMPTY_AUTH_LIST_PROP);
    }

    protected void getKeyAndChain() {
        this._credentials = null;
        String userCert = Config.getProperty(SIGNED_CERT_PROP);
        String caCert = Config.getProperty(CA_CERT_PROP);
        String privKey = Config.getProperty(PRIV_KEY_PROP);
        userCert = userCert == null ? "" : userCert.trim();
        caCert = caCert == null ? "" : caCert.trim();
        String string = privKey = privKey == null ? "" : privKey.trim();
        if (userCert.length() == 0 || privKey.length() == 0 || caCert.length() == 0) {
            return;
        }
        File certFile = new File(userCert);
        File keyFile = new File(privKey);
        File caFile = new File(caCert);
        if (!(certFile.exists() && keyFile.exists() && caFile.exists())) {
            return;
        }
        try {
            PrivateKey pk = Util.loadRSAPrivateKey(keyFile);
            if (privKey == null) {
                throw new InvalidKeyException("Private key is either not in the correct format (PKCS#1 or PKCS#8) or is protected");
            }
            X509Certificate[] chain = new X509Certificate[2];
            FileInputStream fis = new FileInputStream(certFile);
            chain[0] = new iaik.x509.X509Certificate((InputStream)fis);
            fis.close();
            fis = new FileInputStream(caFile);
            chain[1] = new iaik.x509.X509Certificate((InputStream)fis);
            fis.close();
            this._credentials = new KeyAndCert(chain, pk);
        }
        catch (Exception e) {
            JournalLogger.logCritical(4, 6, e);
        }
        catch (Throwable t) {
            JournalLogger.logDebug(4, 6, t.getMessage());
        }
    }

    public boolean isTrustedPeer(SSLCertificate peer) {
        if (peer == null) {
            return false;
        }
        iaik.x509.X509Certificate[] peerChain = null;
        try {
            peerChain = iaik.utils.Util.convertCertificateChain((Certificate[])peer.getCertificateChain());
            this._verifier.verifyChain((X509Certificate[])peerChain);
            return this._verifier.isTrustedChain((X509Certificate[])peerChain);
        }
        catch (CertificateExpiredException cee) {
        }
        catch (Throwable e) {
            e.printStackTrace();
            JournalLogger.logDebugPlus(1, 4, 6, e.getMessage());
        }
        return false;
    }

    public PrivateKey getPrivateKey() {
        if (this._credentials != null) {
            return this._credentials.getPrivateKey();
        }
        return null;
    }

    public SSLCertificate getCertificate(byte[] certificateTypes, Principal[] CAs, String keyExchangeAlg) {
        if (this._credentials == null || this._credentials.getCertificateChain() == null) {
            return null;
        }
        if (this.ignoreEmptyAuthList && (CAs == null || CAs.length == 0)) {
            return this._certChain;
        }
        X509Certificate[] ourChain = this._credentials.getCertificateChain();
        for (int i = 0; i < CAs.length; ++i) {
            for (int j = 0; j < ourChain.length; ++j) {
                if (!((Object)ourChain[j].getIssuerDN()).equals(CAs[i])) continue;
                return this._certChain;
            }
        }
        return null;
    }

    public void setKeyAndCert(KeyAndCert kac) {
        this._credentials = kac;
    }

    static {
        wmChainVerifier.init();
    }
}

