/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security.ssl;

import com.wm.security.Util;
import com.wm.security.resources.CertificateExceptionBundle;
import com.wm.util.Config;
import com.wm.util.LocalizedCertificateException;
import iaik.security.ssl.ChainVerifier;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class wmChainVerifier
extends ChainVerifier {
    static final String ALLOW_EXPIRED_CERTIFICATES_PROP = "watt.security.ssl.ignoreExpiredChains";
    static final String ENFORCE_EXTENSION_CHECKS_PROP = "watt.security.cert.enforceExtensionChecks";
    static final boolean ALLOW_EXPIRED_CERTIFICATES_DEFAULT = false;
    static final boolean ENFORCE_EXTENSION_CHECKS_DEFAULT = false;
    static final wmChainVerifier defaultVerifier = new wmChainVerifier();
    protected boolean enforceExtensionChecks;
    protected boolean allowExpiredCertificates;

    public static wmChainVerifier getDefaultVerifier() {
        return defaultVerifier;
    }

    public wmChainVerifier() {
        this.init();
    }

    protected void init() {
        this.allowExpiredCertificates = System.getProperty(ALLOW_EXPIRED_CERTIFICATES_PROP) == null ? false : Boolean.getBoolean(ALLOW_EXPIRED_CERTIFICATES_PROP);
        this.enforceExtensionChecks = System.getProperty(ENFORCE_EXTENSION_CHECKS_PROP) == null ? false : Boolean.getBoolean(ENFORCE_EXTENSION_CHECKS_PROP);
    }

    public boolean getAllowExpiredCertificate() {
        return this.allowExpiredCertificates;
    }

    public boolean getEnforceExtensionChecks() {
        return this.enforceExtensionChecks;
    }

    public boolean getTrustByDefault() {
        return this.nullTrusted;
    }

    public void setAllowExpiredCertificate(boolean flag) {
        this.allowExpiredCertificates = flag;
    }

    public void setEnforceExtensionChecks(boolean flag) {
        this.enforceExtensionChecks = flag;
    }

    public void setTrustByDefault(boolean flag) {
        this.nullTrusted = flag;
    }

    protected boolean verifyCertificate(X509Certificate subject, X509Certificate issuer) throws Exception {
        block6: {
            try {
                subject.checkValidity();
            }
            catch (CertificateExpiredException cee) {
                if (this.allowExpiredCertificates) break block6;
                throw cee;
            }
        }
        if (this.isCachedCertificate(subject)) {
            return true;
        }
        if (this.isTrustedCertificate(subject)) {
            return true;
        }
        this.checkExtensions(subject);
        if (issuer != null) {
            if (!((Object)subject.getIssuerDN()).equals(issuer.getSubjectDN())) {
                throw new LocalizedCertificateException(CertificateExceptionBundle.class, CertificateExceptionBundle.CERT_CHAIN_BROKEN, "");
            }
            subject.verify(issuer.getPublicKey());
        }
        return false;
    }

    protected void checkExtensions(X509Certificate cert) throws CertificateException {
        if (cert.hasUnsupportedCriticalExtension() && this.enforceExtensionChecks) {
            throw new LocalizedCertificateException(CertificateExceptionBundle.class, CertificateExceptionBundle.CERT_UNSUPPORTED_CRITICAL_EXT, "");
        }
    }

    public boolean isTrustedChain(X509Certificate[] chain) {
        if (chain == null || chain.length == 0) {
            return this.nullTrusted;
        }
        int len = chain.length;
        for (int i = 0; i < len; ++i) {
            if (!this.isTrustedCertificate(chain[i])) continue;
            return true;
        }
        boolean trusted = false;
        X509Certificate issuer = this.getIssuerCertificate(chain[len - 1]);
        trusted = issuer != null;
        return trusted;
    }

    public void removeTrustedCertificate(X509Certificate x509certificate) {
        if (x509certificate == null) {
            this.nullTrusted = false;
            return;
        }
        this.trustedCerts.remove(x509certificate);
        this.clearCachedCertificates();
    }

    public void addTrustedCertificate(X509Certificate x509certificate) {
        if (x509certificate == null) {
            this.nullTrusted = true;
            return;
        }
        this.trustedCerts.put(x509certificate, x509certificate);
    }

    protected boolean isTrustedCertificate(X509Certificate x509certificate) {
        if (x509certificate == null) {
            return this.nullTrusted;
        }
        X509Certificate x509certificate1 = (X509Certificate)this.trustedCerts.get(x509certificate);
        if (x509certificate1 == null) {
            return false;
        }
        return x509certificate.equals(x509certificate1);
    }

    protected X509Certificate getIssuerCertificate(X509Certificate x509certificate) {
        X509Certificate x509certificate1 = null;
        Enumeration enumvar = this.trustedCerts.keys();
        while (enumvar.hasMoreElements()) {
            x509certificate1 = (X509Certificate)enumvar.nextElement();
            if (!((Object)x509certificate.getIssuerDN()).equals(x509certificate1.getSubjectDN())) continue;
            try {
                x509certificate.verify(x509certificate1.getPublicKey());
                return x509certificate1;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public Enumeration getTrustedPrincipals() {
        Vector<Principal> DNs = new Vector<Principal>();
        Enumeration enumvar = this.trustedCerts.keys();
        while (enumvar.hasMoreElements()) {
            DNs.addElement(((X509Certificate)enumvar.nextElement()).getSubjectDN());
        }
        return DNs.elements();
    }

    public void loadDefaultAuthorities() {
        defaultVerifier.clearTrustedCertificates();
        String caDir = Config.getProperty("watt.security.CADir");
        if (caDir == null || caDir.length() == 0) {
            return;
        }
        X509Certificate[] authorities = Util.loadCertificatesFromDir(caDir);
        if (authorities != null) {
            for (int i = 0; i < authorities.length; ++i) {
                defaultVerifier.addTrustedCertificate(authorities[i]);
            }
        }
    }

    public static void reloadDefaultAuthorities() {
        defaultVerifier.loadDefaultAuthorities();
    }
}

