/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security.hw.ncipher;

import com.ncipher.nfast.connect.ClientException;
import com.ncipher.nfast.connect.CommandTooBig;
import com.ncipher.nfast.connect.NFConnection;
import com.ncipher.nfast.marshall.M_Bignum;
import com.ncipher.nfast.marshall.M_Cmd;
import com.ncipher.nfast.marshall.M_Cmd_Args_RSAImmedSignDecrypt;
import com.ncipher.nfast.marshall.M_Cmd_Args_RSAImmedVerifyEncrypt;
import com.ncipher.nfast.marshall.M_Cmd_Reply_RSAImmedSignDecrypt;
import com.ncipher.nfast.marshall.M_Command;
import com.ncipher.nfast.marshall.M_Reply;
import com.ncipher.nfast.marshall.M_Status;
import com.ncipher.nfast.marshall.MarshallTypeError;
import com.wm.security.hw.ncipher.RSAPublicKey;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.interfaces.RSAPrivateCrtKey;

public class Util {
    static final int CONN_FLAGS = 4;
    static final String COMMANDS_DONT_MATCH = "Reply received does not match submitted command";
    static final String NOT_CONNECTED = "No connection to accelerator";
    static final String HARDSERVER_PORT_PROPERTY = "watt.security.hw.ncipher.standardPort";
    static final long DELAY_CHECK = 300000L;
    static boolean FailedInit;
    static boolean IsConnected;
    static long NextCheck;
    static NFConnection Connection;

    static void init() {
        IsConnected = false;
        FailedInit = false;
        Util.openConnection();
        if (!IsConnected) {
            FailedInit = true;
        }
    }

    static void openConnection() {
        String s = Config.getProperty(HARDSERVER_PORT_PROPERTY);
        int port = -1;
        if (s != null && s.length() > 0) {
            try {
                port = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                JournalLogger.logDebugPlus(2, 3, 27);
            }
        }
        IsConnected = false;
        try {
            Connection = port == -1 ? new NFConnection(4) : new NFConnection(4, InetAddress.getByName("localhost"), port);
            IsConnected = true;
            JournalLogger.logDebugPlus(4, 5, 27);
        }
        catch (Exception e) {
            JournalLogger.logWarning(1, 27);
            JournalLogger.logDebugPlus(2, 2, 27, e.getMessage());
            IsConnected = false;
            NextCheck = System.currentTimeMillis() + 300000L;
        }
    }

    static M_Reply transact(M_Command command) throws ClientException, CommandTooBig, IOException, MarshallTypeError {
        if (!IsConnected) {
            if (System.currentTimeMillis() >= NextCheck) {
                Util.openConnection();
            }
            if (!IsConnected) {
                throw new IOException(NOT_CONNECTED);
            }
        }
        M_Reply reply = null;
        try {
            reply = Connection.transact(command);
        }
        catch (IOException ioe) {
            IsConnected = false;
            try {
                Connection.close(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            NextCheck = System.currentTimeMillis() + 300000L;
            JournalLogger.logDebugPlus(2, 4, 27, ioe.getMessage());
            throw ioe;
        }
        if (reply.cmd != command.cmd) {
            throw new ClientException(COMMANDS_DONT_MATCH);
        }
        if (reply.status != 0L) {
            StringBuffer sb = new StringBuffer();
            sb.append(M_Cmd.toString((long)reply.cmd));
            sb.append(" returned status ");
            sb.append(M_Status.toString((long)reply.status));
            throw new ClientException(sb.toString());
        }
        return reply;
    }

    public static final BigInteger crypt(RSAPrivateCrtKey key, BigInteger message) throws ClientException, CommandTooBig, IOException, MarshallTypeError {
        M_Command command = new M_Command();
        command.cmd = 78L;
        M_Cmd_Args_RSAImmedSignDecrypt args = new M_Cmd_Args_RSAImmedSignDecrypt();
        command.args = args;
        args.k_dmp1 = new M_Bignum(key.getPrimeExponentP());
        args.k_dmq1 = new M_Bignum(key.getPrimeExponentQ());
        args.k_iqmp = new M_Bignum(key.getCrtCoefficient());
        args.k_p = new M_Bignum(key.getPrimeP());
        args.k_q = new M_Bignum(key.getPrimeQ());
        args.m = new M_Bignum(message);
        M_Reply rep = Util.transact(command);
        M_Cmd_Reply_RSAImmedSignDecrypt reply = (M_Cmd_Reply_RSAImmedSignDecrypt)rep.reply;
        return reply.r.value;
    }

    public static final BigInteger crypt(RSAPublicKey key, BigInteger message) throws ClientException, CommandTooBig, IOException, MarshallTypeError {
        M_Command command = new M_Command();
        command.cmd = 79L;
        M_Cmd_Args_RSAImmedVerifyEncrypt args = new M_Cmd_Args_RSAImmedVerifyEncrypt();
        command.args = args;
        args.k_e = new M_Bignum(key.getPublicExponent());
        args.k_n = new M_Bignum(key.getModulus());
        args.m = new M_Bignum(message);
        M_Reply rep = Util.transact(command);
        M_Cmd_Reply_RSAImmedSignDecrypt reply = (M_Cmd_Reply_RSAImmedSignDecrypt)rep.reply;
        return reply.r.value;
    }
}

