/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security.hw.ncipher;

import com.entrust.toolkit.security.provider.Entrust;
import com.wm.security.hw.ncipher.RSAPrivateKey;
import com.wm.security.hw.ncipher.Util;
import iaik.asn1.ASN1Object;
import iaik.security.provider.IAIK;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.RSAPublicKeySpec;

public class RSAPublicKey
extends iaik.security.rsa.RSAPublicKey {
    static final boolean DEBUG = false;

    public RSAPublicKey(BigInteger modulus, BigInteger publicExponent) {
        super(modulus, publicExponent);
    }

    public RSAPublicKey(RSAPublicKeySpec keySpec) {
        super(keySpec);
    }

    public RSAPublicKey(java.security.interfaces.RSAPublicKey key) {
        super(key);
    }

    public RSAPublicKey(byte[] pk) throws InvalidKeyException {
        super(pk);
    }

    public RSAPublicKey(ASN1Object obj) throws InvalidKeyException {
        super(obj);
    }

    public RSAPublicKey(InputStream is) throws IOException, InvalidKeyException {
        super(is);
    }

    public BigInteger crypt(BigInteger message) {
        try {
            return Util.crypt(this, message);
        }
        catch (Exception exception) {
            return super.crypt(message);
        }
    }

    static void debug(String msg) {
        System.err.println("RSAPublicKey> " + msg);
    }

    public static void main(String[] args) throws Exception {
        Security.insertProviderAt((Provider)new Entrust(), 2);
        Security.insertProviderAt((Provider)new IAIK(), 3);
        String keyPath = "d:/devel/main/product/server/config/key.der";
        if (args.length > 0) {
            keyPath = args[0];
        }
        iaik.security.rsa.RSAPrivateKey pk = (iaik.security.rsa.RSAPrivateKey)com.wm.security.Util.loadRSAPrivateKey(keyPath);
        RSAPrivateKey privKey = new RSAPrivateKey((java.security.interfaces.RSAPrivateKey)pk);
        RSAPublicKey pubKey = (RSAPublicKey)((Object)privKey.getPublicKey());
        BigInteger plaintext = new BigInteger(1, "WEBM is awesome".getBytes());
        BigInteger ciphertext = pubKey.crypt(plaintext);
        BigInteger immed = privKey.crypt(ciphertext);
        long start = System.currentTimeMillis();
        ciphertext = pubKey.crypt(plaintext);
        immed = privKey.crypt(ciphertext);
        long hwTime = System.currentTimeMillis();
        hwTime -= start;
        iaik.security.rsa.RSAPublicKey pubK = (iaik.security.rsa.RSAPublicKey)pk.getPublicKey();
        start = System.currentTimeMillis();
        ciphertext = pubK.crypt(plaintext);
        immed = pk.crypt(ciphertext);
        long javaTime = System.currentTimeMillis();
        RSAPublicKey.debug("Encrypt/Decrypt (java) :" + Long.toString(javaTime -= start));
        RSAPublicKey.debug("Encrypt/Decrypt (hw)   :" + Long.toString(hwTime));
        byte[] message = immed.toByteArray();
        RSAPublicKey.debug("Plaintext: " + plaintext.toByteArray());
        RSAPublicKey.debug("Decrypted: " + new String(message));
    }
}

