/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security.hw.ncipher;

import com.entrust.toolkit.security.provider.Entrust;
import com.wm.security.hw.ncipher.RSAPublicKey;
import com.wm.security.hw.ncipher.Util;
import iaik.asn1.ASN1Object;
import iaik.security.provider.IAIK;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateKeySpec;

public class RSAPrivateKey
extends iaik.security.rsa.RSAPrivateKey {
    static final boolean DEBUG = false;
    static final BigInteger ZERO = BigInteger.valueOf(0L);
    private int version = 0;

    protected RSAPrivateKey() {
    }

    public RSAPrivateKey(BigInteger modulus, BigInteger privateExponent) {
        this(modulus, ZERO, privateExponent, ZERO, ZERO, ZERO, ZERO, ZERO);
    }

    public RSAPrivateKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) {
        super(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
    }

    public RSAPrivateKey(RSAPrivateKeySpec keySpec) {
        super(keySpec);
    }

    public RSAPrivateKey(java.security.interfaces.RSAPrivateKey key) {
        super(key);
    }

    public RSAPrivateKey(byte[] pk) throws InvalidKeyException {
        super(pk);
    }

    public RSAPrivateKey(ASN1Object obj) throws InvalidKeyException {
        super(obj);
    }

    public RSAPrivateKey(InputStream is) throws IOException, InvalidKeyException {
        super(is);
    }

    public PublicKey getPublicKey() {
        return new RSAPublicKey(this.getModulus(), this.getPublicExponent());
    }

    public BigInteger crypt(BigInteger message) {
        try {
            return Util.crypt((RSAPrivateCrtKey)((Object)this), message);
        }
        catch (Exception exception) {
            return super.crypt(message);
        }
    }

    public Object clone() {
        return new RSAPrivateKey((java.security.interfaces.RSAPrivateKey)((Object)this));
    }

    static void debug(String msg) {
        System.err.println("RSAPrivateKey> " + msg);
    }

    public static void main(String[] args) throws Exception {
        Security.insertProviderAt((Provider)new Entrust(), 2);
        Security.insertProviderAt((Provider)new IAIK(), 3);
        String keyPath = "d:/devel/main/product/server/config/key.der";
        iaik.security.rsa.RSAPrivateKey pk = (iaik.security.rsa.RSAPrivateKey)com.wm.security.Util.loadRSAPrivateKey(keyPath);
        RSAPrivateKey privKey = new RSAPrivateKey((java.security.interfaces.RSAPrivateKey)pk);
        pk = privKey;
        RSAPublicKey pubKey = (RSAPublicKey)((Object)privKey.getPublicKey());
        BigInteger plaintext = new BigInteger(1, "WEBM is awesome".getBytes());
        BigInteger ciphertext = pubKey.crypt(plaintext);
        BigInteger immed = privKey.crypt(ciphertext);
        byte[] message = immed.toByteArray();
        RSAPrivateKey.debug("Plaintext: " + plaintext.toByteArray());
        RSAPrivateKey.debug("Decrypted: " + new String(message));
    }
}

