/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security.hw.ncipher;

import com.wm.security.hw.ncipher.RSAPrivateKey;
import com.wm.security.hw.ncipher.RSAPublicKey;
import com.wm.util.SecurityUtil;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public final class RSAKeyFactory
extends KeyFactorySpi {
    static final String INVALID_KEYSPEC = "Invalid KeySpec";
    static final String ONLY_RSA_KEYSPEC = "Only RSA key specs allowed";
    static final String ONLY_RSA_KEYS_TRANSLATED = "Only keys of type RSAPrivate or RSAPublic can be translated";
    KeyFactory _iaikFactory = KeyFactory.getInstance("RSA", SecurityUtil.getFipsProvider());

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        PrivateKey key = this._iaikFactory.generatePrivate(keySpec);
        if (key instanceof iaik.security.rsa.RSAPrivateKey) {
            return new RSAPrivateKey((java.security.interfaces.RSAPrivateKey)((iaik.security.rsa.RSAPrivateKey)key));
        }
        return key;
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        PublicKey key = this._iaikFactory.generatePublic(keySpec);
        if (key instanceof iaik.security.rsa.RSAPublicKey) {
            return new RSAPublicKey((java.security.interfaces.RSAPublicKey)((iaik.security.rsa.RSAPublicKey)key));
        }
        return key;
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        return this._iaikFactory.getKeySpec(key, keySpec);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        Key k = this._iaikFactory.translateKey(key);
        if (k instanceof iaik.security.rsa.RSAPrivateKey) {
            return new RSAPrivateKey((java.security.interfaces.RSAPrivateKey)((iaik.security.rsa.RSAPrivateKey)k));
        }
        if (k instanceof iaik.security.rsa.RSAPublicKey) {
            return new RSAPublicKey((java.security.interfaces.RSAPublicKey)((iaik.security.rsa.RSAPublicKey)k));
        }
        throw new InvalidKeyException(ONLY_RSA_KEYS_TRANSLATED);
    }
}

