/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security.cert;

import com.wm.security.Util;
import com.wm.security.resources.CertificateExceptionBundle;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedCertificateException;
import com.wm.util.LocalizedCertificateExpiredException;
import iaik.x509.SimpleChainVerifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Vector;

public class wmChainVerifier
extends SimpleChainVerifier
implements Cloneable {
    static final String ALLOW_EXPIRED_CHAINS_PROP = "watt.security.ssl.ignoreExpiredChains";
    static final String ENFORCE_EXTENSIONS_CHECK_PROP = "wm.security.cert.wmChainVerifier.enforExtensionChecks";
    static final String CHECK_ENTIRE_CHAIN_PROP = "wm.security.cert.wmChainVerifier.checkEntireChain";
    static final String TRUST_BY_DEFAULT_PROP = "watt.security.cert.wmChainVerifier.trustByDefault";
    static final boolean ALLOW_EXPIRED_CHAINS_DEFAULT = false;
    static final boolean ENFORCE_EXTENSIONS_CHECK_DEFAULT = false;
    static final boolean CHECK_ENTIRE_CHAIN_DEFAULT = false;
    static final boolean TRUST_BY_DEFAULT_DEFAULT = true;
    static wmChainVerifier Default;
    static boolean initialized;
    protected Hashtable _trustedDNs;
    protected boolean _allowExpiredChains;
    protected boolean _enforceExtensionChecks;
    protected boolean _checkEntireChain;
    protected boolean _trustByDefault;

    public static void init() {
        if (initialized) {
            return;
        }
        Default = new wmChainVerifier();
        Default.loadDefaultAuthorities();
        initialized = true;
    }

    protected void loadDefaultAuthorities() {
        String caDir = Config.getProperty("watt.security.CADir");
        if (caDir == null || caDir.length() == 0) {
            return;
        }
        X509Certificate[] authorities = Util.loadCertificatesFromDir(caDir);
        this.setTrustedCertificates(authorities);
    }

    public static void reloadDefaultAuthorities() {
        wmChainVerifier.getDefault().loadDefaultAuthorities();
    }

    public static wmChainVerifier getDefault() {
        if (!initialized) {
            wmChainVerifier.init();
        }
        return Default;
    }

    public wmChainVerifier() {
        this.updateFromProperties();
        this._trustedDNs = new Hashtable();
    }

    public void updateFromProperties() {
        this._allowExpiredChains = Config.getProperty(ALLOW_EXPIRED_CHAINS_PROP) == null ? false : Boolean.getBoolean(ALLOW_EXPIRED_CHAINS_PROP);
        this._enforceExtensionChecks = Config.getProperty(ENFORCE_EXTENSIONS_CHECK_PROP) == null ? false : Boolean.getBoolean(ENFORCE_EXTENSIONS_CHECK_PROP);
        this._checkEntireChain = Config.getProperty(CHECK_ENTIRE_CHAIN_PROP) == null ? false : Boolean.getBoolean(CHECK_ENTIRE_CHAIN_PROP);
        this._trustByDefault = Config.getProperty(TRUST_BY_DEFAULT_PROP) == null ? true : Boolean.getBoolean(TRUST_BY_DEFAULT_PROP);
    }

    public boolean ignoreExpiredChains() {
        return this._allowExpiredChains;
    }

    public boolean enforceExtensionChecking() {
        return this._enforceExtensionChecks;
    }

    public boolean checkEntireChain() {
        return this._checkEntireChain;
    }

    public boolean trustByDefault() {
        return this._trustByDefault;
    }

    public void allowExpiredChains(boolean allow) {
        this._allowExpiredChains = allow;
    }

    public void setExtensionChecking(boolean enforce) {
        this._enforceExtensionChecks = enforce;
    }

    public void checkEntireChain(boolean check) {
        this._checkEntireChain = check;
    }

    public void setTrustByDefault(boolean trust) {
        this._trustByDefault = trust;
    }

    protected void checkExtensions(X509Certificate[] chain, int index) throws CertificateException {
        block2: {
            try {
                super.checkExtensions(chain, index);
            }
            catch (CertificateException ce) {
                if (!this._enforceExtensionChecks) break block2;
                JournalLogger.logDebugPlus(2, 7, 9, ((Object)chain[index].getSubjectDN()).toString());
                throw ce;
            }
        }
    }

    public boolean verifyChain(X509Certificate[] chain, boolean reversed) throws CertificateException {
        int len = chain.length;
        if (reversed) {
            X509Certificate[] tempChain = new X509Certificate[len];
            for (int i = 0; i < len; ++i) {
                tempChain[i] = chain[len - i - 1];
            }
            chain = tempChain;
        }
        try {
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    if (!((Object)chain[i].getSubjectDN()).equals(chain[i - 1].getIssuerDN())) {
                        throw new LocalizedCertificateException(CertificateExceptionBundle.class, CertificateExceptionBundle.CERT_CHAIN_BROKEN, "");
                    }
                    chain[i - 1].verify(chain[i].getPublicKey());
                }
                if (((Object)chain[i].getSubjectDN()).equals(chain[i].getIssuerDN())) {
                    chain[i].verify(chain[i].getPublicKey());
                }
                this.checkExtensions(chain, i);
                try {
                    chain[i].checkValidity();
                    continue;
                }
                catch (CertificateExpiredException ce) {
                    if (this._allowExpiredChains) continue;
                    JournalLogger.logDebugPlus(2, 8, 9, ((Object)chain[i].getSubjectDN()).toString());
                    if (ce.getMessage() == null) {
                        throw new LocalizedCertificateExpiredException(CertificateExceptionBundle.class, CertificateExceptionBundle.CERT_EXPIRED, "", ((Object)chain[i].getSubjectDN()).toString());
                    }
                    throw ce;
                }
            }
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new LocalizedCertificateException(CertificateExceptionBundle.class, CertificateExceptionBundle.CERT_ERROR_IN_CHAIN, "");
        }
        return true;
    }

    public void addTrustedCertificate(X509Certificate certificate) {
        super.addTrustedCertificate(certificate);
        Vector<X509Certificate> v = (Vector<X509Certificate>)this._trustedDNs.get(certificate.getSubjectDN());
        if (v == null) {
            v = new Vector<X509Certificate>();
            this._trustedDNs.put(certificate.getSubjectDN(), v);
        }
        if (!v.contains(certificate)) {
            v.addElement(certificate);
        }
    }

    public boolean isTrustedChain(X509Certificate[] chain) throws CertificateException {
        return this.isTrustedChain(chain, false);
    }

    public boolean isTrustedChain(X509Certificate[] chain, boolean reversed) throws CertificateException {
        int i;
        if (this.signers == null || this.signers.size() == 0) {
            return this.trustByDefault();
        }
        int len = chain.length;
        if (reversed) {
            X509Certificate[] tempChain = new X509Certificate[len];
            for (int i2 = 0; i2 < len; ++i2) {
                tempChain[i2] = chain[len - i2 - 1];
            }
            chain = tempChain;
        }
        for (i = 0; i < len; ++i) {
            if (!this.isTrustedCertificate(chain[i])) continue;
            return true;
        }
        return this.isSignerTrusted(chain[i - 1]);
    }

    public boolean isSignerTrusted(X509Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        Vector v = (Vector)this._trustedDNs.get(certificate.getIssuerDN());
        if (v == null || v.size() == 0) {
            return false;
        }
        int len = v.size();
        for (int i = 0; i < len; ++i) {
            try {
                X509Certificate authority = (X509Certificate)v.elementAt(i);
                certificate.verify(authority.getPublicKey());
                return true;
            }
            catch (CertificateException ce) {
                continue;
            }
            catch (SignatureException se) {
                continue;
            }
            catch (NoSuchProviderException nspe) {
                continue;
            }
            catch (InvalidKeyException ike) {
                continue;
            }
            catch (NoSuchAlgorithmException nsae) {
                // empty catch block
            }
        }
        return false;
    }

    public Object clone() {
        wmChainVerifier newObj = new wmChainVerifier();
        newObj.signers = (Hashtable)this.signers.clone();
        newObj._trustedDNs = (Hashtable)this._trustedDNs.clone();
        newObj._allowExpiredChains = this._allowExpiredChains;
        newObj._checkEntireChain = this._checkEntireChain;
        newObj._enforceExtensionChecks = this._enforceExtensionChecks;
        newObj._trustByDefault = this._trustByDefault;
        return newObj;
    }

    static {
        initialized = false;
        wmChainVerifier.init();
    }
}

