/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security;

import com.entrust.toolkit.util.Version;
import com.wm.util.Config;
import iaik.security.random.SecRandom;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.IaikProvider;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SecurityProvider;
import java.io.FileInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;

public class WmSecurityProvider
extends IaikProvider {
    private static boolean _debug = false;
    protected static Hashtable _listenerProfileRegistry = new Hashtable(3);
    private static WmSecurityProvider _instance;

    public static synchronized WmSecurityProvider getInstance(String providerName) {
        if (_instance == null) {
            _instance = new WmSecurityProvider(providerName);
        }
        return _instance;
    }

    private WmSecurityProvider(String name) {
        SecurityProvider.setSecurityProvider((SecurityProvider)this);
    }

    public static void registerProviderForKey(String keyName, String providerName) {
        _listenerProfileRegistry.put(keyName, providerName);
        if (_debug) {
            System.out.println("WmSecurityProvider--->Entrust Version = " + Version.VERSION);
        }
    }

    protected Cipher getCipher(String algorithm, int mode, Key key, AlgorithmParameterSpec spec, SecureRandom random) throws GeneralSecurityException {
        Cipher cipher;
        block18: {
            block17: {
                if (_debug) {
                    if (key != null) {
                        System.out.println("WmSecurityProvider--->getCipher called algorithm=" + algorithm + " key=" + key.getClass().getName() + " the format=" + key.getFormat());
                    } else {
                        System.out.println("WmSecurityProvider--->getCipher called algorithm=" + algorithm);
                    }
                }
                boolean useHSMProvider = false;
                String providerName = null;
                if (algorithm.equals("RSA/ECB/PKCS1Padding/Decrypt") || algorithm.equals("RSA/1/PKCS1Padding")) {
                    String className = key.getClass().getName();
                    if (_debug) {
                        System.out.println("The classname of the key =" + className);
                    }
                    if (_listenerProfileRegistry.containsKey(className)) {
                        providerName = (String)_listenerProfileRegistry.get(className);
                        useHSMProvider = true;
                    }
                }
                if (algorithm.startsWith("RSA/ECB/PKCS1Padding")) {
                    algorithm = "RSA/ECB/PKCS1Padding";
                }
                cipher = null;
                if (useHSMProvider) {
                    try {
                        String string = providerName = Config.getProperty("watt.ssl.accelerator.provider") != null ? Config.getProperty("watt.ssl.accelerator.provider") : providerName;
                        if (providerName == null) {
                            providerName = "nCipherKM";
                        }
                        cipher = Cipher.getInstance(algorithm, providerName);
                    }
                    catch (Exception e) {
                        if (!_debug) break block17;
                        e.printStackTrace();
                    }
                }
            }
            if (cipher == null) {
                try {
                    cipher = Cipher.getInstance(algorithm, "Entrust");
                }
                catch (Throwable t) {
                    if (!_debug) break block18;
                    t.printStackTrace();
                }
            }
        }
        if (cipher != null && mode != CIPHER_NONE) {
            try {
                int cmode = mode == CIPHER_ENCRYPT ? 1 : 2;
                cipher.init(cmode, key, spec, random);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return cipher;
    }

    public static void setDebug(boolean b) {
        _debug = b;
    }

    public void test() {
        block2: {
            try {
                SSLServerContext sslContext = new SSLServerContext();
                sslContext.setAllowedProtocolVersions(768, 769);
                sslContext.setRandomGenerator(SecRandom.getDefault());
                CipherSuiteList ciphers = new CipherSuiteList();
                ciphers.add(CipherSuite.CS_RSA_EXPORT);
                ciphers.add(CipherSuite.CS_RSA_EXPORT1024);
                ciphers.remove(CipherSuite.SSL_RSA_WITH_IDEA_CBC_SHA);
                ciphers.ensureAvailable();
                sslContext.setEnabledCipherSuiteList(ciphers);
                sslContext.updateCipherSuites();
            }
            catch (Exception e) {
                if (!_debug) break block2;
                System.out.println("The exception e in loading ciphersuites=" + e);
                e.printStackTrace();
            }
        }
    }

    public Key getPrivateKey() {
        Key returnKey = null;
        try {
            Key key;
            String keyStoreProvider = "nCipherKM";
            String keystoreFile = "d:/webtest/elbe/601ga/integrationserver/config/.keystore";
            String keystorePassword = "manage";
            String alias = "sumeet";
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType(), keyStoreProvider);
            FileInputStream in = new FileInputStream(keystoreFile);
            keystore.load(in, keystorePassword.toCharArray());
            in.close();
            if (_debug) {
                System.out.println(" keystore loaded" + keystore + " size=" + keystore.size());
            }
            Enumeration<String> en = keystore.aliases();
            while (en.hasMoreElements()) {
                String storealias = en.nextElement();
            }
            Certificate[] chain = keystore.getCertificateChain(alias);
            if (_debug) {
                if (chain != null) {
                    System.out.println("certificate at index 1=" + chain[0].getClass().getSuperclass().getName());
                } else {
                    System.out.println(" The chain from the keystore is null");
                }
            }
            X509Certificate testCert = (X509Certificate)chain[1];
            RSAPrivateKey rsaPrivateKey = null;
            returnKey = key = keystore.getKey(alias, keystorePassword.toCharArray());
            if (key instanceof PrivateKey) {
                rsaPrivateKey = (RSAPrivateKey)key;
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnKey;
    }
}

