/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security;

import com.entrust.toolkit.security.fips.SecurityEngine;
import com.wm.util.Files;
import com.wm.util.JournalLogger;
import com.wm.util.SecurityUtil;
import iaik.asn1.ASN1;
import iaik.asn1.CodingException;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.ssl.KeyAndCert;
import iaik.utils.ASN1InputStream;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Collection;
import java.util.Vector;

public final class Util {
    static final boolean _debug = true;

    public static PrivateKey loadRSAPrivateKey(String file) throws IOException, InvalidKeyException {
        return Util.loadRSAPrivateKey(new File(file));
    }

    public static PrivateKey loadRSAPrivateKey(File file) throws IOException, InvalidKeyException {
        byte[] img = Files.readFully(file);
        return Util.loadRSAPrivateKey(img);
    }

    public static PrivateKey loadRSAPrivateKey(byte[] img) throws InvalidKeyException {
        KeyFactory factory = null;
        Key temp = null;
        try {
            temp = PrivateKeyInfo.getPrivateKey((byte[])img);
            if (factory != null) {
                temp = factory.translateKey(temp);
            }
            return temp;
        }
        catch (InvalidKeyException orig) {
            try {
                temp = Util.loadPKCS1(img);
            }
            catch (InvalidKeyException ike) {
                throw orig;
            }
            catch (Throwable t) {
                throw orig;
            }
            try {
                factory = KeyFactory.getInstance("RSA", SecurityUtil.getFipsProvider());
                temp = factory.translateKey(temp);
            }
            catch (NoSuchAlgorithmException nsae) {
            }
            catch (InvalidKeyException ike) {
            }
            catch (NoSuchProviderException noSuchProviderException) {
                // empty catch block
            }
            return temp;
        }
    }

    private static final PrivateKey loadPKCS1(byte[] data) throws InvalidKeyException {
        RSAPrivateKey privateKey = null;
        try {
            ASN1 asn1 = new ASN1(data);
            int version = ((BigInteger)asn1.getComponentAt(0).getValue()).intValue();
            BigInteger modulus = (BigInteger)asn1.getComponentAt(1).getValue();
            BigInteger pubExp = (BigInteger)asn1.getComponentAt(2).getValue();
            BigInteger privExp = (BigInteger)asn1.getComponentAt(3).getValue();
            BigInteger primeP = (BigInteger)asn1.getComponentAt(4).getValue();
            BigInteger primeQ = (BigInteger)asn1.getComponentAt(5).getValue();
            BigInteger primeExpP = (BigInteger)asn1.getComponentAt(6).getValue();
            BigInteger primeExpQ = (BigInteger)asn1.getComponentAt(7).getValue();
            BigInteger crtCoefficient = (BigInteger)asn1.getComponentAt(8).getValue();
            if (primeP.compareTo(primeQ) < 0) {
                BigInteger one = BigInteger.valueOf(1L);
                BigInteger biginteger = primeP;
                primeP = primeQ;
                primeQ = biginteger;
                primeExpP = privExp.mod(primeP.subtract(one));
                primeExpQ = privExp.mod(primeQ.subtract(one));
                crtCoefficient = primeQ.modInverse(primeP);
            }
            RSAPrivateCrtKeySpec crtPrivateKey = new RSAPrivateCrtKeySpec(modulus, pubExp, privExp, primeP, primeQ, primeExpP, primeExpQ, crtCoefficient);
            privateKey = new RSAPrivateKey((RSAPrivateKeySpec)crtPrivateKey);
        }
        catch (CodingException ce) {
            throw new InvalidKeyException(ce.getMessage());
        }
        return privateKey;
    }

    public static java.security.cert.X509Certificate[] loadX509Chain(String[] files) throws CertificateException, IOException {
        if (files == null) {
            return null;
        }
        X509Certificate[] chain = new X509Certificate[files.length];
        for (int i = 0; i < files.length; ++i) {
            FileInputStream fis = new FileInputStream(new File(files[i]));
            chain[i] = new X509Certificate((InputStream)fis);
            fis.close();
        }
        return chain;
    }

    public static java.security.cert.X509Certificate[] loadX509Chain(byte[][] bytes) throws CertificateException, IOException {
        if (bytes == null) {
            return null;
        }
        X509Certificate[] chain = new X509Certificate[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chain[i] = new X509Certificate(bytes[i]);
        }
        return chain;
    }

    public static KeyAndCert loadKeyAndChain(String keyPath, String[] certPaths) throws CertificateException, IOException, InvalidKeyException {
        if (keyPath == null || keyPath.length() == 0) {
            return null;
        }
        if (certPaths == null || certPaths.length == 0) {
            return null;
        }
        Object kac = null;
        PrivateKey pk = Util.loadRSAPrivateKey(keyPath);
        java.security.cert.X509Certificate[] chain = Util.loadX509Chain(certPaths);
        return new KeyAndCert((java.security.cert.X509Certificate[])((X509Certificate[])chain), pk);
    }

    public static java.security.cert.X509Certificate[] loadCertificatesFromDir(String dirName) {
        if (dirName == null || dirName.length() == 0) {
            return null;
        }
        return Util.loadCertificatesFromDir(new File(dirName));
    }

    public static java.security.cert.X509Certificate[] loadCertificatesFromDir(File dir) {
        String[] list;
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        if (dir.exists() && dir.isDirectory() && (list = dir.list()) != null && list.length > 0) {
            int len = list.length;
            for (int i = 0; i < len; ++i) {
                File certFile = new File(dir, list[i]);
                if (certFile.exists() && certFile.isDirectory()) continue;
                try {
                    FileInputStream fis = new FileInputStream(certFile);
                    X509Certificate cert = new X509Certificate((InputStream)fis);
                    v.addElement(cert);
                    fis.close();
                    continue;
                }
                catch (Exception e) {
                    JournalLogger.logDebugPlus(2, 6, 9, certFile.getAbsolutePath(), e.getMessage());
                }
            }
        }
        Object[] certs = new java.security.cert.X509Certificate[v.size()];
        v.copyInto(certs);
        return certs;
    }

    public static java.security.cert.X509Certificate loadCertificate(byte[] certBytes) throws CertificateException {
        if (certBytes == null) {
            return null;
        }
        X509Certificate cert = new X509Certificate(certBytes);
        return cert;
    }

    public static java.security.cert.X509Certificate[] loadCertificate(byte[] certBytes, boolean chain) throws CertificateException {
        CertificateFactory cf;
        if (certBytes == null) {
            return null;
        }
        ByteArrayInputStream bais = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "IAIK");
        }
        catch (NoSuchProviderException nspe) {
            throw new CertificateException(nspe.getLocalizedMessage());
        }
        catch (CertificateException ce0) {
            throw ce0;
        }
        try {
            bais = new ByteArrayInputStream(certBytes);
            Collection<? extends Certificate> c = cf.generateCertificates(bais);
            Object[] tmp = c.toArray();
            X509Certificate[] certs = new X509Certificate[c.toArray().length];
            for (int i = 0; i < tmp.length; ++i) {
                certs[i] = (X509Certificate)tmp[i];
            }
            return certs;
        }
        catch (CertificateException ce) {
            bais = new ByteArrayInputStream(certBytes);
            try {
                X509Certificate[] certs = new PKCS7CertList((InputStream)new ASN1InputStream((InputStream)bais)).getCertificateList();
                return certs;
            }
            catch (Exception e) {
                X509Certificate[] certs = new X509Certificate[]{new X509Certificate(certBytes)};
                return certs;
            }
        }
    }

    public static java.security.cert.X509Certificate[] loadCertificateFromFile(String fileName) throws FileNotFoundException, CertificateException, IOException {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X.509", "IAIK");
        }
        catch (CertificateException ce0) {
            throw ce0;
        }
        catch (NoSuchProviderException nspe) {
            throw new CertificateException(nspe.getLocalizedMessage());
        }
        FileInputStream certFis = new FileInputStream(fileName);
        try {
            Collection<? extends Certificate> c = cf.generateCertificates(certFis);
            Object[] tmp = c.toArray();
            X509Certificate[] certs = new X509Certificate[c.toArray().length];
            for (int i = 0; i < tmp.length; ++i) {
                certs[i] = (X509Certificate)tmp[i];
            }
            return certs;
        }
        catch (CertificateException ce) {
            try {
                X509Certificate[] certs = new PKCS7CertList((InputStream)new ASN1InputStream((InputStream)certFis)).getCertificateList();
                return certs;
            }
            catch (Exception e) {
                certFis.close();
                try {
                    FileInputStream fis1 = new FileInputStream(fileName);
                    X509Certificate[] certs = new X509Certificate[]{new X509Certificate((InputStream)fis1)};
                    fis1.close();
                    return certs;
                }
                catch (FileNotFoundException fe) {
                    throw fe;
                }
                catch (CertificateException ce1) {
                    throw ce1;
                }
                catch (IOException io) {
                    throw io;
                }
            }
        }
    }

    public static byte[] getDigest(byte[] input) throws Exception {
        MessageDigest digest = null;
        digest = SecurityUtil.isInFipsMode() ? MessageDigest.getInstance("SHA1", SecurityUtil.getFipsProvider()) : MessageDigest.getInstance("SHA1");
        byte[] output = null;
        if (input != null) {
            output = digest.digest(input);
        }
        return output;
    }

    private static int minValue(int x, int y) {
        if (x > y) {
            return y;
        }
        return x;
    }

    private static final void saveCertificates(String[] certFiles, Object[] certs) throws IOException {
        if (certFiles != null && certs != null) {
            for (int i = 0; i < Util.minValue(certs.length, certFiles.length); ++i) {
                X509Certificate cert = (X509Certificate)certs[i];
                FileOutputStream fos = new FileOutputStream(certFiles[i]);
                cert.writeTo((OutputStream)fos);
            }
        }
    }

    public static java.security.cert.X509Certificate[] buildCertificateChain(java.security.cert.X509Certificate signer, java.security.cert.X509Certificate[] set) {
        boolean found;
        if (signer == null) {
            return null;
        }
        if (set == null || set.length == 0) {
            return new java.security.cert.X509Certificate[]{signer};
        }
        Vector<java.security.cert.X509Certificate> v = new Vector<java.security.cert.X509Certificate>();
        v.addElement(signer);
        boolean endOfChain = false;
        java.security.cert.X509Certificate cert = signer;
        Principal issuer = cert.getIssuerDN();
        do {
            found = false;
            for (int i = 0; !found && i < set.length; ++i) {
                Principal subject = set[i].getSubjectDN();
                if (!((Object)subject).equals(issuer)) continue;
                try {
                    cert.verify(set[i].getPublicKey());
                    found = true;
                    v.addElement(set[i]);
                    cert = set[i];
                    issuer = cert.getIssuerDN();
                    if (!((Object)subject).equals(issuer)) continue;
                    try {
                        cert.verify(cert.getPublicKey());
                        endOfChain = true;
                    }
                    catch (Exception e) {}
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } while (!endOfChain && found);
        Object[] chain = new java.security.cert.X509Certificate[v.size()];
        v.copyInto(chain);
        return chain;
    }

    public static boolean isInFIPSMode() {
        return SecurityEngine.isInFIPSMode();
    }

    public static void printProviders() {
        Provider[] aprovider = Security.getProviders();
        for (int j = 0; j < aprovider.length; ++j) {
            System.out.println(j + 1 + " . Provider Name is : " + aprovider[j].getName());
        }
    }
}

