/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security;

import com.wm.security.Config;
import com.wm.security.TrustDeciderManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;

public class TrustManager {
    static boolean Initialized = false;
    static TrustDeciderManager Manager;
    static final String DEF_MANAGER = "com.wm.security.wmTrustDeciderManager";
    static final String UTIL_CLASS = "com.wm.security.Util";
    static final String LOAD_KEY_N_CHAIN_METHOD = "loadKeyAndChain";
    static Method mKeyAndChain;

    public static synchronized void init() {
        if (Initialized) {
            return;
        }
        if (Config.isSSLPresent()) {
            try {
                Class<?> defMgr = Class.forName(DEF_MANAGER);
                Manager = (TrustDeciderManager)defMgr.newInstance();
                Class<?> loader = Class.forName(UTIL_CLASS);
                Class[] args = new Class[]{String.class, String[].class};
                mKeyAndChain = loader.getDeclaredMethod(LOAD_KEY_N_CHAIN_METHOD, args);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            Manager = null;
        }
        Initialized = true;
    }

    public static TrustDeciderManager getManager() {
        return Manager;
    }

    public static void setManager(TrustDeciderManager tdm) {
        Manager = tdm;
    }

    public static void setKeyAndChain(Object kac) {
        if (Manager != null) {
            Manager.setKeyAndCert(kac);
        }
    }

    public static Object getKeyAndChain() {
        if (Manager != null) {
            return Manager.getKeyAndCert();
        }
        return null;
    }

    public static Object loadKeyAndChain(String privKey, String[] certPaths) throws CertificateException, IOException, InvalidKeyException {
        Object obj = null;
        try {
            if (mKeyAndChain != null) {
                Object[] params = new Object[]{privKey, certPaths};
                obj = mKeyAndChain.invoke(null, params);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof CertificateException) {
                throw (CertificateException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof InvalidKeyException) {
                throw (InvalidKeyException)t;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return obj;
    }

    public static void main(String[] args) throws Exception {
        TrustManager.init();
    }

    static {
        TrustManager.init();
    }
}

