/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security;

import com.wm.passman.PasswordManager;
import com.wm.passman.PasswordManagerException;
import com.wm.util.JournalLogger;
import com.wm.util.ProxySettings;
import com.wm.util.security.WmSecureString;

public class OutboundPasswordStore
implements PasswordManager {
    public static final String MSG_BUNDLE = "com.wm.resources.B2BCoreMsgBundle";
    public static final String PASS_HANDLE_PREFIX = "wm.is.admin";
    private static final int MSG_MAJOR_CODE = 77;
    private static final String MSG_CODE_PREFIX = JournalLogger.getComponentId(77) + "." + String.valueOf(77) + ".";
    private PasswordManager _realPassMan = null;
    private static OutboundPasswordStore STATIC_SELF = null;

    private OutboundPasswordStore(PasswordManager inMgr) {
        this._realPassMan = inMgr;
    }

    public static final void init(PasswordManager inMgr) throws PasswordManagerException {
        if (inMgr == null) {
            JournalLogger.logCritical(77, 3);
            throw new PasswordManagerException(MSG_CODE_PREFIX + "3", MSG_BUNDLE);
        }
        STATIC_SELF = new OutboundPasswordStore(inMgr);
        ProxySettings.setPasswordManager(STATIC_SELF);
    }

    public static final PasswordManager getStore() {
        return STATIC_SELF;
    }

    public final String adminHandlePrefix() {
        return PASS_HANDLE_PREFIX;
    }

    public boolean storePassword(String inHandle, WmSecureString inPw) throws PasswordManagerException {
        return this.storePassword(inHandle, inPw, null);
    }

    public final boolean storePassword(String inHandle, WmSecureString inPw, String inCode) throws PasswordManagerException {
        return this._realPassMan.storePassword(inHandle, inPw, inCode);
    }

    public final WmSecureString retrievePassword(String inHandle) throws PasswordManagerException {
        WmSecureString returnStr = null;
        try {
            returnStr = this._realPassMan.retrievePassword(inHandle);
        }
        catch (PasswordManagerException pme) {
            OutboundPasswordStore.logExceptionMsg("retrievePassword(" + inHandle + ")", pme);
            throw pme;
        }
        return returnStr;
    }

    public final String retrieveEncryptionCode(String inHandle) throws PasswordManagerException {
        String returnStr = null;
        try {
            returnStr = this._realPassMan.retrieveEncryptionCode(inHandle);
        }
        catch (PasswordManagerException pme) {
            OutboundPasswordStore.logExceptionMsg("retrieveEncryptionCode(" + inHandle + ")", pme);
            throw pme;
        }
        return returnStr;
    }

    public final boolean removePassword(String inHandle) throws PasswordManagerException {
        boolean returnBool = false;
        try {
            returnBool = this._realPassMan.removePassword(inHandle);
        }
        catch (PasswordManagerException pme) {
            OutboundPasswordStore.logExceptionMsg("removePassword(" + inHandle + ")", pme);
            throw pme;
        }
        return returnBool;
    }

    public final boolean handleInUse(String inHandle) {
        return this._realPassMan.handleInUse(inHandle);
    }

    private static final void logExceptionMsg(String inSource, Throwable inExc) {
        Object[] msgParams = new String[]{inSource, inExc.getClass().getName(), inExc.getMessage()};
        JournalLogger.logCritical(4, 77, msgParams);
    }
}

