/*
 * Decompiled with CFR 0.152.
 */
package com.wm.security;

import com.wm.util.JournalLogger;
import java.security.Provider;
import java.security.Security;

public class Config {
    private static boolean SSLPresent;
    private static boolean Initialized;

    static final synchronized void init() {
        if (Initialized) {
            return;
        }
        try {
            Class<?> c = Class.forName("com.wm.ext.iaik.IaikSecureSocket");
            c.newInstance();
            SSLPresent = true;
        }
        catch (Throwable t) {
            SSLPresent = false;
        }
        Initialized = true;
    }

    public static final synchronized boolean isSSLPresent() {
        if (!Initialized) {
            Config.init();
        }
        return SSLPresent;
    }

    public static void setupProviders() {
        Provider provider;
        Object obj;
        Class<?> clazz;
        try {
            clazz = Class.forName("com.entrust.toolkit.security.provider.Entrust");
            obj = clazz.newInstance();
            provider = (Provider)obj;
            Security.insertProviderAt(provider, 2);
        }
        catch (Throwable t) {
            JournalLogger.logDebug(4, 6, t.getMessage());
        }
        try {
            clazz = Class.forName("iaik.security.provider.IAIK");
            obj = clazz.newInstance();
            provider = (Provider)obj;
            Security.insertProviderAt(provider, 3);
        }
        catch (Throwable t) {
            JournalLogger.logDebug(4, 6, t.getMessage());
        }
    }

    static {
        Config.init();
    }
}

