/*
 * Decompiled with CFR 0.152.
 */
package com.wm.passman;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.util.data.MemData;
import com.wm.util.data.Objects;

public class PasswordWrapper
implements IDataPortable {
    private static final String ENC_ID_KEY = "encryptorId";
    private static final String PW_KEY = "password";
    Object _pwObj;
    String _encryptorId;

    public PasswordWrapper() {
        this._pwObj = null;
        this._encryptorId = null;
    }

    public PasswordWrapper(Object inObj, String inCode) {
        this._pwObj = inObj;
        this._encryptorId = inCode;
    }

    public Object getObject() {
        return this._pwObj;
    }

    public String getEncryptionCode() {
        return this._encryptorId;
    }

    public boolean equals(Object inObj) {
        boolean rc = false;
        if (inObj instanceof PasswordWrapper) {
            PasswordWrapper inPw = (PasswordWrapper)inObj;
            String myEnc = this.getEncryptionCode();
            String otherEnc = inPw.getEncryptionCode();
            Object myObj = this.getObject();
            Object otherObj = inPw.getObject();
            if (myEnc == null && otherEnc == null) {
                rc = this.compareObjects(myObj, otherObj);
            } else if (myEnc != null && otherEnc != null && myEnc.equals(otherEnc)) {
                rc = this.compareObjects(myObj, otherObj);
            }
        }
        return rc;
    }

    private boolean compareObjects(Object inFirst, Object inSecond) {
        boolean rc = false;
        if (inFirst == null && inSecond == null) {
            rc = true;
        } else if (inFirst != null && inSecond != null) {
            rc = inFirst.equals(inSecond);
        }
        return rc;
    }

    public void dump(StringBuffer inBuff) {
        if (inBuff != null) {
            inBuff.append("Dumping password wrapper:\n");
            inBuff.append("...encryptor id: " + this._encryptorId + "\n");
            if (this._pwObj == null) {
                inBuff.append("...password object is NULL!\n");
            } else {
                inBuff.append("...password object: " + this._pwObj + "\n");
            }
        }
    }

    public IData getAsData() {
        Mem data = new Mem();
        IDataCursor cursor = data.getCursor();
        cursor.insertAfter(ENC_ID_KEY, this._encryptorId);
        cursor.insertAfter(PW_KEY, this._pwObj);
        cursor.destroy();
        return data;
    }

    public void setFromData(IData data) {
        IDataCursor cursor = data.getCursor();
        if (cursor.first(ENC_ID_KEY)) {
            this._encryptorId = (String)cursor.getValue();
        }
        if (cursor.first(PW_KEY)) {
            this._pwObj = cursor.getValue();
        }
        cursor.destroy();
    }

    class Mem
    extends MemData {
        public MemData newInstance() {
            return new Mem();
        }

        public IData create() {
            return new Mem();
        }

        public boolean equals(Object o) {
            return o instanceof IData ? Objects.dataCompare(this, (IData)o) : false;
        }
    }
}

