/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.socket.pool;

import com.wm.net.socket.ISocketFactory;
import com.wm.util.JournalLogger;
import com.wm.util.sync.LatchedSemaphore;
import com.wm.util.sync.WmMutex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SocketPoolManager
implements Runnable {
    private static final int NETSVC0027 = 27;
    private Hashtable cache = new Hashtable();
    private int maxDefaultCacheSize = 5;
    private static SocketPoolManager poolManager = null;
    private static Object sync = new Object();
    private static SocketPoolMonitor poolMonitor = null;

    public SocketPoolManager(int cacheSize) {
        this.maxDefaultCacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketPoolManager getCurrent() {
        Object object = sync;
        synchronized (object) {
            if (poolManager == null) {
                poolManager = new SocketPoolManager(-1);
                int cronInterval = SocketPoolManager.getCronInterval();
                if (poolMonitor != null) {
                    poolMonitor.interrupt();
                }
                poolMonitor = new SocketPoolMonitor("SocketPool Monitor", cronInterval, poolManager);
                poolMonitor.start();
            }
        }
        return poolManager;
    }

    private static int getCronInterval() {
        String tmp = System.getProperty("watt.server.rg.gateway.pinginterval", "60");
        int retval = 60;
        try {
            retval = Integer.parseInt(tmp);
            retval *= 1000;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retval;
    }

    public Socket getNoWait(int port) throws IOException {
        return this.get(port, -1);
    }

    public Socket get(int port) throws IOException {
        return this.get(port, 0);
    }

    private Socket get(int port, int wait) throws IOException {
        Socket s = null;
        PortToHostCache v = null;
        v = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (v != null) {
            s = v.getSocket(wait);
        }
        return s;
    }

    public Socket getNoWait(String host, int port) throws IOException {
        return this.get(host, port, -1);
    }

    public Socket get(String host, int port) throws IOException {
        return this.get(host, port, 0);
    }

    private Socket get(String host, int port, int wait) throws IOException {
        Socket s = null;
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports != null) {
            s = ports.getSocket(host, wait);
        }
        return s;
    }

    public void put(String host, int port, Socket socket) {
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports == null) {
            this.cache.put(Integer.toString(port), new PortToHostCache(host, port, socket));
            return;
        }
        ports.add(host, port, socket);
    }

    public boolean poolExists(int port) {
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        return ports != null;
    }

    public boolean poolExists(String host, int port) {
        boolean rc = false;
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports != null) {
            rc = ports.poolExists(host);
        }
        return rc;
    }

    public void setKeepAliveTimeout(String host, int port, int timeout) {
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports != null) {
            ports.setKeepAliveTimeout(host, timeout);
        }
    }

    public void addPool(String host, int port) {
        this.addPool(host, port, this.maxDefaultCacheSize, null, null);
    }

    public void addPool(String host, int port, int size) {
        this.addPool(host, port, size, null, null);
    }

    public void addPool(String host, int port, Socket socket) {
        this.addPool(host, port, -1, socket, null);
    }

    public void addPool(String host, int port, ISocketFactory factory) {
        this.addPool(host, port, -1, null, factory);
    }

    public synchronized void addPool(String host, int port, int size, Socket socket, ISocketFactory factory) {
        PortToHostCache portHostCache = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (portHostCache == null) {
            this.cache.put(Integer.toString(port), new PortToHostCache(host, port, size, socket, factory));
        } else if (!portHostCache.poolExists(host)) {
            portHostCache.add(host, port, socket);
            portHostCache.setPoolSocketFactory(host, port, factory);
        } else if (socket != null) {
            portHostCache.add(host, port, socket);
        }
    }

    public void flush(String host, int port) {
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports != null) {
            ports.flush(host);
        }
    }

    public void removePool(String host, int port) {
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports != null && ports.removePool(host) == 0) {
            this.cache.remove(Integer.toString(port));
        }
    }

    public void flush(int port) {
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports != null) {
            ports.flush();
        }
    }

    public void flush() {
        Set set = this.cache.entrySet();
        Iterator s = set.iterator();
        while (s.hasNext()) {
            ((PortToHostCache)s.next().getValue()).flush();
        }
    }

    public synchronized void shutdown() {
        this.flush();
        this.cache.clear();
    }

    public int getDefaultMaxCacheSize() {
        return this.maxDefaultCacheSize;
    }

    public void setDefaultMaxCacheSize(int maxDefaultCacheSize) {
        this.maxDefaultCacheSize = maxDefaultCacheSize;
    }

    public void setPoolCacheSize(String host, int port, int size) {
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports != null) {
            ports.setPoolCacheSize(host, size);
        } else {
            this.addPool(host, port, size);
        }
    }

    public void setPoolSocketFactory(String host, int port, ISocketFactory factory) {
        PortToHostCache ports = null;
        ports = (PortToHostCache)this.cache.get(Integer.toString(port));
        if (ports != null) {
            ports.setPoolSocketFactory(host, port, factory);
        } else {
            this.addPool(host, port, factory);
        }
    }

    public void run() {
        Set set = this.cache.entrySet();
        Iterator s = set.iterator();
        while (s.hasNext()) {
            PortToHostCache ports = (PortToHostCache)s.next().getValue();
            int waiters = ports.getWaiters();
            if (waiters > 0) {
                Object[] o = new Object[]{Integer.toString(waiters)};
                JournalLogger.logCritical(27, 64, o);
            }
            ports.removeStaleSockets();
        }
    }

    public static void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.setSoLinger(true, 0);
        }
        catch (SocketException se) {
            // empty catch block
        }
        try {
            socket.shutdownInput();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            socket.shutdownOutput();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isSocketFailure(Exception e, boolean checkExceptionClass) {
        if (checkExceptionClass && SocketPoolManager.isSocketExceptionClass(e.getClass().getName().toLowerCase())) {
            return true;
        }
        return SocketPoolManager.isSocketExceptionMessage(e.getMessage().toLowerCase());
    }

    private static boolean isSocketExceptionMessage(String exceptionMsg) {
        return exceptionMsg.indexOf("broken pipe") != -1 || exceptionMsg.indexOf("software caused connection abort") != -1 || exceptionMsg.indexOf("socket is closed") != -1 || exceptionMsg.indexOf("connection reset") != -1 || exceptionMsg.indexOf("connection closed") != -1 || exceptionMsg.indexOf("server unreachable") != -1 || exceptionMsg.indexOf("bac.0006.0023") != -1 || exceptionMsg.indexOf("connection refused") != -1;
    }

    private static boolean isSocketExceptionClass(String className) {
        return className.indexOf("java.net.connectionexception") != -1 || className.indexOf("java.net.socketexception") != -1;
    }

    static class SocketPoolMonitor
    extends Thread {
        long timeout;
        Runnable target = null;

        public SocketPoolMonitor(String name, long timeout, Runnable target) {
            this.setName(name);
            this.timeout = timeout;
            this.target = target;
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    SocketPoolMonitor.sleep(this.timeout);
                    this.target.run();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    class SocketWrapper {
        private Socket socket;
        long lastUsed = 0L;

        public SocketWrapper(Socket socket) {
            this.socket = socket;
            this.lastUsed = System.currentTimeMillis();
        }

        public Socket getSocket() {
            return this.socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean passesQuickTest(Socket socket, boolean fallBackToWriteTest) {
            boolean isValid;
            block11: {
                if (socket.isClosed() || socket.isInputShutdown() || socket.isOutputShutdown()) {
                    return false;
                }
                isValid = true;
                try {
                    InputStream inputStream = socket.getInputStream();
                    if (!inputStream.markSupported()) {
                        if (fallBackToWriteTest) {
                            return this.isBrokenSocket(socket);
                        }
                        return true;
                    }
                    if (inputStream.available() > 0) break block11;
                    int soTimeout = socket.getSoTimeout();
                    try {
                        socket.setSoTimeout(5);
                        inputStream.mark(1);
                        int byteRead = inputStream.read();
                        if (byteRead == -1) {
                            isValid = false;
                        } else {
                            inputStream.reset();
                        }
                    }
                    finally {
                        socket.setSoTimeout(soTimeout);
                    }
                }
                catch (SocketTimeoutException ste) {
                    isValid = true;
                }
                catch (IOException e) {
                    isValid = false;
                }
            }
            return isValid;
        }

        private boolean isBrokenSocket(Socket s) {
            boolean isBroken = false;
            try {
                OutputStream out = s.getOutputStream();
                int bufsize = s.getSendBufferSize();
                s.setSendBufferSize(1);
                out.write(13);
                out.write(10);
                out.flush();
                s.setSendBufferSize(bufsize);
            }
            catch (Exception e) {
                isBroken = true;
            }
            return isBroken;
        }

        public boolean sendRGPing(Socket socket) {
            boolean pinged = false;
            try {
                OutputStream out = socket.getOutputStream();
                String ping = "SAG-RG-PING";
                out.write(ping.getBytes());
                out.write(10);
                out.flush();
                pinged = true;
            }
            catch (Exception e) {
                pinged = false;
            }
            return pinged;
        }

        public boolean isValidRGSocket() {
            Socket socket = this.getSocket();
            if (socket == null) {
                return false;
            }
            boolean isValid = true;
            if (!this.passesQuickTest(socket, false)) {
                return false;
            }
            try {
                if (!this.sendRGPing(socket)) {
                    isValid = false;
                }
            }
            catch (Exception e) {
                isValid = false;
            }
            return isValid;
        }

        public boolean isStale() {
            long current = System.currentTimeMillis();
            int keepalive = 0;
            boolean isBroken = false;
            try {
                keepalive = this.socket.getSoTimeout();
                OutputStream out = this.socket.getOutputStream();
                int bufsize = this.socket.getSendBufferSize();
                this.socket.setSendBufferSize(1);
                out.write(13);
                out.write(10);
                out.flush();
                this.socket.setSendBufferSize(bufsize);
            }
            catch (Exception e) {
                isBroken = true;
            }
            int dur = (int)(current - this.lastUsed);
            return isBroken || keepalive > 0 && dur > keepalive;
        }
    }

    class SocketPool {
        private Vector socketCache;
        private int maxCacheSize;
        private LatchedSemaphore poolWaiters = new LatchedSemaphore();
        private WmMutex poolMutex = new WmMutex();
        private ISocketFactory socketFactory;
        private int keepAliveTimeout = 20000;
        private String host;
        private int port;

        public SocketPool(String host, int port, int maxCacheSize, Socket socket) {
            this.init(host, port, maxCacheSize, socket, null);
        }

        public SocketPool(String host, int port, int maxCacheSize, Socket socket, ISocketFactory factory) {
            this.init(host, port, maxCacheSize, socket, factory);
        }

        private void init(String host, int port, int maxCacheSize, Socket socket, ISocketFactory factory) {
            this.host = host;
            this.port = port;
            this.socketCache = new Vector();
            this.maxCacheSize = maxCacheSize;
            this.socketFactory = factory;
            if (socket != null) {
                this.socketCache.addElement(new SocketWrapper(socket));
            }
            this.poolWaiters.semReset();
        }

        public void setKeepAliveTimeout(int timeout) {
            this.keepAliveTimeout = timeout;
        }

        public void setPoolSocketFactory(ISocketFactory factory) {
            if (this.socketFactory == null) {
                this.socketFactory = factory;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket get(int wait) throws IOException {
            Socket s = null;
            SocketWrapper sw = null;
            try {
                this.lock();
                while (this.socketCache.size() > 0) {
                    sw = (SocketWrapper)this.socketCache.lastElement();
                    this.remove(this.socketCache.size() - 1);
                    s = sw.getSocket();
                    if (sw.isValidRGSocket()) break;
                    SocketPoolManager.closeSocket(sw.getSocket());
                    s = null;
                }
                if (s == null) {
                    if (this.socketFactory != null) {
                        String[] key = this.host.split(":");
                        s = this.socketFactory.createSocket(key[0], this.port);
                        s.setTcpNoDelay(true);
                        if (this.keepAliveTimeout >= 0) {
                            s.setSoTimeout(this.keepAliveTimeout);
                        } else {
                            s.setSoTimeout(0);
                        }
                    } else if (wait >= 0) {
                        try {
                            this.poolWaiters.semWaitReset(wait);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            finally {
                this.unlock();
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Socket socket) {
            int idx = -1;
            try {
                this.lock();
                idx = this.findSocket(socket);
                if (idx > -1) {
                    this.remove(idx);
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int findSocket(Socket socket) {
            int idx = -1;
            int size = 0;
            try {
                this.lock();
                size = this.socketCache.size();
                for (int i = 0; i < size; ++i) {
                    SocketWrapper sw = (SocketWrapper)this.socketCache.elementAt(i);
                    if (sw.getSocket() != socket) continue;
                    int n = i;
                    return n;
                }
            }
            finally {
                this.unlock();
            }
            return idx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(int index) {
            try {
                this.lock();
                if (index >= 0 && index < this.socketCache.size()) {
                    this.socketCache.removeElementAt(index);
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean put(Socket socket) {
            boolean added = false;
            Socket s = null;
            int size = 0;
            try {
                this.lock();
                size = this.socketCache.size();
                if (this.maxCacheSize > 0 && size >= this.maxCacheSize) {
                    SocketWrapper sw = (SocketWrapper)this.socketCache.elementAt(0);
                    s = sw.getSocket();
                    this.remove(0);
                    try {
                        SocketPoolManager.closeSocket(s);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                added = true;
                this.socketCache.addElement(new SocketWrapper(socket));
                this.poolWaiters.semPost();
            }
            finally {
                this.unlock();
            }
            return added;
        }

        public int size() {
            return this.socketCache.size();
        }

        public void setMaxCacheSize(int max) {
            this.maxCacheSize = max;
        }

        public int getMaxCacheSize() {
            return this.maxCacheSize;
        }

        public boolean hasSocketFactory() {
            return this.socketFactory != null;
        }

        public void flush() {
            int size = this.socketCache.size();
            for (int i = 0; i < size; ++i) {
                try {
                    SocketPoolManager.closeSocket(((SocketWrapper)this.socketCache.elementAt(i)).getSocket());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.socketCache.removeAllElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeStaleSockets() {
            int size = 0;
            try {
                this.lock();
                size = this.socketCache.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        if (((SocketWrapper)this.socketCache.elementAt(i)).isValidRGSocket()) continue;
                        SocketWrapper sw = (SocketWrapper)this.socketCache.elementAt(i);
                        this.remove(i);
                        SocketPoolManager.closeSocket(sw.getSocket());
                        --i;
                        --size;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.unlock();
            }
        }

        public boolean isAtCapacity() {
            return this.size() >= this.maxCacheSize;
        }

        void lock() {
            this.poolMutex.lock();
        }

        void unlock() {
            this.poolMutex.unlock();
        }
    }

    class PortToHostCache {
        private Hashtable hosts = new Hashtable();
        private LatchedSemaphore portLatch = new LatchedSemaphore();
        private WmMutex mutex = new WmMutex();
        private int portWaiters = 0;

        public PortToHostCache(String host, int port, Socket socket) {
            this.hosts.put(host, new SocketPool(host, port, SocketPoolManager.this.maxDefaultCacheSize, socket));
            this.portLatch.semReset();
        }

        public PortToHostCache(String host, int port, int size, Socket socket, ISocketFactory factory) {
            int sz = size;
            if (sz < 1) {
                sz = SocketPoolManager.this.maxDefaultCacheSize;
            }
            this.hosts.put(host, new SocketPool(host, port, sz, socket, factory));
        }

        public void setPoolSocketFactory(String host, int port, ISocketFactory factory) {
            SocketPool pool = (SocketPool)this.hosts.get(host);
            if (pool != null) {
                pool.setPoolSocketFactory(factory);
            }
        }

        public boolean poolExists(String host) {
            return this.hosts.get(host) != null;
        }

        public void setKeepAliveTimeout(String host, int timeout) {
            SocketPool pool = (SocketPool)this.hosts.get(host);
            if (pool != null) {
                pool.setKeepAliveTimeout(timeout);
            }
        }

        public void setPoolCacheSize(String host, int size) {
            SocketPool pool = (SocketPool)this.hosts.get(host);
            if (pool != null) {
                pool.setMaxCacheSize(size);
            }
        }

        public int size() {
            return this.hosts.size();
        }

        public int removePool(String host) {
            SocketPool pool = (SocketPool)this.hosts.get(host);
            if (pool != null) {
                pool.flush();
                this.hosts.remove(host);
            }
            return this.hosts.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String host, int port, Socket socket) {
            try {
                this.lock();
                SocketPool pool = (SocketPool)this.hosts.get(host);
                if (pool != null) {
                    pool.put(socket);
                } else {
                    this.hosts.put(host, new SocketPool(host, port, SocketPoolManager.this.maxDefaultCacheSize, socket));
                }
                this.portLatch.semPost();
            }
            finally {
                this.unlock();
            }
        }

        public void flush(String host) {
            SocketPool pool = (SocketPool)this.hosts.get(host);
            if (pool != null) {
                pool.flush();
            }
        }

        public void flush() {
            Set set = this.hosts.entrySet();
            Iterator s = set.iterator();
            while (s.hasNext()) {
                ((SocketPool)s.next().getValue()).flush();
            }
        }

        public void removeStaleSockets() {
            Set set = this.hosts.entrySet();
            Iterator s = set.iterator();
            while (s.hasNext()) {
                SocketPool p = (SocketPool)s.next().getValue();
                p.removeStaleSockets();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket getSocket(int wait) throws IOException {
            Socket s;
            block12: {
                s = null;
                SocketPool sp = null;
                SocketPool selectedPool = null;
                Set set = null;
                Iterator ps = null;
                int leastused = -1;
                try {
                    this.lock();
                    while (true) {
                        set = this.hosts.entrySet();
                        ps = set.iterator();
                        while (ps.hasNext()) {
                            sp = (SocketPool)ps.next().getValue();
                            sp.lock();
                            int size = sp.size();
                            if (size > 0 && size > leastused) {
                                if (selectedPool != null) {
                                    selectedPool.unlock();
                                }
                                leastused = size;
                                selectedPool = sp;
                                selectedPool.lock();
                            }
                            sp.unlock();
                        }
                        if (selectedPool != null) break;
                        if (wait == 0) {
                            try {
                                ++this.portWaiters;
                                this.unlock();
                                this.portLatch.semWaitReset();
                                this.lock();
                                --this.portWaiters;
                            }
                            catch (Exception e) {}
                            continue;
                        }
                        break block12;
                        break;
                    }
                    s = selectedPool.get(0);
                }
                finally {
                    if (this.locked()) {
                        this.unlock();
                    }
                    if (selectedPool != null) {
                        selectedPool.unlock();
                    }
                }
            }
            return s;
        }

        public Socket getSocket(String host, int wait) throws IOException {
            Socket s = null;
            SocketPool pool = (SocketPool)this.hosts.get(host);
            if (pool != null) {
                s = pool.get(wait);
            }
            return s;
        }

        public int getWaiters() {
            return this.portWaiters;
        }

        private void lock() {
            this.mutex.lock();
        }

        private void unlock() {
            this.mutex.unlock();
        }

        private boolean locked() {
            return this.mutex.isAcquired();
        }
    }
}

