/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.socket;

import com.wm.net.socket.ISocketFactory;
import com.wm.util.Values;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public class TCPSocketFactory
implements ISocketFactory {
    private SocketFactory socketFactory = SocketFactory.getDefault();
    private ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
    private Values context;

    public TCPSocketFactory(Values context) {
        this.context = context;
    }

    public Socket createSocket(InetAddress hostAddress, int port, Values context) throws IOException {
        return this.socketFactory.createSocket(hostAddress, port);
    }

    public Socket createSocket(String host, int port, Values context) throws IOException {
        if (this.context == null) {
            this.context = context;
        }
        return this.socketFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    public Socket createSocket(InetAddress localAddress, int localPort, InetAddress remoteAddress, int remotePort, Values context) throws IOException {
        return this.socketFactory.createSocket(remoteAddress, remotePort, localAddress, localPort);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress address, Values context) throws IOException {
        if (address != null) {
            return this.serverSocketFactory.createServerSocket(port, backlog, address);
        }
        return this.serverSocketFactory.createServerSocket(port, backlog);
    }

    public ServerSocket createServerSocket(int port, int backlog, Values context) throws IOException {
        return this.serverSocketFactory.createServerSocket(port, backlog);
    }

    public String getProtocol() {
        return "tcp";
    }

    public Values getProperties(Values props) {
        return props;
    }

    public void setAutoHandshake(boolean flag) {
    }
}

