/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.socket;

import com.wm.ext.iaik.IaikSecureSocket;
import com.wm.net.socket.ISocketFactory;
import com.wm.net.socket.TCPSocketFactory;
import com.wm.util.Values;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;

public class SocketFactories {
    public static synchronized ISocketFactory getFactory(String protocol, Values context) throws IOException {
        ISocketFactory fac = null;
        fac = SocketFactories.convertProtocol(protocol).equals("tcp") ? new TCPSocketFactory(context) : new IaikSecureSocket(context);
        return fac;
    }

    public static Socket createSocket(URL url, Values context) throws IOException {
        ISocketFactory factory = SocketFactories.getFactory(url.getProtocol(), context);
        InetAddress inetAddress = InetAddress.getByName(url.getHost());
        if (inetAddress == null) {
            throw new UnknownHostException(url.toString());
        }
        return factory.createSocket(inetAddress, url.getPort(), context);
    }

    public static Socket createSocket(URL url) throws IOException {
        return SocketFactories.createSocket(url, new Values());
    }

    public static Socket createSocket(URL remote, URL local, Values context) throws IOException {
        ISocketFactory factory = SocketFactories.getFactory(SocketFactories.convertProtocol(remote.getProtocol()), context);
        InetAddress inetAddress = InetAddress.getByName(remote.getHost());
        if (inetAddress == null) {
            throw new UnknownHostException(remote.toString());
        }
        if (local == null || local.getHost() == null) {
            return factory.createSocket(inetAddress, remote.getPort(), context);
        }
        int localPort = local.getPort();
        return factory.createSocket(InetAddress.getByName(local.getHost()), localPort == -1 ? 0 : localPort, inetAddress, remote.getPort(), context);
    }

    public static Socket createSocket(URL remote, URL local) throws IOException {
        return SocketFactories.createSocket(remote, local, new Values());
    }

    public static ServerSocket createServerSocket(URL url, int backlog, Values context) throws IOException {
        return SocketFactories.createServerSocket(url, backlog, context, null);
    }

    public static ServerSocket createServerSocket(URL url, int backlog, Values context, InetAddress bindaddr) throws IOException {
        ISocketFactory factory = SocketFactories.getFactory(SocketFactories.convertProtocol(url.getProtocol()), context);
        if (factory == null) {
            throw new RuntimeException("socket factory is not available for protocol - " + url.getProtocol());
        }
        InetAddress address = null;
        address = bindaddr == null ? InetAddress.getByName(url.getHost()) : bindaddr;
        return factory.createServerSocket(url.getPort(), backlog, address, context);
    }

    public static String convertProtocol(String protocol) {
        String p = "tcp";
        if (protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("ftps")) {
            p = "ssl";
        }
        return p;
    }
}

