/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.mime;

import com.wm.data.DataSharedCursorEmulator;
import com.wm.data.HashCursor;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.data.IDataUtil;
import com.wm.data.IndexCursor;
import com.wm.data.TreeCursor;
import com.wm.net.mime.MimeDataException;
import com.wm.net.mime.MimePartDataCursor;
import com.wm.net.mime.MimePartDataElement;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.EncUtil;
import com.wm.util.EncodingNames;
import com.wm.util.List;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class MimePartData
implements IData,
Serializable {
    static final long serialVersionUID = 932528005360284573L;
    final int version = 1;
    MimePartDataElement first;
    MimePartDataElement last;
    int size;
    transient List oldCursors = new List();
    private transient boolean recurse_flag = false;
    public static final String HEADERS = "headers";
    public static final String CONTENT = "content";
    public static final String SMIME = "smime";
    String content_type = "text/plain";
    String encoding = "7bit";

    public IDataCursor getCursor() {
        return this.getCursor(null);
    }

    public IDataIndexCursor getIndexCursor() {
        return IndexCursor.create(this.getCursor());
    }

    public IDataTreeCursor getTreeCursor() {
        return TreeCursor.create(this.getCursor());
    }

    public IDataHashCursor getHashCursor() {
        return HashCursor.create(this.getCursor());
    }

    public IDataSharedCursor getSharedCursor() {
        return DataSharedCursorEmulator.create(this.getCursor());
    }

    private MimePartDataCursor getCursor(MimePartDataElement item) {
        MimePartDataCursor ret = null;
        if (this.oldCursors != null && this.oldCursors.size() > 0) {
            ret = (MimePartDataCursor)this.oldCursors.removeLastElement();
        }
        if (ret == null) {
            ret = new MimePartDataCursor(item, this);
        }
        ret.init(item, this);
        return ret;
    }

    private Object get(String key) {
        IDataHashCursor idhc = this.getHashCursor();
        if (idhc.first(key)) {
            Object value = idhc.getValue();
            idhc.destroy();
            return value;
        }
        idhc.destroy();
        return null;
    }

    private void set(String key, Object value) {
        IDataHashCursor idhc = this.getHashCursor();
        if (idhc.first(key)) {
            idhc.setValue(value);
        } else {
            idhc.insertAfter(key, value);
        }
    }

    public IData getHeaders() {
        return (IData)this.get(HEADERS);
    }

    public Object getContent() throws MimeDataException {
        try {
            Object content = this.get(CONTENT);
            if (content instanceof ByteArrayInputStream) {
                ByteArrayInputStream bs = (ByteArrayInputStream)content;
                ByteArrayInputStream bis = MimePartData.copyStream(bs);
                return bis;
            }
            return content;
        }
        catch (IOException ioe) {
            throw new MimeDataException(ioe.getMessage());
        }
    }

    private static ByteArrayInputStream copyStream(InputStream input) throws IOException {
        int bytesread;
        if (input.markSupported()) {
            input.mark(0);
        }
        ByteOutputBuffer out = new ByteOutputBuffer();
        byte[] buffer = new byte[32768];
        while ((bytesread = input.read(buffer)) != -1) {
            out.write(buffer, 0, bytesread);
        }
        ByteArrayInputStream output = new ByteArrayInputStream(out.toByteArray());
        out = null;
        buffer = null;
        if (input.markSupported()) {
            try {
                input.reset();
            }
            catch (Exception ioe) {
                // empty catch block
            }
        }
        return output;
    }

    public void setHeaders(IData headers) {
        IData dstHdr = IDataFactory.create();
        IDataUtil.copy(headers, dstHdr);
        this.set(HEADERS, dstHdr);
        IDataCursor idc = headers.getCursor();
        while (idc.next()) {
            if (idc.getKey().equalsIgnoreCase("content-type")) {
                this.content_type = (String)idc.getValue();
            }
            if (!idc.getKey().equalsIgnoreCase("content-transfer-encoding")) continue;
            this.encoding = (String)idc.getValue();
        }
    }

    public void setContent(Object content) throws MimeDataException {
        if (content == null) {
            return;
        }
        try {
            if (content instanceof InputStream) {
                InputStream in = (InputStream)content;
                ByteArrayInputStream contentcopy = MimePartData.copyStream(in);
                this.set(CONTENT, contentcopy);
            } else if (content instanceof String) {
                String strContent = (String)content;
                ByteArrayInputStream bis = new ByteArrayInputStream(EncUtil.getNetBytes(strContent));
                this.set(CONTENT, bis);
            } else {
                this.set(CONTENT, content);
            }
        }
        catch (IOException ioe) {
            throw new MimeDataException(ioe.getMessage());
        }
    }

    public void setContent(InputStream in) throws MimeDataException {
        try {
            ByteArrayInputStream content = MimePartData.copyStream(in);
            this.set(CONTENT, content);
        }
        catch (IOException ioe) {
            throw new MimeDataException(ioe.getMessage());
        }
    }

    public void setContent(String content) {
        if (content == null) {
            return;
        }
        ByteArrayInputStream bis = null;
        try {
            int ind = 0;
            ind = this.content_type.indexOf("charset=");
            if (ind > 0) {
                String _charset = this.content_type.substring(ind + 8).trim();
                String charset = EncodingNames.getIANAName(_charset);
                bis = new ByteArrayInputStream(content.getBytes(charset));
            } else {
                bis = new ByteArrayInputStream(EncUtil.getNetBytes(content));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            bis = new ByteArrayInputStream(EncUtil.getNetBytes(content));
        }
        this.set(CONTENT, bis);
    }

    public void setSMime(boolean value) {
        if (value) {
            this.set(SMIME, "true");
        } else {
            this.set(SMIME, "false");
        }
    }

    public boolean isSMime() {
        String value = (String)this.get(SMIME);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static MimePartData create() {
        return new MimePartData();
    }

    public MimePartData copy() {
        MimePartData copy = new MimePartData();
        MimePartDataElement e = this.first;
        while (e != null) {
            MimePartDataElement e1 = new MimePartDataElement(copy, e.key, e.value);
            e1.addToEnd();
            e = e.next;
        }
        return copy;
    }

    public String toString() {
        if (this.recurse_flag) {
            return " >>> IData object recursed <<< ";
        }
        this.recurse_flag = true;
        MimePartDataElement de = this.first;
        StringBuffer sb = new StringBuffer();
        sb.append(">>>MimePartData:");
        while (de != null) {
            sb.append(de.key);
            sb.append("=");
            sb.append(de.value);
            de = de.next;
            if (de == null) break;
            sb.append(",");
        }
        sb.append("<<<");
        this.recurse_flag = false;
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            MimePartData mpd = new MimePartData();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream("textfile"));
            ByteArrayInputStream bis = MimePartData.copyStream(in);
            mpd.setContent(bis);
            InputStream content = (InputStream)mpd.getContent();
        }
        catch (Exception mde) {
            System.err.println("Caught exception: " + mde.getMessage());
        }
    }
}

