/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.mime;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataUtil;
import com.wm.net.mime.MimeData;
import com.wm.net.mime.MimeDataException;
import com.wm.net.mime.MimeMultipart_WM;
import com.wm.net.mime.MimePartData;
import com.wm.net.mime.resources.MimeExceptionBundle;
import com.wm.util.EncUtil;
import iaik.security.smime.EncryptedContent;
import iaik.security.smime.SignedContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public class MimeDataUtil {
    public static final String CTYPE_HDR = "content-type";
    public static final String CID_HDR = "content-id";
    public static final String ENCODING_HDR = "content-transfer-encoding";
    public static final String CDISP_HDR = "content-disposition";
    public static final String CDESCRIPTION = "content-description";

    public static Object createMimeMessage(InputStream is, String subType, IData headers) throws MimeDataException {
        MimeData md;
        if (is != null) {
            md = new MimeData(is);
        } else {
            md = new MimeData();
            md.setSubType(subType, headers);
            MimeDataUtil.addMimeHeader(md, headers);
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMimeHeader(Object o, IData headers) throws MimeDataException {
        if (headers == null) {
            return;
        }
        MimeDataUtil.validateObject(o);
        IData hdrData = MimeDataUtil.getMimeHeader(o);
        IDataCursor idcT = hdrData.getCursor();
        idcT.last();
        IDataCursor idcS = headers.getCursor();
        try {
            while (idcS.hasMoreData()) {
                idcS.next();
                String key = idcS.getKey();
                String value = (String)idcS.getValue();
                idcT.insertAfter(key, value);
            }
        }
        finally {
            idcS.destroy();
            idcT.destroy();
        }
    }

    public static void addBodyPart(MimeData md, Object o, String contenttype, String encoding, String description, boolean multipart, boolean replace, IData hdr, boolean isEnvStream) throws MimeDataException {
        if (isEnvStream) {
            contenttype = null;
            if (hdr != null) {
                IDataHashCursor idhc = hdr.getHashCursor();
                while (idhc.next()) {
                    if (!idhc.getKey().equalsIgnoreCase(CTYPE_HDR)) continue;
                    idhc.delete();
                    idhc.destroy();
                    idhc = hdr.getHashCursor();
                }
                idhc.destroy();
            }
        } else if (contenttype == null && (contenttype = MimeDataUtil.getHeaderValue(hdr, CTYPE_HDR)) == null) {
            contenttype = "text/plain";
        }
        MimeDataUtil.addBodyPart(md, o, contenttype, encoding, description, multipart, replace, hdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBodyPart(MimeData md, Object o, String contenttype, String encoding, String description, boolean multipart, boolean replace, IData hdr) throws MimeDataException {
        block12: {
            if (o == null) {
                throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.CONTENT_TYPE_NULL_MISSING, "");
            }
            IDataHashCursor idhc = md.getHashCursor();
            idhc.last();
            try {
                if (o instanceof InputStream) {
                    try {
                        if (contenttype != null || MimeDataUtil.getHeaderValue(hdr, CTYPE_HDR) != null) {
                            MimeDataException mde = new MimeDataException("");
                            mde.setInputStream((InputStream)o);
                            throw mde;
                        }
                        InputStream is = (InputStream)o;
                        MimeData mdp = new MimeData(is);
                        idhc.insertAfter("part", mdp);
                    }
                    catch (MimeDataException mde) {
                        if (!mde.isSMime()) {
                            InputStream is = mde.getInputStream();
                            if (hdr == null) {
                                hdr = IDataFactory.create();
                            }
                            MimeDataUtil.setHeaderValue(hdr, CTYPE_HDR, contenttype);
                            MimeDataUtil.setHeaderValue(hdr, CDESCRIPTION, description);
                            MimeDataUtil.setHeaderValue(hdr, ENCODING_HDR, encoding);
                            if (MimeDataUtil.getContentType(hdr) == null) {
                                throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.INVALID_BODY_PART, "");
                            }
                            MimePartData mpd = MimePartData.create();
                            mpd.setHeaders(hdr);
                            mpd.setContent(is);
                            idhc.insertAfter("part", mpd);
                            break block12;
                        }
                        MimePartData mpd = MimePartData.create();
                        IData hdrs = mde.getHeaders();
                        mpd.setHeaders(hdrs);
                        Object content = mde.getContent();
                        mpd.setContent(content);
                        mpd.setSMime(true);
                        idhc.insertAfter("part", mpd);
                    }
                    break block12;
                }
                if (o instanceof MimeData) {
                    MimeData mdp = (MimeData)o;
                    idhc.insertAfter("part", mdp);
                    break block12;
                }
                throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.INVALID_OBJECT, "", o.getClass().getName());
            }
            finally {
                idhc.destroy();
            }
        }
    }

    private static void setHeaderValue(IData hdr, String name, String value) {
        if (value == null) {
            return;
        }
        if (hdr == null) {
            hdr = IDataFactory.create();
        }
        boolean found = false;
        IDataHashCursor idhc_hdr = hdr.getHashCursor();
        while (idhc_hdr.next()) {
            if (!idhc_hdr.getKey().equalsIgnoreCase(name)) continue;
            idhc_hdr.setValue(value);
            found = true;
        }
        if (!found) {
            idhc_hdr.last();
            idhc_hdr.insertAfter(name, value);
        }
        idhc_hdr.destroy();
    }

    public static void removeAllBodyParts(Object o) throws MimeDataException {
        MimeDataUtil.validateObject(o);
        if (o instanceof MimeData) {
            MimeData md = (MimeData)o;
            IDataHashCursor idhc = md.getHashCursor();
            while (idhc.next("part")) {
                if (idhc.getKey().equalsIgnoreCase("headers")) continue;
                idhc.delete();
                idhc.destroy();
                idhc = md.getHashCursor();
            }
            idhc.destroy();
        }
    }

    public static IData getMimeHeader(Object o) throws MimeDataException {
        IData headers = null;
        if (o instanceof MimeData) {
            MimeData md = (MimeData)o;
            IDataHashCursor idhc = md.getHashCursor();
            if (idhc.first("headers")) {
                headers = (IData)idhc.getValue();
            }
        } else if (o instanceof MimePartData) {
            MimePartData mpd = (MimePartData)o;
            headers = mpd.getHeaders();
        } else {
            if (o instanceof IData) {
                headers = (IData)o;
                return headers;
            }
            MimeDataException mde = new MimeDataException("Invalid mime object");
            throw mde;
        }
        return headers;
    }

    public static Object getBodyPartContent(Object o, int index, String cid) throws MimeDataException {
        return MimeDataUtil.getBodyPartContent(o, index, cid, true);
    }

    public static Object getBodyPartContent(Object o, int index, String cid, boolean sstream) throws MimeDataException {
        MimeDataUtil.validateObject(o);
        if (o instanceof MimePartData) {
            MimePartData mpd = (MimePartData)o;
            if (sstream && (MimeDataUtil.isEncrypted(mpd) || MimeDataUtil.isSigned(mpd) || MimeDataUtil.isCertsOnly(mpd))) {
                return MimeDataUtil.getEnvelopeStream(mpd);
            }
            return mpd.getContent();
        }
        if (o instanceof MimeData) {
            MimeData md = (MimeData)o;
            if (cid != null) {
                IDataHashCursor idhc = md.getHashCursor();
                while (idhc.next("part")) {
                    Object part = idhc.getValue();
                    IData hdrs = MimeDataUtil.getMimeHeader(part);
                    String current_cid = MimeDataUtil.getHeaderValue(hdrs, CID_HDR);
                    if (current_cid == null || !cid.equalsIgnoreCase(current_cid)) continue;
                    if (part instanceof MimePartData) {
                        if (sstream && (MimeDataUtil.isEncrypted(part) || MimeDataUtil.isSigned(part) || MimeDataUtil.isCertsOnly(part))) {
                            return MimeDataUtil.getEnvelopeStream((MimePartData)part);
                        }
                        return MimeDataUtil.getBodyPartContent(part, -1, null, false);
                    }
                    return part;
                }
            } else {
                if (index < 0) {
                    index = 0;
                }
                IDataIndexCursor idxc = md.getIndexCursor();
                if (MimeDataUtil.hasHeaders(md)) {
                    ++index;
                }
                if (MimeDataUtil.seek(idxc, index)) {
                    Object part = idxc.getValue();
                    if (part instanceof MimePartData) {
                        if (sstream && (MimeDataUtil.isEncrypted(part) || MimeDataUtil.isSigned(part) || MimeDataUtil.isCertsOnly(part))) {
                            return MimeDataUtil.getEnvelopeStream((MimePartData)part);
                        }
                        return MimeDataUtil.getBodyPartContent(part, -1, null, false);
                    }
                    return part;
                }
            }
        } else {
            MimeDataException mde = new MimeDataException("Invalid mime object");
            throw mde;
        }
        return null;
    }

    private static boolean isBodyPartSMime(Object o, int index, String cid) throws MimeDataException {
        MimeDataUtil.validateObject(o);
        if (o instanceof MimePartData) {
            MimePartData mpd = (MimePartData)o;
            return mpd.isSMime();
        }
        if (o instanceof MimeData) {
            MimeData md = (MimeData)o;
            if (cid != null) {
                IDataHashCursor idhc = md.getHashCursor();
                while (idhc.next("part")) {
                    Object part = idhc.getValue();
                    IData hdrs = MimeDataUtil.getMimeHeader(part);
                    String current_cid = MimeDataUtil.getHeaderValue(hdrs, CID_HDR);
                    if (current_cid == null || !cid.equalsIgnoreCase(current_cid)) continue;
                    if (part instanceof MimePartData) {
                        MimePartData mpd = (MimePartData)part;
                        return mpd.isSMime();
                    }
                    return false;
                }
            } else {
                if (index < 0) {
                    index = 0;
                }
                IDataIndexCursor idxc = md.getIndexCursor();
                if (MimeDataUtil.hasHeaders(md)) {
                    ++index;
                }
                if (MimeDataUtil.seek(idxc, index)) {
                    Object part = idxc.getValue();
                    if (part instanceof MimePartData) {
                        MimePartData mpd = (MimePartData)part;
                        return mpd.isSMime();
                    }
                    return false;
                }
            }
        } else {
            MimeDataException mde = new MimeDataException("Invalid mime object");
            throw mde;
        }
        return false;
    }

    private static boolean hasHeaders(MimeData md) {
        IDataHashCursor idhc = md.getHashCursor();
        boolean value = idhc.first("headers");
        idhc.destroy();
        return value;
    }

    public static int getNumParts(Object o) throws MimeDataException {
        MimeDataUtil.validateObject(o);
        if (o instanceof MimePartData) {
            return 1;
        }
        if (o instanceof MimeData) {
            MimeData md = (MimeData)o;
            IDataHashCursor idhc = md.getHashCursor();
            int count = 0;
            while (idhc.next()) {
                if (idhc.getKey().equalsIgnoreCase("headers")) continue;
                ++count;
            }
            idhc.destroy();
            return count;
        }
        return 0;
    }

    public static IData getBodyPartHeader(Object o, int index, String cid) throws MimeDataException {
        return MimeDataUtil.getBodyPartHeader(o, index, cid, false);
    }

    public static IData getBodyPartHeader(Object o, int index, String cid, boolean decodeHdrs) throws MimeDataException {
        IData rtn = null;
        MimeDataUtil.validateObject(o);
        if (o instanceof MimePartData) {
            MimePartData mpd = (MimePartData)o;
            rtn = mpd.getHeaders();
        } else if (o instanceof MimeData) {
            MimeData md = (MimeData)o;
            if (cid != null) {
                IDataHashCursor idhc = md.getHashCursor();
                while (idhc.next("part")) {
                    Object part = idhc.getValue();
                    IData hdrs = MimeDataUtil.getMimeHeader(part);
                    String current_cid = MimeDataUtil.getHeaderValue(hdrs, CID_HDR);
                    if (current_cid == null || !cid.equalsIgnoreCase(current_cid)) continue;
                    rtn = hdrs;
                }
            } else {
                if (index < 0) {
                    index = 0;
                }
                IDataIndexCursor idxc = md.getIndexCursor();
                if (MimeDataUtil.hasHeaders(md)) {
                    ++index;
                }
                if (MimeDataUtil.seek(idxc, index)) {
                    Object part = idxc.getValue();
                    rtn = MimeDataUtil.getMimeHeader(part);
                }
            }
        } else {
            MimeDataException mde = new MimeDataException("Invalid mime object");
            throw mde;
        }
        if (rtn != null && decodeHdrs) {
            return MimeDataUtil.decodeHeaders(rtn);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IData decodeHeaders(IData src) {
        if (src == null) {
            return null;
        }
        IData decodedHdrs = IDataUtil.clone(src);
        IDataCursor idc = decodedHdrs.getCursor();
        try {
            while (idc.hasMoreData()) {
                idc.next();
                String value = (String)idc.getValue();
                String key = idc.getKey();
                value = MimeDataUtil.decodeHeader(value);
                idc.setValue(value);
            }
            IData iData = decodedHdrs;
            return iData;
        }
        finally {
            idc.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHeaderValue(IData hdrs, String name) {
        if (hdrs == null) {
            return null;
        }
        IDataCursor idc = hdrs.getCursor();
        try {
            while (idc.hasMoreData()) {
                idc.next();
                String key = idc.getKey().toLowerCase();
                if (!key.equalsIgnoreCase(name)) continue;
                String string = (String)idc.getValue();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            idc.destroy();
        }
    }

    public static String getContentType(IData hdrs) throws MimeDataException {
        String content_type = MimeDataUtil.getHeaderValue(hdrs, CTYPE_HDR);
        try {
            if (content_type != null) {
                ContentType ct = new ContentType(content_type);
                return ct.getBaseType();
            }
            return new String("text/plain");
        }
        catch (ParseException pe) {
            MimeDataException mde = new MimeDataException("Invalid content-type header " + content_type);
            throw mde;
        }
    }

    private static ContentType getContentTypeAsContentType(IData hdrs) throws MimeDataException {
        String content_type = MimeDataUtil.getHeaderValue(hdrs, CTYPE_HDR);
        try {
            if (content_type != null) {
                ContentType ct = new ContentType(content_type);
                return ct;
            }
            return new ContentType("text/plain");
        }
        catch (ParseException pe) {
            MimeDataException mde = new MimeDataException("Invalid content-type header " + content_type);
            throw mde;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentType getContentTypeAsContentType(MimeData md) throws MimeDataException {
        IDataHashCursor idhc = md.getHashCursor();
        try {
            if (idhc.first("headers")) {
                IData hdrs = (IData)idhc.getValue();
                ContentType contentType = MimeDataUtil.getContentTypeAsContentType(hdrs);
                return contentType;
            }
            ContentType contentType = null;
            return contentType;
        }
        finally {
            if (idhc != null) {
                idhc.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentType(MimeData md) throws MimeDataException {
        IDataHashCursor idhc = md.getHashCursor();
        try {
            if (idhc.first("headers")) {
                IData hdrs = (IData)idhc.getValue();
                String string = MimeDataUtil.getContentType(hdrs);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (idhc != null) {
                idhc.destroy();
            }
        }
    }

    public static String getPrimaryContentType(Object o) throws MimeDataException {
        String ctype = MimeDataUtil.getContentType(o);
        try {
            return new ContentType(ctype).getPrimaryType();
        }
        catch (ParseException pe) {
            throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.CONTENT_TYPE_NULL_MISSING, "");
        }
    }

    public static String getSubContentType(Object o) throws MimeDataException {
        String ctype = MimeDataUtil.getContentType(o);
        try {
            return new ContentType(ctype).getSubType();
        }
        catch (ParseException pe) {
            throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.CONTENT_TYPE_NULL_MISSING, "");
        }
    }

    public static String getContentType(MimePartData mpd) throws MimeDataException {
        IData hdrs = mpd.getHeaders();
        return MimeDataUtil.getContentType(hdrs);
    }

    public static String getContentType(Object o) throws MimeDataException {
        MimeDataUtil.validateObject(o);
        if (o instanceof MimePartData) {
            return MimeDataUtil.getContentType((MimePartData)o);
        }
        return MimeDataUtil.getContentType((MimeData)o);
    }

    public static InputStream getEnvelopeStream(Object o, int index, String cid) throws MimeDataException {
        return MimeDataUtil.getEnvelopeStream(o, index, cid, null);
    }

    public static InputStream getEnvelopeStream(Object o, int index, String cid, String[] ignoreList) throws MimeDataException {
        return MimeDataUtil.getEnvelopeStream(o, index, cid, ignoreList, false);
    }

    protected static boolean seek(IDataCursor idc, int index) {
        int x = 0;
        if (!idc.first()) {
            return false;
        }
        do {
            if (x == index) {
                return true;
            }
            ++x;
        } while (idc.next());
        return false;
    }

    public static InputStream getEnvelopeStream(Object o, int index, String cid, String[] ignoreList, boolean createMultipart) throws MimeDataException {
        MimeDataUtil.validateObject(o);
        if (o instanceof MimePartData) {
            MimePartData mpd = (MimePartData)o;
            return MimeDataUtil.getEnvelopeStream(mpd);
        }
        if (o instanceof MimeData) {
            MimeData md = (MimeData)o;
            if (index >= 0) {
                IDataCursor idc = md.getCursor();
                if (MimeDataUtil.hasHeaders(md)) {
                    ++index;
                }
                if (MimeDataUtil.seek(idc, index)) {
                    Object part = idc.getValue();
                    if (part instanceof MimePartData) {
                        MimePartData mpd = (MimePartData)part;
                        return MimeDataUtil.getEnvelopeStream(mpd);
                    }
                    if (part instanceof MimeData) {
                        MimeData md1 = (MimeData)part;
                        InputStream is = MimeDataUtil.getEnvelopeStream(md1);
                        return is;
                    }
                }
            } else if (cid == null) {
                return MimeDataUtil.getEnvelopeStream(md, ignoreList, createMultipart);
            }
        } else {
            MimeDataException mde = new MimeDataException("Invalid mime object");
            throw mde;
        }
        return null;
    }

    public static InputStream getEnvelopeStream(MimeData md) throws MimeDataException {
        return MimeDataUtil.getEnvelopeStream(md, null);
    }

    public static InputStream getEnvelopeStream(MimeData md, String[] ignoreList) throws MimeDataException {
        return MimeDataUtil.getEnvelopeStream(md, ignoreList, false);
    }

    public static InputStream getEnvelopeStream(MimeData md, String[] ignoreList, boolean createMultipart) throws MimeDataException {
        try {
            MimeMultipart_WM mp;
            Object o;
            Properties props = System.getProperties();
            Session sess = Session.getDefaultInstance((Properties)props, null);
            MimeMessage mmsg = new MimeMessage(sess);
            int count = MimeDataUtil.getNumParts(md);
            if (count == 1 && !createMultipart) {
                o = MimeDataUtil.getBodyPartContent(md, 0, null, false);
                if (o instanceof MimeData) {
                    InputStream in = MimeDataUtil.getEnvelopeStream((MimeData)o);
                    MimeData mdtmp = (MimeData)o;
                    String subtype = mdtmp.getSubType();
                    MimeMultipart_WM mp2 = subtype != null ? new MimeMultipart_WM(subtype) : new MimeMultipart_WM();
                    MimeBodyPart mimeData = new MimeBodyPart(in);
                    mp2.addBodyPart((BodyPart)mimeData);
                    mmsg.setContent((Multipart)mp2);
                    MimeDataUtil.setHeaders(mmsg, md);
                } else {
                    IData bhdr = MimeDataUtil.getBodyPartHeader(md, 0, null);
                    String ctype = MimeDataUtil.getContentType(bhdr);
                    if (ctype == null) {
                        ctype = "text/plain";
                    }
                    if (MimeDataUtil.isBodyPartSMime(md, 0, null)) {
                        mmsg.setContent(o, "text/smime");
                    } else {
                        mmsg.setContent(o, ctype);
                    }
                    String encoding = MimeDataUtil.getHeaderValue(bhdr, ENCODING_HDR);
                    if (encoding == null) {
                        encoding = "7bit";
                    }
                    mmsg.setHeader(ENCODING_HDR, encoding);
                    MimeDataUtil.setHeaders(mmsg, md);
                    if (bhdr != null) {
                        IDataHashCursor idhc = bhdr.getHashCursor();
                        while (idhc.next()) {
                            String name = idhc.getKey();
                            String value = (String)idhc.getValue();
                            if (name == null || value == null) continue;
                            mmsg.setHeader(name, value);
                        }
                        idhc.destroy();
                    }
                }
            } else {
                ParameterList pl = md.getParameterList();
                mp = md.getSubType() != null ? new MimeMultipart_WM(md.getSubType(), pl) : new MimeMultipart_WM();
                for (int i = 0; i < count; ++i) {
                    InputStream is = MimeDataUtil.getEnvelopeStream((Object)md, i, null);
                    MimeBodyPart mbp = new MimeBodyPart(is);
                    mp.addBodyPart((BodyPart)mbp);
                }
                mmsg.setContent((Multipart)mp);
                MimeDataUtil.setHeaders(mmsg, md, true);
            }
            mmsg.saveChanges();
            mmsg.removeHeader("Mime-Version");
            mmsg.setHeader("MIME-Version", "1.0");
            if (ignoreList != null && (o = mmsg.getContent()) instanceof MimeMultipart) {
                mp = (MimeMultipart)o;
                for (int i = 0; i < mp.getCount(); ++i) {
                    MimeBodyPart mbp = (MimeBodyPart)mp.getBodyPart(i);
                    for (int j = 0; j < ignoreList.length; ++j) {
                        mbp.removeHeader(ignoreList[j]);
                    }
                }
            }
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            mmsg.writeTo((OutputStream)ba, ignoreList);
            return new ByteArrayInputStream(ba.toByteArray());
        }
        catch (IOException ioe) {
            throw new MimeDataException(ioe.getMessage());
        }
        catch (MessagingException me) {
            String err = me.getMessage();
            if (err == null) {
                err = "Invalid mime object passed to getEnvelopeStream";
            }
            throw new MimeDataException(err);
        }
    }

    private static void setHeaders(MimeMessage msg, Object md) throws MimeDataException, MessagingException {
        MimeDataUtil.setHeaders(msg, md, false);
    }

    private static void setHeaders(MimeMessage msg, Object md, boolean isMultiPart) throws MimeDataException, MessagingException {
        IData hdrs = MimeDataUtil.getMimeHeader(md);
        if (hdrs != null) {
            IDataHashCursor idhc = hdrs.getHashCursor();
            while (idhc.next()) {
                String name = idhc.getKey();
                String value = (String)idhc.getValue();
                if (name == null || value == null || isMultiPart && !MimeDataUtil.isMultipartHeaderValid(name, value)) continue;
                msg.setHeader(name, value);
            }
            idhc.destroy();
        }
    }

    private static boolean isMultipartHeaderValid(String name, String value) {
        boolean ret = true;
        if (name == null) {
            ret = false;
        } else {
            if (name.equalsIgnoreCase(CTYPE_HDR)) {
                return false;
            }
            if (name.equalsIgnoreCase(ENCODING_HDR)) {
                if (value == null) {
                    ret = false;
                } else {
                    String enc = value.trim().toLowerCase();
                    if (!MimeDataUtil.isValidMultiPartEncoding(enc)) {
                        ret = false;
                    }
                }
            }
        }
        return ret;
    }

    private static boolean isValidMultiPartEncoding(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).equalsIgnoreCase("7bit") || s.equalsIgnoreCase("8bit") || s.equalsIgnoreCase("binary")) {
            return true;
        }
        HeaderTokenizer h = new HeaderTokenizer(s, "()<>@,;:\\\"\t []/?=");
        try {
            HeaderTokenizer.Token tk;
            int tkType;
            while ((tkType = (tk = h.next()).getType()) != -4) {
                if (tkType != -1) continue;
                s = tk.getValue();
                break;
            }
            return s.equalsIgnoreCase("7bit") || s.equalsIgnoreCase("8bit") || s.equalsIgnoreCase("binary");
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static InputStream getEnvelopeStream(MimePartData mpd) throws MimeDataException {
        try {
            MimeBodyPart mbp = new MimeBodyPart(new InternetHeaders(), null);
            IData hdrs = mpd.getHeaders();
            String ctype = MimeDataUtil.getContentType(hdrs);
            if (ctype == null) {
                throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.CONTENT_TYPE_NULL_MISSING, "");
            }
            Object content = mpd.getContent();
            IDataHashCursor idhc = hdrs.getHashCursor();
            if (mpd.isSMime()) {
                mbp.setContent(content, "text/smime");
            } else {
                mbp.setContent(content, ctype);
            }
            while (idhc.next()) {
                mbp.setHeader(idhc.getKey(), (String)idhc.getValue());
            }
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            mbp.writeTo((OutputStream)ba);
            ByteArrayInputStream is = new ByteArrayInputStream(ba.toByteArray());
            return is;
        }
        catch (IOException ioe) {
            throw new MimeDataException(ioe.getMessage());
        }
        catch (MessagingException me) {
            throw new MimeDataException(me.getMessage());
        }
    }

    public static boolean isEncrypted(Object mimedata) throws MimeDataException {
        block12: {
            IData headers = MimeDataUtil.getMimeHeader(mimedata);
            String content_type = MimeDataUtil.getHeaderValue(headers, CTYPE_HDR);
            try {
                if (content_type == null) {
                    return false;
                }
                ContentType ct = new ContentType(content_type);
                String primType = ct.getPrimaryType().toLowerCase();
                String subType = ct.getSubType().toLowerCase();
                String bt = ct.getBaseType();
                if (bt != null && primType.equalsIgnoreCase("application") && subType.length() > 0 && subType.lastIndexOf("pkcs7-mime") >= 0) {
                    ParameterList pl = ct.getParameterList();
                    String stype = pl.get("smime-type");
                    if (stype != null && stype.equalsIgnoreCase("enveloped-data")) {
                        return true;
                    }
                    if (stype != null) break block12;
                    try {
                        InputStream is = MimeDataUtil.getEnvelopeStream(mimedata, -1, null);
                        String ctype = MimeDataUtil.getSMimeContentType(is);
                        if (ctype != null && ctype.equalsIgnoreCase("enveloped-data")) {
                            return true;
                        }
                        break block12;
                    }
                    catch (Exception e) {}
                    break block12;
                }
                if (bt.equalsIgnoreCase("application/octet-stream")) {
                    ParameterList pl = ct.getParameterList();
                    String name = pl.get("name");
                    if (name != null && (name.endsWith("p7m") || name.endsWith("p7s") || name.endsWith("p7c"))) {
                        return true;
                    }
                    String content_disp = MimeDataUtil.getHeaderValue(headers, CDISP_HDR);
                    if (content_disp != null) {
                        HeaderTokenizer h = new HeaderTokenizer(content_disp, "()<>@,;:\\\"\t []/?=");
                        HeaderTokenizer.Token tk = h.next();
                        String rem = h.getRemainder();
                        pl = new ParameterList(rem);
                        name = pl.get("filename");
                        if (name != null && (name.endsWith("p7m") || name.endsWith("p7s") || name.endsWith("p7c"))) {
                            return true;
                        }
                    }
                }
            }
            catch (ParseException pe) {
                throw new MimeDataException(pe.getMessage());
            }
        }
        return false;
    }

    public static boolean isSigned(Object mimedata) throws MimeDataException {
        IData headers = MimeDataUtil.getMimeHeader(mimedata);
        if (headers == null) {
            return false;
        }
        String content_type = MimeDataUtil.getHeaderValue(headers, CTYPE_HDR);
        if (content_type == null) {
            return false;
        }
        try {
            ContentType ct = new ContentType(content_type);
            String bt = ct.getBaseType();
            if (bt != null && bt.equalsIgnoreCase("multipart/signed")) {
                return true;
            }
            if (bt != null && bt.equalsIgnoreCase("application/pkcs7-mime")) {
                InputStream is;
                String ctype;
                ParameterList pl = ct.getParameterList();
                String stype = pl.get("smime-type");
                if (stype != null && stype.equalsIgnoreCase("signed-data")) {
                    return true;
                }
                if (stype == null && (ctype = MimeDataUtil.getSMimeContentType(is = MimeDataUtil.getEnvelopeStream(mimedata, -1, null))) != null && ctype.equalsIgnoreCase("signed-data")) {
                    return true;
                }
            }
        }
        catch (ParseException pe) {
            throw new MimeDataException(pe.getMessage());
        }
        return false;
    }

    public static boolean isCertsOnly(Object mimedata) throws MimeDataException {
        IData headers = MimeDataUtil.getMimeHeader(mimedata);
        if (headers == null) {
            return false;
        }
        String content_type = MimeDataUtil.getHeaderValue(headers, CTYPE_HDR);
        if (content_type == null) {
            return false;
        }
        try {
            ParameterList pl;
            String stype;
            ContentType ct = new ContentType(content_type);
            String bt = ct.getBaseType();
            if (bt != null && bt.equalsIgnoreCase("application/pkcs7-mime") && (stype = (pl = ct.getParameterList()).get("smime-type")) != null && stype.equalsIgnoreCase("certs-only")) {
                return true;
            }
        }
        catch (ParseException pe) {
            throw new MimeDataException(pe.getMessage());
        }
        return false;
    }

    public static final String getSMimeContentType(Object obj) throws MimeDataException {
        MimeMessage msg;
        String contentType = null;
        if (obj == null || !(obj instanceof InputStream)) {
            throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.INVALID_OBJECT, "", obj.getClass().getName());
        }
        InputStream in_stream = (InputStream)obj;
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            msg = new MimeMessage(session, in_stream);
        }
        catch (Exception me) {
            try {
                msg = new MimeBodyPart(in_stream);
            }
            catch (Exception e) {
                throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.INPUT_DATA_BAD, "");
            }
        }
        try {
            obj = msg.getContent();
        }
        catch (Exception e) {
            throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.COULD_NOT_GET_CONTENT, "");
        }
        if (obj instanceof SignedContent) {
            SignedContent sc = (SignedContent)obj;
            contentType = sc.getSMimeType();
        } else if (obj instanceof EncryptedContent) {
            contentType = "enveloped-data";
        }
        return contentType;
    }

    private static void validateObject(Object o) throws MimeDataException {
        if (o == null) {
            throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.NULL_MIME_OBJECT, "");
        }
        if (o instanceof MimePartData || o instanceof MimeData) {
            return;
        }
        throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.INVALID_OBJECT, "", o.getClass().getName());
    }

    public static String decodeHeader(String rawvalue) {
        if (rawvalue == null) {
            return null;
        }
        if (rawvalue.indexOf("=?") == -1) {
            return rawvalue;
        }
        try {
            return EncUtil.decodeText(rawvalue);
        }
        catch (UnsupportedEncodingException ex) {
            return rawvalue;
        }
    }

    public static void dumpIData(String msg, IData idata) {
        System.err.println("");
        System.err.println(msg);
        IDataCursor idhc = idata.getCursor();
        while (idhc.hasMoreData()) {
            idhc.next();
            String key = idhc.getKey();
            String value = (String)idhc.getValue();
            System.err.println(key + " : " + value);
        }
        idhc.destroy();
    }
}

