/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.mime;

import com.sun.mail.util.ASCIIUtility;
import com.wm.data.DataSharedCursorEmulator;
import com.wm.data.HashCursor;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.data.IndexCursor;
import com.wm.data.TreeCursor;
import com.wm.net.mime.DataCursor;
import com.wm.net.mime.DataElement;
import com.wm.net.mime.MimeDataException;
import com.wm.net.mime.MimeDataUtil;
import com.wm.net.mime.MimeMultipart_WM;
import com.wm.net.mime.MimePartData;
import com.wm.net.mime.resources.MimeExceptionBundle;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.EncUtil;
import com.wm.util.List;
import iaik.security.smime.EncryptedContent;
import iaik.security.smime.SignedContent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public class MimeData
implements IData,
Serializable {
    public static final String HEADERS = "headers";
    public static final String PART = "part";
    public static final String MULTIPART = "multipart";
    static final long serialVersionUID = 932528005360284573L;
    final int version = 1;
    ContentType ctype;
    InputStream input;
    IData hdrData;
    int pIndex;
    int numParts;
    private String subType;
    private ParameterList parameterList;
    String scontenttype;
    boolean sign;
    boolean encrypted;
    DataElement first;
    DataElement last;
    int size;
    transient List oldCursors;
    private transient boolean recurse_flag;

    public MimeData() {
        this.version = 1;
        this.hdrData = null;
        this.pIndex = 0;
        this.numParts = 0;
        this.subType = null;
        this.parameterList = null;
        this.scontenttype = null;
        this.sign = false;
        this.encrypted = false;
        this.first = null;
        this.last = null;
        this.oldCursors = new List();
        this.recurse_flag = false;
        IData headers = IDataFactory.create();
        this.addElement(HEADERS, headers);
    }

    private MimeData(IData hdrs, MimeMultipart_WM mp) throws MimeDataException {
        this.version = 1;
        this.hdrData = null;
        this.pIndex = 0;
        this.numParts = 0;
        this.subType = null;
        this.parameterList = null;
        this.scontenttype = null;
        this.sign = false;
        this.encrypted = false;
        this.first = null;
        this.last = null;
        this.oldCursors = new List();
        this.recurse_flag = false;
        try {
            if (hdrs != null) {
                this.addElement(HEADERS, hdrs);
            }
            this.setSubType(hdrs);
            this.loadMultipart(mp);
        }
        catch (Exception e) {
            MimeDataException mde = new MimeDataException("Error parsing mime message");
            throw mde;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeData(InputStream is) throws MimeDataException {
        block27: {
            InputStream in;
            this.version = 1;
            this.hdrData = null;
            this.pIndex = 0;
            this.numParts = 0;
            this.subType = null;
            this.parameterList = null;
            this.scontenttype = null;
            this.sign = false;
            this.encrypted = false;
            this.first = null;
            this.last = null;
            this.oldCursors = new List();
            this.recurse_flag = false;
            boolean smime = false;
            try {
                in = !(is instanceof ByteArrayInputStream) ? MimeData.cloneStream(is) : is;
            }
            catch (IOException ioe) {
                throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.INVALID_INPUT_STREAM, "");
            }
            in.mark(0);
            Object o = null;
            MimeMessage mimeData = null;
            try {
                Properties props = System.getProperties();
                Session sess = Session.getDefaultInstance((Properties)props, null);
                try {
                    mimeData = new MimeMessage(sess, in);
                }
                catch (MessagingException me) {
                    in.reset();
                    in.mark(0);
                    mimeData = new MimeBodyPart(in);
                }
                finally {
                    in.reset();
                }
                in.reset();
                if (!this.inputVerified(o)) {
                    throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.COULD_NOT_PARSE_STREAM, "");
                }
                this.hdrData = this.loadHeaders(mimeData.getAllHeaders());
                if (this.isSMime(this.hdrData)) {
                    smime = true;
                    throw new Exception();
                }
                this.addElement(HEADERS, this.hdrData);
                o = mimeData.getContent();
                if (this.isSMime(o)) {
                    smime = true;
                    throw new Exception();
                }
                if (o instanceof MimeMultipart_WM) {
                    MimeMultipart_WM mp = (MimeMultipart_WM)((Object)o);
                    this.loadMultipart(mp);
                    break block27;
                }
                MimePartData mpd = MimePartData.create();
                mpd.setSMime(false);
                IData hdrs = this.loadPartHeaders(mimeData.getAllHeaders());
                mpd.setHeaders(hdrs);
                if (o instanceof String) {
                    mpd.setContent((String)o);
                    this.addElement(PART, mpd);
                    break block27;
                }
                if (o instanceof InputStream) {
                    mpd.setContent((InputStream)o);
                    this.addElement(PART, mpd);
                    break block27;
                }
                throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.COULD_NOT_PARSE_STREAM, "", o.getClass().getName());
            }
            catch (Exception e) {
                try {
                    in.reset();
                }
                catch (IOException ioe) {
                    throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.BAD_STREAM, "");
                }
                MimeDataException mde = e.getMessage() != null ? (e instanceof UnsupportedEncodingException ? new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.INVALID_ENCODING, "", e.getMessage()) : new MimeDataException(e.getMessage())) : new MimeDataException();
                if (smime) {
                    InputStream decode_stream;
                    String encoding = MimeDataUtil.getHeaderValue(this.hdrData, "content-transfer-encoding");
                    try {
                        byte[] content;
                        in.mark(0);
                        InternetHeaders headers = new InternetHeaders(in);
                        try {
                            content = ASCIIUtility.getBytes((InputStream)in);
                        }
                        catch (IOException ioex) {
                            throw new MimeDataException(ioex.getMessage());
                        }
                        finally {
                            in.reset();
                        }
                        is = new ByteArrayInputStream(content);
                        decode_stream = MimeUtility.decode((InputStream)is, (String)encoding);
                    }
                    catch (MessagingException me) {
                        throw new MimeDataException(me.getMessage());
                    }
                    catch (IOException ioe) {
                        throw new MimeDataException(ioe.getMessage());
                    }
                    mde.setSMime();
                    mde.setSigned(this.sign);
                    mde.setEncrypted(this.encrypted);
                    mde.setContentype(this.scontenttype);
                    mde.setHeaders(this.hdrData);
                    mde.setContent(decode_stream);
                }
                mde.setInputStream(in);
                throw mde;
            }
        }
    }

    private boolean isSMime(Object obj) {
        if (obj instanceof SignedContent) {
            SignedContent sc = (SignedContent)obj;
            this.scontenttype = sc.getSMimeType();
            this.sign = true;
            return true;
        }
        if (obj instanceof EncryptedContent) {
            this.scontenttype = "enveloped-data";
            this.encrypted = true;
            return true;
        }
        try {
            if (obj instanceof IData) {
                if (MimeDataUtil.isEncrypted(obj)) {
                    this.encrypted = true;
                    return true;
                }
                if (MimeDataUtil.isSigned(obj)) {
                    this.sign = true;
                    return true;
                }
            }
        }
        catch (MimeDataException mimeDataException) {
            // empty catch block
        }
        return false;
    }

    private boolean inputVerified(Object o) {
        boolean rtn = true;
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() == 0) {
                rtn = false;
            }
        } else if (o instanceof InputStream) {
            InputStream in = (InputStream)o;
            try {
                if (in.available() == 0) {
                    rtn = false;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return rtn;
    }

    private IData loadPartHeaders(Enumeration headers) throws Exception {
        IData headersData = IDataFactory.create();
        IDataCursor idc = headersData.getCursor();
        boolean encoding_found = false;
        while (headers.hasMoreElements()) {
            Header hdr = (Header)headers.nextElement();
            String name = hdr.getName().toLowerCase();
            if (!name.startsWith("content")) continue;
            if (name.equalsIgnoreCase("content-transfer-encoding")) {
                encoding_found = true;
            }
            idc.insertAfter(hdr.getName(), MimeUtility.decodeText((String)hdr.getValue()));
        }
        if (!encoding_found) {
            idc.insertAfter("content-transfer-encoding", "7bit");
        }
        return headersData;
    }

    private IData loadHeaders(Enumeration headers) throws Exception {
        IData headersData = IDataFactory.create();
        IDataCursor idc = headersData.getCursor();
        boolean encoding_found = false;
        boolean ctype_found = false;
        while (headers.hasMoreElements()) {
            Header hdr = (Header)headers.nextElement();
            if (hdr.getName().equalsIgnoreCase("content-transfer-encoding")) {
                encoding_found = true;
            }
            if (hdr.getName().equalsIgnoreCase("content-type")) {
                ctype_found = true;
            }
            idc.insertAfter(hdr.getName(), MimeUtility.decodeText((String)hdr.getValue()));
        }
        if (!encoding_found) {
            idc.insertAfter("content-transfer-encoding", "7bit");
        }
        if (!ctype_found) {
            idc.insertAfter("content-type", "text/plain");
        }
        idc.destroy();
        return headersData;
    }

    private void loadMultipart(MimeMultipart_WM mp) throws Exception {
        int count = mp.getCount();
        for (int i = 0; i < count; ++i) {
            MimePartData mpd;
            IData hdrs;
            BodyPart mbp = mp.getBodyPart(i);
            Object o = mbp.getContent();
            if (o instanceof MimeMultipart_WM) {
                hdrs = this.loadHeaders(mbp.getAllHeaders());
                MimeMultipart_WM mp1 = (MimeMultipart_WM)((Object)o);
                MimeData md = new MimeData(hdrs, mp1);
                this.addElement(PART, md);
                continue;
            }
            if (o instanceof InputStream) {
                mpd = MimePartData.create();
                mpd.setSMime(false);
                hdrs = this.loadHeaders(mbp.getAllHeaders());
                mpd.setHeaders(hdrs);
                mpd.setContent((InputStream)o);
                this.addElement(PART, mpd);
                continue;
            }
            if (o instanceof String) {
                String content = (String)o;
                MimePartData mpd2 = MimePartData.create();
                mpd2.setSMime(false);
                ByteArrayInputStream out = new ByteArrayInputStream(EncUtil.getNetBytes(content));
                hdrs = this.loadHeaders(mbp.getAllHeaders());
                mpd2.setHeaders(hdrs);
                mpd2.setContent(out);
                this.addElement(PART, mpd2);
                continue;
            }
            this.hdrData = this.loadHeaders(mbp.getAllHeaders());
            o = mbp.getContent();
            if (this.isSMime(this.hdrData) || this.isSMime(o)) {
                mpd = MimePartData.create();
                mpd.setHeaders(this.hdrData);
                mpd.setContent(mbp.getInputStream());
                mpd.setSMime(true);
                this.addElement(PART, mpd);
                continue;
            }
            throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.UNKNOWN_CONTENT, "", o.getClass().getName());
        }
    }

    public InputStream getInputStream() {
        return null;
    }

    private void addElement(String key, Object value) {
        DataElement data = new DataElement(this, key, value);
        if (this.first == null) {
            this.last = this.first = data;
        } else {
            data.insert(data, this.last);
            this.last = data;
        }
        ++this.size;
    }

    private void setContentType() throws MessagingException {
        IDataHashCursor idhc = this.hdrData.getHashCursor();
        this.ctype = idhc.first("content-type") ? new ContentType((String)idhc.getValue()) : new ContentType("text/plain");
    }

    public void setSubType(String stype, IData headers) throws MimeDataException {
        if (stype != null) {
            this.setSubType(stype);
        } else if (headers != null) {
            this.setSubType(headers);
        }
    }

    public void setSubType(String stype) {
        this.subType = stype;
    }

    public void setSubType(IData headers) throws MimeDataException {
        IDataHashCursor idhc = headers.getHashCursor();
        while (idhc.next()) {
            String name = idhc.getKey().toLowerCase();
            if (!name.equalsIgnoreCase("content-type")) continue;
            String value = (String)idhc.getValue();
            if (!value.toLowerCase().startsWith(MULTIPART)) break;
            try {
                ContentType ct = new ContentType(value);
                String stype = ct.getSubType();
                if (stype != null) {
                    this.setSubType(stype);
                }
                this.parameterList = ct.getParameterList();
                break;
            }
            catch (ParseException pe) {
                throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.INVALID_CONTENT_TYPE, "");
            }
        }
        idhc.destroy();
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void setParameterList(ParameterList parameterList) {
        this.parameterList = parameterList;
    }

    public String getContentType() {
        return this.ctype.getBaseType();
    }

    public String getPrimaryType() {
        return this.ctype.getPrimaryType();
    }

    public String getSubType() {
        if (this.subType != null) {
            return this.subType;
        }
        if (this.ctype != null) {
            return this.ctype.getSubType();
        }
        return null;
    }

    private String getBoundary() {
        return this.ctype.getParameter("boundary");
    }

    public IDataCursor getCursor() {
        return this.getCursor(null);
    }

    public IDataIndexCursor getIndexCursor() {
        return IndexCursor.create(this.getCursor());
    }

    public IDataTreeCursor getTreeCursor() {
        return TreeCursor.create(this.getCursor());
    }

    public final IDataHashCursor getHashCursor() {
        return HashCursor.create(this.getCursor());
    }

    public IDataSharedCursor getSharedCursor() {
        return DataSharedCursorEmulator.create(this.getCursor());
    }

    private DataCursor getCursor(DataElement item) {
        DataCursor ret = null;
        if (this.oldCursors != null && this.oldCursors.size() > 0) {
            ret = (DataCursor)this.oldCursors.removeLastElement();
        }
        if (ret == null) {
            ret = new DataCursor(item, this);
        }
        ret.init(item, this);
        return ret;
    }

    public static IData create() {
        return new MimeData();
    }

    public static MimeData create(InputStream is) {
        try {
            return new MimeData(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    public IData copy() {
        MimeData copy = new MimeData();
        DataElement e = this.first;
        while (e != null) {
            DataElement e1 = new DataElement(copy, e.key, e.value);
            e1.addToEnd();
            e = e.next;
        }
        return copy;
    }

    public String toString() {
        if (this.recurse_flag) {
            return " >>> IData object recursed <<< ";
        }
        this.recurse_flag = true;
        DataElement de = this.first;
        StringBuffer sb = new StringBuffer();
        sb.append(">>>MimeData:");
        while (de != null) {
            sb.append(de.key);
            sb.append("=");
            sb.append(de.value);
            de = de.next;
            if (de == null) break;
            sb.append(",");
        }
        sb.append("<<<");
        this.recurse_flag = false;
        return sb.toString();
    }

    private static ByteArrayInputStream cloneStream(InputStream input) throws IOException {
        int bytesread;
        ByteOutputBuffer out = new ByteOutputBuffer();
        byte[] buffer = new byte[32768];
        while ((bytesread = input.read(buffer)) != -1) {
            out.write(buffer, 0, bytesread);
        }
        ByteArrayInputStream output = new ByteArrayInputStream(out.toByteArray());
        out = null;
        buffer = null;
        return output;
    }

    public static void main(String[] args) {
        try {
            String filename = args[0];
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
            MimeData p = MimeData.create(in);
            IDataHashCursor idhc = p.getHashCursor();
            String searchKey = PART;
            if (idhc.next(searchKey)) {
                System.err.println("Key found");
            } else {
                System.err.println("Key not found");
            }
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
        }
    }
}

