/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.mime;

import com.wm.net.mime.MimeData;
import com.wm.net.mime.MimeDataException;
import com.wm.net.mime.resources.MimeExceptionBundle;
import java.io.Serializable;

final class DataElement
implements Serializable {
    DataElement prev;
    DataElement next;
    MimeData ivalue;
    String key;
    Object value;

    DataElement(MimeData ivalue, String key, Object value) {
        this.ivalue = ivalue;
        this.setKey(key);
        this.setValue(value);
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setKey(String key) {
        if (key == null) {
            MimeDataException e = new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.NULL_DATA_KEY, "");
            throw new IllegalArgumentException(e.getMessage());
        }
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void delete() {
        --this.ivalue.size;
        if (this.prev == null) {
            this.ivalue.first = this.next;
        } else {
            this.prev.next = this.next;
        }
        if (this.next == null) {
            this.ivalue.last = this.prev;
        } else {
            this.next.prev = this.prev;
        }
        this.prev = null;
        this.ivalue = null;
    }

    public DataElement insertBefore(String key, Object value) {
        DataElement item = new DataElement(this.ivalue, key, value);
        this.insert(item, this.prev);
        return item;
    }

    public DataElement insertAfter(String key, Object value) {
        DataElement item = new DataElement(this.ivalue, key, value);
        this.insert(item, this);
        return item;
    }

    public DataElement next(String key) {
        DataElement walk = this.next;
        while (walk != null) {
            if (walk.key == key || walk.key.equals(key)) {
                return walk;
            }
            walk = walk.next;
        }
        return null;
    }

    void insert(DataElement data, DataElement afterThis) {
        if (afterThis == null) {
            data.next = this.ivalue.first;
            data.prev = null;
            this.ivalue.first = data;
        } else {
            data.next = afterThis.next;
            data.prev = afterThis;
            afterThis.next = data;
        }
        if (data.next != null) {
            data.next.prev = data;
        } else {
            this.ivalue.last = data;
        }
        ++this.ivalue.size;
    }

    void addToEnd() {
        if (this.ivalue.size == 0) {
            this.ivalue.first = this;
            this.ivalue.last = this;
            this.next = null;
            this.prev = null;
        } else {
            this.prev = this.ivalue.last;
            this.next = null;
            this.ivalue.last.next = this;
            this.ivalue.last = this;
        }
        ++this.ivalue.size;
    }

    void addToFront() {
        if (this.ivalue.size == 0) {
            this.ivalue.first = this;
            this.ivalue.last = this;
            this.next = null;
            this.prev = null;
        } else {
            this.prev = null;
            this.next = this.ivalue.first;
            this.ivalue.first.prev = this;
            this.ivalue.first = this;
        }
        ++this.ivalue.size;
    }
}

