/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.mime;

import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.net.mime.DataElement;
import com.wm.net.mime.MimeData;
import com.wm.util.List;

class DataCursor
implements IDataCursor {
    DataElement now;
    MimeData data;

    DataCursor(DataElement now, MimeData data) {
        this.init(now, data);
    }

    void init(DataElement now, MimeData data) {
        this.now = now;
        this.data = data;
    }

    public void setErrorMode(int errMode) {
    }

    public DataException getLastError() {
        return null;
    }

    public boolean hasMoreErrors() {
        return false;
    }

    public void home() {
        this.now = null;
    }

    public String getKey() {
        if (this.now == null) {
            return null;
        }
        return this.now.key;
    }

    public Object getValue() {
        if (this.now == null) {
            return null;
        }
        return this.now.value;
    }

    public void setKey(String key) {
        if (this.now == null) {
            return;
        }
        this.now.setKey(key);
    }

    public void setValue(Object value) {
        if (this.now == null) {
            return;
        }
        this.now.value = value;
    }

    public boolean delete() {
        if (this.now == null) {
            return false;
        }
        DataElement hold = this.now;
        boolean more = hold.next != null;
        this.now = more ? hold.next : hold.prev;
        hold.delete();
        return more;
    }

    public void insertBefore(String key, Object value) {
        if (this.now != null) {
            this.now = this.now.insertBefore(key, value);
        } else {
            this.now = new DataElement(this.data, key, value);
            this.now.addToFront();
        }
    }

    public void insertAfter(String key, Object value) {
        if (key.equals("headers")) {
            IDataCursor idcS = this.data.getCursor();
            while (idcS.hasMoreData()) {
                idcS.next();
                String keytmp = idcS.getKey();
                if (!keytmp.equals("headers")) continue;
                idcS.setValue(value);
                return;
            }
            idcS.destroy();
        }
        if (this.now != null) {
            this.now = this.now.insertAfter(key, value);
        } else {
            this.now = new DataElement(this.data, key, value);
            this.now.addToEnd();
        }
    }

    public IData insertDataBefore(String key) {
        IData nd = MimeData.create();
        this.insertBefore(key, nd);
        return nd;
    }

    public IData insertDataAfter(String key) {
        IData nd = MimeData.create();
        this.insertAfter(key, nd);
        return nd;
    }

    public boolean next() {
        DataElement newnow = this.now == null ? this.data.first : this.now.next;
        if (newnow == null) {
            return false;
        }
        this.now = newnow;
        return this.now != null;
    }

    public boolean previous() {
        DataElement newnow = null;
        newnow = this.now == null ? this.data.last : this.now.prev;
        if (newnow == null) {
            return false;
        }
        this.now = newnow;
        return this.now != null;
    }

    public boolean next(String key) {
        if (this.now == null) {
            return this._next(this.data.first, key);
        }
        return this._next(this.now.next, key);
    }

    private boolean _next(DataElement walk, String key) {
        while (walk != null) {
            if ((key == null || walk.key == null) && key != walk.key) {
                return false;
            }
            if (walk.key == key || walk.key.equals(key)) {
                this.now = walk;
                return true;
            }
            walk = walk.next;
        }
        return false;
    }

    public boolean previous(String key) {
        if (this.now == null) {
            return this._previous(this.data.last, key);
        }
        return this._previous(this.now.prev, key);
    }

    private boolean _previous(DataElement walk, String key) {
        while (walk != null) {
            if ((key == null || walk.key == null) && key != walk.key) {
                return false;
            }
            if (walk.key == key || walk.key.equals(key)) {
                this.now = walk;
                return true;
            }
            walk = walk.prev;
        }
        return false;
    }

    public boolean first() {
        this.now = this.data.first;
        return this.now != null;
    }

    public boolean first(String key) {
        return this._next(this.data.first, key);
    }

    public boolean last() {
        this.now = this.data.last;
        return this.now != null;
    }

    public boolean last(String key) {
        return this._previous(this.data.last, key);
    }

    public void destroy() {
        if (this.data.oldCursors == null) {
            this.data.oldCursors = new List();
        } else if (this.data.oldCursors.contains(this)) {
            return;
        }
        this.now = null;
        this.data.oldCursors.addElement(this);
    }

    public boolean hasMoreData() {
        if (this.now == null) {
            return this.data.first != null;
        }
        return this.now.next != null;
    }

    public IDataCursor getCursorClone() {
        DataCursor clone = new DataCursor(this.now, this.data);
        return clone;
    }

    public String toString() {
        if (this.now == null) {
            return "IDataCursor:null";
        }
        return "IDataCursor:" + this.now.key;
    }
}

