/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.mime;

import com.wm.net.mime.MimeDataException;
import com.wm.net.mime.MimeMultipart_WM;
import com.wm.net.mime.resources.MimeExceptionBundle;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class DataContentHandler_WM
implements DataContentHandler {
    public Object getContent(DataSource ds) throws IOException {
        int read;
        ContentType ct;
        String contentType = ds.getContentType();
        try {
            ct = new ContentType(contentType);
        }
        catch (ParseException pe) {
            throw new IOException(pe.getMessage());
        }
        String basetype = ct.getBaseType();
        String primtype = ct.getPrimaryType();
        String subtype = ct.getSubType();
        if (primtype.equalsIgnoreCase("multipart") && !subtype.equalsIgnoreCase("signed")) {
            try {
                return new MimeMultipart_WM(ds);
            }
            catch (MessagingException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (!primtype.equalsIgnoreCase("text")) {
            return ds.getInputStream();
        }
        InputStream instream = ds.getInputStream();
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((read = instream.read(buf)) > 0) {
            outstream.write(buf, 0, read);
        }
        outstream.flush();
        String charset = ct.getParameter("charset");
        String content = null;
        byte[] b = outstream.toByteArray();
        if (charset == null) {
            charset = EncUtil.detectEncoding(b);
        }
        content = new String(b, MimeUtility.javaCharset((String)charset));
        return content;
    }

    public Object getTransferData(DataFlavor df, DataSource ds) throws IOException {
        return this.getContent(ds);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
        return flavors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        ContentType ct;
        if (JournalLogger.isLogEnabled(2, 13, 7)) {
            JournalLogger.log(2, 13, 7, new Object[]{mimeType});
        }
        try {
            ct = new ContentType(mimeType);
        }
        catch (ParseException pe) {
            throw new IOException(pe.getMessage());
        }
        String basetype = ct.getBaseType();
        String primtype = ct.getPrimaryType();
        String subtype = ct.getSubType();
        if (primtype.equalsIgnoreCase("multipart") && !subtype.equalsIgnoreCase("signed")) {
            if (obj instanceof MimeMultipart_WM) {
                try {
                    ((MimeMultipart_WM)((Object)obj)).writeTo(os);
                    return;
                }
                catch (MessagingException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                if (!(obj instanceof MimeMultipart)) throw new MimeDataException(MimeExceptionBundle.class, MimeExceptionBundle.CONTENT_DOES_NOT_MATCH, "", mimeType);
                try {
                    ((MimeMultipart)obj).writeTo(os);
                    return;
                }
                catch (MessagingException e) {
                    throw new IOException(e.getMessage());
                }
            }
        } else if (obj instanceof String) {
            String charset = ct.getParameter("charset");
            String str = (String)obj;
            byte[] outarray = charset == null ? EncUtil.getNetBytes(str) : str.getBytes(MimeUtility.javaCharset((String)charset));
            os.write(outarray);
            return;
        } else if (obj instanceof InputStream) {
            int read;
            InputStream instream = (InputStream)obj;
            byte[] b = new byte[8192];
            while ((read = instream.read(b)) > 0) {
                os.write(b, 0, read);
            }
            return;
        } else if (obj instanceof InputStreamReader) {
            int read;
            String charset = ct.getParameter("charset");
            if (charset == null) {
                charset = EncUtil.getNetEncoding();
            }
            InputStreamReader isr = (InputStreamReader)obj;
            OutputStreamWriter osw = new OutputStreamWriter(os, MimeUtility.javaCharset((String)charset));
            char[] b = new char[8192];
            while ((read = isr.read(b, 0, b.length)) > 0) {
                osw.write(b, 0, read);
            }
            osw.flush();
            return;
        } else {
            if (!(obj instanceof byte[])) return;
            os.write((byte[])obj);
        }
    }
}

