/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.email;

import com.wm.net.email.EmailException;
import com.wm.net.email.resources.EmailExceptionBundle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;

public class SmtpStream {
    private BufferedReader in;
    private PrintWriter out;
    private Socket socket;
    protected boolean debug = false;
    protected InputStream msgStream = null;

    public SmtpStream() throws IOException {
        this(null);
    }

    public SmtpStream(String server) throws IOException {
        this(server, 25, false);
    }

    public SmtpStream(String server, int port) throws IOException {
        this(server, port, false);
    }

    public SmtpStream(String server, int port, boolean debug) throws IOException {
        this.debug = debug;
        if (server == null || server.length() == 0) {
            server = System.getProperty("mail.smtp.host");
            if (server == null || server.length() == 0) {
                server = System.getProperty("mail.host");
            }
            if (server == null || server.length() == 0) {
                server = "localhost";
            }
        }
        this.Debug("Creating socket... (" + server + ", " + port + ")");
        this.socket = new Socket(server, port);
        this.Debug("Creating input stream...");
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.Debug("Creating output stream...");
        this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
        this.Debug(this.in.readLine());
        this.sendCommand("HELO " + InetAddress.getLocalHost().getHostName(), 250);
    }

    public void setInputStream(InputStream msgStream) {
        this.msgStream = msgStream;
    }

    public void close() throws IOException {
        this.sendCommand("QUIT", 221);
        this.Debug("Closing input stream...");
        this.in.close();
        this.Debug("Closing output stream...");
        this.out.close();
        this.Debug("Closing socket...");
        this.socket.close();
    }

    public void from(String from) throws IOException {
        this.sendCommand("MAIL FROM: <" + from + ">", 250);
    }

    public void to(String to) throws IOException {
        this.sendCommand("RCPT TO: <" + to + ">", 250);
    }

    public PrintWriter getOutputStream() throws IOException {
        this.sendCommand("DATA", 354);
        return this.out;
    }

    public void sendMessage() throws IOException {
        int lastread = 0;
        if (this.msgStream != null) {
            int read;
            while ((read = this.msgStream.read()) > 0) {
                lastread = read;
                this.out.write(read);
            }
        }
        if (lastread == 10) {
            this.sendCommand(".", 250);
        } else {
            this.sendCommand("\n.", 250);
        }
    }

    public void sendCommand(String c, int reply) throws IOException {
        this.Debug("Sending: " + c);
        this.out.println(c);
        String temp = this.in.readLine();
        this.Debug("Reply: " + temp);
        if (!temp.startsWith("" + reply)) {
            Object[] args = new Object[]{new Integer(reply), temp};
            EmailException e = new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_REPLY, "", args);
            throw new IOException(e.getMessage());
        }
    }

    private void Debug(String info) {
        if (this.debug) {
            System.err.println(info);
        }
    }
}

