/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net.email;

import com.wm.net.email.EmailException;
import com.wm.net.email.SmtpStream;
import com.wm.net.email.resources.EmailExceptionBundle;
import com.wm.net.mime.DataContentHandlerFactory_WM;
import com.wm.util.Config;
import com.wm.util.EncUtil;
import com.wm.util.EncodingNames;
import com.wm.util.JournalLogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class SmtpClient {
    private Object mimeObject = null;
    private Session session = null;
    private String smtpUser = null;
    private String smtpPass = null;
    private URLName urlName = null;
    private MimeMessage msg;
    private MimeMultipart mp = null;
    private SmtpStream smtpstream = null;
    private InternetHeaders streamheaders = null;
    private boolean multipart = false;
    private boolean useMimeStream = false;
    private String charset = null;
    private String hdrCharSet = null;
    private boolean setcc = false;
    private boolean setbcc = false;
    private boolean setmailer = false;
    private String _from = null;
    private String _to = null;
    private String _subject = null;
    private Vector attachedFiles = new Vector();

    SmtpClient() throws MessagingException {
        this(null, null, null);
    }

    public SmtpClient(String mailhost) throws MessagingException {
        this(mailhost, null, null);
    }

    public SmtpClient(String mailhost, InputStream mimeStream) throws MessagingException {
        this(mailhost, null, mimeStream);
    }

    public SmtpClient(String mailhost, String port) throws MessagingException {
        this(mailhost, port, -1);
    }

    public SmtpClient(String mailhost, String port, String user, String pass) throws MessagingException {
        this(mailhost, port, null, -1, user, pass);
    }

    public SmtpClient(String mailhost, String port, String user, String pass, Properties userprops) throws MessagingException {
        this(mailhost, port, null, -1, user, pass, userprops);
    }

    public SmtpClient(String mailhost, String port, int timeout) throws MessagingException {
        this(mailhost, port, null, timeout);
    }

    public SmtpClient(String mailhost, String port, InputStream mimeStream) throws MessagingException {
        this(mailhost, port, mimeStream, -1);
    }

    public SmtpClient(String mailhost, String port, InputStream mimeStream, int timeout) throws MessagingException {
        this(mailhost, port, mimeStream, -1, null, null);
    }

    public SmtpClient(String mailhost, String port, InputStream mimeStream, int timeout, String user, String pass) throws MessagingException {
        this(mailhost, port, mimeStream, timeout, user, pass, null);
    }

    public SmtpClient(String mailhost, String port, InputStream mimeStream, int timeout, String user, String pass, Properties userprops) throws MessagingException {
        Properties systemProps = System.getProperties();
        Properties props = new Properties(systemProps);
        if (userprops != null) {
            props.putAll((Map<?, ?>)userprops);
        }
        if (mailhost != null) {
            props.put("mail.smtp.host", mailhost);
        }
        int intPort = -1;
        if (port != null) {
            props.put("mail.smtp.port", port);
            intPort = Integer.parseInt(port);
        }
        if (timeout > 0) {
            props.put("mail.smtp.timeout", String.valueOf(timeout));
        }
        if (user != null && pass != null) {
            props.put("mail.smtp.auth", "true");
        }
        this.session = Session.getInstance((Properties)props, null);
        if (JournalLogger.getLevel() >= 6) {
            this.session.setDebug(false);
        }
        this.urlName = new URLName("smtp", mailhost, intPort, null, user, pass);
        if (mimeStream == null) {
            this.useMimeStream = false;
            this.msg = new MimeMessage(this.session);
        } else {
            this.useMimeStream = true;
            this.msg = new MimeMessage(this.session, mimeStream);
        }
        this.setCharset(Config.getProperty("watt.server.email.charset"));
    }

    private static final void validateHeaders(InternetHeaders hdrs) throws Exception {
        Enumeration e = hdrs.getAllHeaders();
        while (e.hasMoreElements()) {
            Header h = (Header)e.nextElement();
            if (h.getName().trim().indexOf(" ") != -1) {
                throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_HEADER, "", h.getName());
            }
            if (h.getValue() == null || h.getValue().length() == 0) {
                throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_HEADER, "", h.getName());
            }
            if (!h.getName().equals(h.getValue())) continue;
            throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_HEADER, "", h.getName());
        }
    }

    private final String checkHeader(String name, String value, InternetHeaders headers) throws Exception {
        if (value == null || value.length() == 0) {
            value = headers.getHeader(name, null);
            if (value == null || value.length() == 0) {
                throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_HEADER, "", name);
            }
        } else {
            headers.removeHeader(name);
            headers.setHeader(name, MimeUtility.encodeText((String)value, (String)this.hdrCharSet, (String)"B"));
        }
        return value;
    }

    private final void outputHeaders(InternetHeaders headers, PrintWriter out) {
        if (headers == null || out == null) {
            return;
        }
        Enumeration e = headers.getAllHeaderLines();
        while (e.hasMoreElements()) {
            out.println(e.nextElement());
        }
        out.println("");
    }

    public void setHeaderCharset(String _hdrCharset) {
        if (_hdrCharset != null && _hdrCharset.length() != 0) {
            this.hdrCharSet = EncodingNames.getIANAName(_hdrCharset);
        }
    }

    public void setCharset(String _charset) {
        if (_charset != null && _charset.length() != 0) {
            this.charset = EncodingNames.getIANAName(_charset);
            if (this.hdrCharSet == null) {
                this.hdrCharSet = this.charset;
            }
        } else {
            String e_charset = Config.getProperty("watt.server.email.charset");
            if (e_charset != null && e_charset.length() != 0) {
                this.setCharset(e_charset);
            } else {
                this.setCharset("utf-8");
            }
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setTo(String[] to) throws AddressException, MessagingException, EmailException, UnsupportedEncodingException {
        if (to == null) {
            return;
        }
        InternetAddress[] recipients = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            if (to[i] == null) continue;
            recipients[i] = new InternetAddress(to[i]);
            recipients[i].setPersonal(recipients[i].getPersonal(), MimeUtility.mimeCharset((String)this.hdrCharSet));
        }
        this.msg.setRecipients(Message.RecipientType.TO, (Address[])recipients);
    }

    public void setTo(String to) throws AddressException, MessagingException, EmailException, UnsupportedEncodingException {
        if (to != null && to.trim().length() != 0) {
            InternetAddress[] recipients = InternetAddress.parse((String)to, (boolean)false);
            if (recipients == null) {
                throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_TO_FIELD, "", to);
            }
            for (int i = 0; i < recipients.length; ++i) {
                recipients[i].setPersonal(recipients[i].getPersonal(), MimeUtility.mimeCharset((String)this.hdrCharSet));
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])recipients);
            this._to = to;
        } else {
            Address[] _reciepient_addr = this.msg.getAllRecipients();
            if (_reciepient_addr == null || _reciepient_addr.length == 0 || _reciepient_addr[0] == null) {
                throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_RECIPIENT_FIELD, "", "null");
            }
        }
    }

    public void setSubject(String subject) throws MessagingException, EmailException {
        if (subject != null && subject.length() != 0) {
            this._subject = subject;
            this.msg.setSubject(subject, MimeUtility.mimeCharset((String)this.hdrCharSet));
        }
    }

    public void setFrom(String from) throws AddressException, MessagingException, UnsupportedEncodingException, EmailException {
        if (from != null && from.trim().length() != 0) {
            this._from = from;
            InternetAddress _from_addr = new InternetAddress(from);
            _from_addr.setPersonal(_from_addr.getPersonal(), MimeUtility.mimeCharset((String)this.hdrCharSet));
            this.msg.setFrom((Address)_from_addr);
        } else if (this.session.getProperty("mail.smtp.from") != null) {
            this._from = this.session.getProperty("mail.smtp.from");
            InternetAddress _from_addr = new InternetAddress(this._from);
            _from_addr.setPersonal(_from_addr.getPersonal(), MimeUtility.mimeCharset((String)this.hdrCharSet));
            this.msg.setFrom((Address)_from_addr);
        } else {
            Address[] _from_addr = this.msg.getFrom();
            if (_from_addr == null || _from_addr[0] == null) {
                this.msg.setFrom();
            }
        }
    }

    public void setCC(String cc) throws AddressException, MessagingException, EmailException, UnsupportedEncodingException {
        if (cc != null && cc.trim().length() != 0) {
            InternetAddress[] ccaddress = InternetAddress.parse((String)cc, (boolean)false);
            if (ccaddress == null) {
                throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_CC_FIELD, "", cc);
            }
            for (int i = 0; i < ccaddress.length; ++i) {
                ccaddress[i].setPersonal(ccaddress[i].getPersonal(), MimeUtility.mimeCharset((String)this.hdrCharSet));
            }
            this.msg.setRecipients(Message.RecipientType.CC, (Address[])ccaddress);
            this.setcc = true;
        }
    }

    public void setAuth(String user, String pass) {
        this.smtpUser = user;
        this.smtpPass = pass;
    }

    public void setBCC(String bcc) throws AddressException, MessagingException, EmailException, UnsupportedEncodingException {
        if (bcc != null && bcc.trim().length() != 0) {
            InternetAddress[] bccaddress = InternetAddress.parse((String)bcc, (boolean)false);
            if (bccaddress == null) {
                throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_BCC_FIELD, "", bcc);
            }
            for (int i = 0; i < bccaddress.length; ++i) {
                bccaddress[i].setPersonal(bccaddress[i].getPersonal(), MimeUtility.mimeCharset((String)this.hdrCharSet));
            }
            this.msg.setRecipients(Message.RecipientType.BCC, (Address[])bccaddress);
            this.setbcc = true;
        }
    }

    public void setMailer(String mailer) throws MessagingException, EmailException {
        this.setmailer = true;
        try {
            if (mailer != null) {
                this.msg.setHeader("X-Mailer", MimeUtility.encodeText((String)mailer, (String)this.hdrCharSet, (String)"B"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_CHARSET, "", this.charset);
        }
    }

    public void setComment(String comment) throws MessagingException {
        if (this.mp == null) {
            this.multipart = true;
            this.mp = new MimeMultipart();
        }
        if (comment != null && comment.length() > 0) {
            MimeBodyPart firstPart = new MimeBodyPart();
            firstPart.setText(comment, MimeUtility.mimeCharset((String)this.charset));
            this.mp.addBodyPart((BodyPart)firstPart);
        }
    }

    public void setMimeObject(Object value) throws Exception {
        this.mimeObject = value;
        String from = null;
        String subject = null;
        String to = null;
        if (this.mimeObject instanceof InputStream) {
            InputStream mimeStream = (InputStream)this.mimeObject;
            if (!(mimeStream instanceof ByteArrayInputStream) && !(mimeStream instanceof BufferedInputStream)) {
                mimeStream = new BufferedInputStream(mimeStream);
            }
            this.streamheaders = new InternetHeaders(mimeStream);
            SmtpClient.validateHeaders(this.streamheaders);
            from = this.checkHeader("From", this._from, this.streamheaders);
            to = this.checkHeader("To", this._to, this.streamheaders);
            try {
                subject = this.checkHeader("Subject", this._subject, this.streamheaders);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.smtpstream = new SmtpStream();
            this.smtpstream.from(MimeUtility.encodeText((String)from, (String)MimeUtility.mimeCharset((String)this.hdrCharSet), (String)"B"));
            this.smtpstream.to(MimeUtility.encodeText((String)to, (String)MimeUtility.mimeCharset((String)this.hdrCharSet), (String)"B"));
            this.smtpstream.setInputStream(mimeStream);
        }
    }

    public void addBodyPart(Object content) throws MessagingException, FileNotFoundException, EmailException {
        this.addBodyPart(content, null);
    }

    public void addBodyPart(Object content, String filename) throws MessagingException, FileNotFoundException, EmailException {
        this.addBodyPart(content, filename, null);
    }

    public void addBodyPart(Object content, String filename, String contenttype) throws MessagingException, FileNotFoundException, EmailException {
        this.addBodyPart(content, filename, contenttype, null, null);
    }

    public void addBodyPart(Object content, String filename, String contenttype, String encoding, String ccharset) throws MessagingException, FileNotFoundException, EmailException {
        if (this.mp == null) {
            this.multipart = true;
            this.mp = new MimeMultipart();
        }
        if (contenttype == null || contenttype.length() == 0) {
            contenttype = "text/plain";
        }
        if (encoding == null || encoding.length() == 0) {
            encoding = "7bit";
        }
        if (content == null && filename != null) {
            this.addFile(filename, contenttype, encoding, ccharset);
        } else if (content != null) {
            if (ccharset == null || ccharset.length() == 0) {
                ccharset = this.getCharset();
            }
            this.addContent(content, filename, contenttype, encoding, ccharset);
        } else {
            throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_NO_FILE_CONTENT, "");
        }
    }

    public void setContent(Object content, String contenttype) throws EmailException, FileNotFoundException {
        this.setContent(content, contenttype, null, null);
    }

    public void setContent(Object content, String contenttype, String encoding, String ccharset) throws EmailException, FileNotFoundException {
        if (contenttype == null || contenttype.trim().length() == 0) {
            contenttype = "text/plain";
        }
        if (encoding == null || encoding.trim().length() == 0) {
            encoding = "7bit";
        }
        if (ccharset == null || ccharset.trim().length() == 0) {
            ccharset = this.charset;
        }
        try {
            this.addContent(content, null, contenttype, encoding, ccharset);
        }
        catch (MessagingException me) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws Exception {
        if (!this.setcc) {
            this.setCC(null);
        }
        if (!this.setbcc) {
            this.setBCC(null);
        }
        if (!this.setmailer) {
            this.setMailer("sendmsg");
        }
        if (this.smtpstream == null) {
            this.msg.setSentDate(new Date());
            if (this.mp != null) {
                this.msg.setContent((Multipart)this.mp);
            }
            Transport transport = this.session.getTransport(this.urlName);
            if (!this.useMimeStream) {
                this.msg.saveChanges();
            } else {
                this.msg.setHeader("MIME-Version", "1.0");
            }
            try {
                transport.connect(this.urlName.getHost(), this.urlName.getUsername(), this.urlName.getPassword());
                transport.sendMessage((Message)this.msg, this.msg.getAllRecipients());
            }
            finally {
                if (transport.isConnected()) {
                    transport.close();
                }
            }
            this.closeFiles();
        } else {
            PrintWriter outstream = this.smtpstream.getOutputStream();
            this.outputHeaders(this.streamheaders, outstream);
            this.smtpstream.sendMessage();
            this.smtpstream.close();
        }
    }

    private void closeFiles() {
        for (int i = 0; i < this.attachedFiles.size(); ++i) {
            FileInputStream fis = (FileInputStream)this.attachedFiles.elementAt(i);
            if (fis == null) continue;
            try {
                fis.close();
                fis = null;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addFile(String filename, String contenttype, String encoding, String ccharset) throws MessagingException, FileNotFoundException, EmailException {
        FileInputStream content = null;
        File file = new File(filename);
        Object nextPart = null;
        nextPart = this.multipart ? new MimeBodyPart() : this.msg;
        if (!file.exists()) {
            throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_NO_FILE_CONTENT, "");
        }
        if (!EncUtil.isAscii(file)) {
            encoding = "base64";
        }
        if (ccharset != null) {
            contenttype = contenttype + "; charset=" + MimeUtility.mimeCharset((String)ccharset);
        }
        content = new FileInputStream(filename);
        try {
            this.attachedFiles.addElement(content);
            nextPart.setContent((Object)content, contenttype);
            nextPart.setHeader("Content-Transfer-Encoding", encoding);
            int last = filename.lastIndexOf(System.getProperty("file.separator"));
            String disposition = last >= 0 ? filename.substring(last + 1) : filename;
            nextPart.setFileName(MimeUtility.encodeText((String)disposition, (String)ccharset, (String)"B"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_CHARSET, "", ccharset);
        }
        if (this.mp != null) {
            this.mp.addBodyPart((BodyPart)((MimeBodyPart)nextPart));
        }
    }

    private void addContent(Object content, String filename, String contenttype, String encoding, String ccharset) throws MessagingException, FileNotFoundException, EmailException {
        Object nextPart = null;
        nextPart = this.multipart ? new MimeBodyPart() : this.msg;
        if ((contenttype = contenttype + "; charset=" + MimeUtility.mimeCharset((String)ccharset)).toLowerCase().startsWith("text")) {
            if (content instanceof String) {
                nextPart.setContent(content, contenttype);
                if (!EncUtil.isAscii((String)content)) {
                    encoding = "base64";
                }
            } else if (content instanceof InputStream) {
                String text = EncUtil.getString((InputStream)content);
                nextPart.setContent((Object)text, contenttype);
                if (!EncUtil.isAscii(text)) {
                    encoding = "base64";
                }
            } else {
                nextPart.setContent(content, contenttype);
            }
        } else {
            if (content instanceof String && !EncUtil.isAscii((String)content)) {
                encoding = "base64";
            }
            nextPart.setContent(content, contenttype);
        }
        try {
            if (filename != null && filename.length() > 0) {
                nextPart.setFileName(MimeUtility.encodeText((String)filename, (String)ccharset, (String)"B"));
            }
            if (encoding != null && encoding.length() > 0) {
                nextPart.setHeader("Content-Transfer-Encoding", MimeUtility.encodeText((String)encoding, (String)ccharset, (String)"B"));
            }
            if (this.mp != null) {
                this.mp.addBodyPart((BodyPart)((MimeBodyPart)nextPart));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new EmailException(EmailExceptionBundle.class, EmailExceptionBundle.SMTP_INVALID_CHARSET, "", ccharset);
        }
    }

    public static void main(String[] args) {
        try {
            DataContentHandlerFactory_WM.init();
            String filename1 = "/home/sagarwal/xml/mets.xml";
            String filename2 = "/home/sagarwal/I18N/output.utf8";
            SmtpClient smtp = new SmtpClient("sanjai.org");
            smtp.setTo("sagarwal@sanjai.org");
            smtp.setFrom("sagarwal@sanjai.org");
            smtp.setSubject("This is a test of the SmtpClient");
            smtp.addBodyPart(null, "/home/sagarwal/I18N/output.utf8", "text/plain", null, null);
            smtp.addBodyPart(null, "/home/sagarwal/I18N/output.sjis", "text/plain", null, null);
            smtp.addBodyPart(null, "/home/sagarwal/I18N/output.sjis", "application/plain", null, null);
            smtp.send();
        }
        catch (Exception e) {
            System.out.println("Caught excpection: " + e);
        }
    }
}

